/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.GeographicOffsets2D;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Transformation;

@XmlTransient
public class GeographicOffsets
extends AbstractProvider {
    private static final long serialVersionUID = -6246011184175753328L;
    static final ParameterDescriptor<Double> TX;
    static final ParameterDescriptor<Double> TY;
    static final ParameterDescriptor<Double> TZ;
    private static final ParameterDescriptorGroup PARAMETERS;
    private static final GeographicOffsets INSTANCE;

    public static GeographicOffsets provider() {
        return INSTANCE;
    }

    public GeographicOffsets() {
        this(PARAMETERS, 3);
    }

    GeographicOffsets(ParameterDescriptorGroup parameters, byte dimension) {
        super(Transformation.class, parameters, EllipsoidalCS.class, false, EllipsoidalCS.class, false, dimension);
    }

    ParameterDescriptor<Double> vertical() {
        return TZ;
    }

    @Override
    public final AbstractProvider inverse() {
        return this;
    }

    @Override
    public AbstractProvider variantFor(MathTransform transform) {
        if (this.getClass() == GeographicOffsets.class && GeographicOffsets.maxDimension(transform) < 3) {
            return GeographicOffsets2D.provider();
        }
        return this;
    }

    @Override
    public MathTransform createMathTransform(MathTransformProvider.Context context) {
        Parameters pv = Parameters.castOrWrap(context.getCompletedParameters());
        return MathTransforms.translation(pv.doubleValue(TX), pv.doubleValue(TY), pv.doubleValue(this.vertical()));
    }

    static {
        ParameterBuilder builder = GeographicOffsets.builder();
        TY = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8601")).addName("Latitude offset")).create(0.0, Units.DEGREE);
        TX = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8602")).addName("Longitude offset")).addName("Longitude rotation")).create(0.0, Units.DEGREE);
        TZ = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8603")).addName("Vertical Offset")).create(0.0, Units.METRE);
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("9660")).addName("Geographic3D offsets")).createGroup(new GeneralParameterDescriptor[]{TY, TX, TZ});
        INSTANCE = new GeographicOffsets();
    }
}

