/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.elasticsearch.v5;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.transport.TransportAddress;

public class TransportAddressCache {
    private List<TransportAddress> transportAddresses = new ArrayList<TransportAddress>();
    private String transportAddressesStr;

    public synchronized void addDiscoveryNode(TransportAddress ... transportAddress) {
        this.transportAddresses.addAll(Arrays.asList(transportAddress));
        this.transportAddressesStr = this.format();
    }

    public synchronized void removeDiscoveryNode(TransportAddress transportAddress) {
        ArrayList<TransportAddress> nodesBuilder = new ArrayList<TransportAddress>();
        for (TransportAddress otherNode : this.transportAddresses) {
            if (otherNode.getAddress().equals(transportAddress.getAddress())) continue;
            nodesBuilder.add(otherNode);
        }
        this.transportAddresses = nodesBuilder;
        this.transportAddressesStr = this.format();
    }

    private String format() {
        StringBuilder stringBuilder = new StringBuilder();
        for (TransportAddress node : this.transportAddresses) {
            stringBuilder.append(node.getAddress()).append(":").append(node.getPort()).append(";");
        }
        return stringBuilder.toString();
    }

    public String transportAddress() {
        return this.transportAddressesStr;
    }
}

