/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.nav.model;

import de.pdark.decentxml.Attribute;
import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.Namespace;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.Text;
import de.pdark.decentxml.XMLParseException;
import de.pdark.decentxml.XMLTokenizer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jcr.PropertyType;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.ide.eclipse.core.EclipseResources;
import org.apache.sling.ide.eclipse.core.ProjectUtil;
import org.apache.sling.ide.eclipse.core.ServerUtil;
import org.apache.sling.ide.eclipse.core.internal.Activator;
import org.apache.sling.ide.eclipse.ui.WhitelabelSupport;
import org.apache.sling.ide.eclipse.ui.nav.model.DirNode;
import org.apache.sling.ide.eclipse.ui.nav.model.GenericJcrRootFile;
import org.apache.sling.ide.eclipse.ui.nav.model.JcrProperty;
import org.apache.sling.ide.eclipse.ui.nav.model.ModifiableProperties;
import org.apache.sling.ide.eclipse.ui.nav.model.SyncDir;
import org.apache.sling.ide.eclipse.ui.nav.model.TolerantXMLParser;
import org.apache.sling.ide.eclipse.ui.views.PropertyTypeSupport;
import org.apache.sling.ide.filter.Filter;
import org.apache.sling.ide.filter.FilterResult;
import org.apache.sling.ide.log.Logger;
import org.apache.sling.ide.serialization.SerializationKind;
import org.apache.sling.ide.serialization.SerializationKindManager;
import org.apache.sling.ide.serialization.SerializationManager;
import org.apache.sling.ide.sync.content.WorkspaceFile;
import org.apache.sling.ide.transport.NodeTypeRegistry;
import org.apache.sling.ide.transport.Repository;
import org.apache.sling.ide.transport.RepositoryException;
import org.apache.sling.ide.transport.RepositoryPath;
import org.apache.sling.ide.transport.ResourceProxy;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.xml.sax.SAXException;

public class JcrNode
implements IAdaptable {
    private static final WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
    final GenericJcrRootFile underlying;
    JcrNode parent;
    DirNode dirSibling;
    final List<JcrNode> children = new LinkedList<JcrNode>();
    Element domElement;
    private IResource resource;
    private boolean resourceChildrenAdded = false;
    final ModifiableProperties properties = new ModifiableProperties(this);
    final Set<JcrNode> hiddenChildren = new HashSet<JcrNode>();

    JcrNode() {
        this.underlying = this instanceof GenericJcrRootFile ? (GenericJcrRootFile)this : null;
    }

    JcrNode(JcrNode parent, Element domElement, IResource resource) {
        this(parent, domElement, parent.underlying, resource);
    }

    JcrNode(JcrNode parent, Element domElement, GenericJcrRootFile underlying, IResource resource) {
        if (parent == null) {
            throw new IllegalArgumentException("parent must not be null");
        }
        this.parent = parent;
        this.domElement = domElement;
        this.underlying = underlying;
        this.resource = resource;
        parent.addChild(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[dom:" + String.valueOf(this.domElement) + ", file:" + String.valueOf(this.resource) + ", jcrPath:" + this.getJcrPath() + "]";
    }

    public int hashCode() {
        if (this.underlying == null) {
            if (this.resource == null) {
                if (this.domElement == null) {
                    return this.toString().hashCode();
                }
                Element domElementCopy = this.domElement.copy();
                domElementCopy.clearChildren();
                return domElementCopy.toString().hashCode() + this.parent.hashCode();
            }
            return this.resource.getFullPath().hashCode();
        }
        if (this.domElement == null) {
            return this.underlying.hashCode();
        }
        Element domElementCopy = this.domElement.copy();
        domElementCopy.clearChildren();
        return this.underlying.hashCode() + domElementCopy.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JcrNode)) {
            return false;
        }
        JcrNode other = (JcrNode)obj;
        if (this.resource != null && other.resource != null) {
            return this.resource.equals((Object)other.resource);
        }
        if (this.resource != null && other.resource == null) {
            return false;
        }
        if (this.resource == null && other.resource != null) {
            return false;
        }
        if (other.underlying == null && this.underlying != null) {
            return false;
        }
        if (other.underlying != null && this.underlying == null) {
            return false;
        }
        if (this.underlying != null && !this.underlying.equals(other.underlying)) {
            return false;
        }
        if (this.parent != null && other.parent != null) {
            if (!this.parent.equals(other.parent)) {
                return false;
            }
            Element domElementCopy = this.domElement.copy();
            domElementCopy.clearChildren();
            Element otherDomElementCopy = other.domElement.copy();
            otherDomElementCopy.clearChildren();
            return domElementCopy.toString().equals(otherDomElementCopy.toString());
        }
        return this.toString().equals(obj.toString());
    }

    protected void addChild(JcrNode jcrNode) {
        if (!this.children.contains(jcrNode)) {
            for (JcrNode existingChild : this.children) {
                if (!existingChild.getName().equals(jcrNode.getName())) continue;
                existingChild.setResource(jcrNode.resource);
                return;
            }
            this.children.add(jcrNode);
        }
    }

    public String getLabel() {
        if (this.domElement != null && this.resource != null) {
            return ISO9075.decode((String)this.getDomName());
        }
        if (this.domElement != null && this.resource == null) {
            return ISO9075.decode((String)this.getDomName());
        }
        if (this.resource != null) {
            return this.resource.getName();
        }
        return "n/a";
    }

    public String getDescription() {
        return this.getJcrPath();
    }

    public boolean hasChildren() {
        boolean members;
        try {
            members = this.resource != null && this.resource instanceof IFolder && ((IFolder)this.resource).members().length > 0;
        }
        catch (CoreException coreException) {
            members = false;
        }
        return this.children.size() > 0 || members;
    }

    public void hide(JcrNode node) {
        this.hiddenChildren.add(node);
    }

    Object[] filterHiddenChildren(Collection<JcrNode> collection, boolean hideEmptyNodes) {
        JcrNode jcrNode;
        Iterator it;
        LinkedList<JcrNode> values = new LinkedList<JcrNode>(collection);
        for (JcrNode hiddenNode : this.hiddenChildren) {
            values.remove(hiddenNode);
        }
        if (hideEmptyNodes) {
            it = values.iterator();
            while (it.hasNext()) {
                jcrNode = (JcrNode)it.next();
                if (!jcrNode.isEmptyNode()) continue;
                it.remove();
            }
        }
        it = values.iterator();
        while (it.hasNext()) {
            DirNode dirNode;
            JcrNode effectiveSibling;
            jcrNode = (JcrNode)it.next();
            if (!(jcrNode instanceof DirNode) || (effectiveSibling = (dirNode = (DirNode)jcrNode).getEffectiveSibling()) == null) continue;
            it.remove();
        }
        return values.toArray();
    }

    private boolean isEmptyNode() {
        if (this.resource != null) {
            return false;
        }
        if (this.children.size() != 0) {
            return false;
        }
        if (this.domElement == null) {
            return true;
        }
        if (this.domElement.hasChildren()) {
            return false;
        }
        return this.domElement.getAttributes().size() == 0;
    }

    public Object[] getChildren(boolean hideEmptyNodes) {
        if (!this.resourceChildrenAdded) {
            this.initChildren();
        }
        return this.filterHiddenChildren(this.children, true);
    }

    void initChildren() {
        try {
            if (this.resourceChildrenAdded) {
                throw new IllegalStateException("Children already loaded");
            }
            HashSet<String> childrenNames = new HashSet<String>();
            for (JcrNode node : this.children) {
                childrenNames.add(node.getName());
            }
            if (this.resource != null && this.resource instanceof IFolder) {
                IFolder folder = (IFolder)this.resource;
                IResource[] members = folder.members();
                LinkedList<IResource> membersList = new LinkedList<IResource>(Arrays.asList(members));
                block8: while (membersList.size() > 0) {
                    Iterator it = membersList.iterator();
                    while (it.hasNext()) {
                        IResource iResource = (IResource)it.next();
                        if (this.isDotVltFile(iResource)) {
                            it.remove();
                            continue;
                        }
                        if (this.childShouldNotBeShown(iResource)) {
                            it.remove();
                            continue;
                        }
                        if (!this.isVaultFile(iResource)) continue;
                        try {
                            GenericJcrRootFile gjrf = new GenericJcrRootFile(this, (IFile)iResource);
                            it.remove();
                            gjrf.pickResources(membersList);
                        }
                        catch (XMLParseException xMLParseException) {
                            it.remove();
                        }
                        for (JcrNode node : this.children) {
                            if (childrenNames.contains(node.getName())) continue;
                            childrenNames.add(node.getName());
                        }
                        continue block8;
                    }
                    LinkedList<JcrNode> newNodes = new LinkedList<JcrNode>();
                    Iterator it2 = membersList.iterator();
                    while (it2.hasNext()) {
                        JcrNode node;
                        IResource iResource = (IResource)it2.next();
                        node = DirNode.isDirNode(iResource) ? new DirNode(this, null, iResource) : new JcrNode(this, null, iResource);
                        childrenNames.add(node.getName());
                        newNodes.add(node);
                        it2.remove();
                    }
                }
            }
            this.resourceChildrenAdded = true;
        }
        catch (CoreException e) {
            e.printStackTrace();
            org.apache.sling.ide.eclipse.ui.internal.Activator.getDefault().getPluginLogger().error("Error initializing children: " + String.valueOf((Object)e), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            org.apache.sling.ide.eclipse.ui.internal.Activator.getDefault().getPluginLogger().error("Error initializing children: " + String.valueOf(e), (Throwable)e);
        }
        catch (SAXException e) {
            e.printStackTrace();
            org.apache.sling.ide.eclipse.ui.internal.Activator.getDefault().getPluginLogger().error("Error initializing children: " + String.valueOf(e), (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            org.apache.sling.ide.eclipse.ui.internal.Activator.getDefault().getPluginLogger().error("Error initializing children: " + String.valueOf(e), (Throwable)e);
        }
    }

    private boolean isDotVltFile(IResource res) {
        return res.getType() == 1 && res.getName().equals(".vlt");
    }

    private boolean isVaultFile(IResource iResource) {
        if (!(iResource instanceof IFile)) {
            return false;
        }
        return Activator.getDefault().getSerializationManager().isSerializationFile((WorkspaceFile)EclipseResources.create((IResource)iResource));
    }

    protected boolean childShouldNotBeShown(IResource resource) {
        return false;
    }

    public void setResource(IResource resource) {
        if (this.resource != null) {
            if (resource.equals((Object)this.resource)) {
                return;
            }
            throw new IllegalStateException("can only set resource once");
        }
        this.resource = resource;
    }

    public Image getImage() {
        boolean plainFolder = this.resource != null && this.resource instanceof IFolder;
        String primaryType = this.getProperty("jcr:primaryType").getValueAsString();
        boolean typeFolder = this.probablyFolderType(primaryType);
        boolean typeFile = primaryType != null && (primaryType.equals("nt:file") || primaryType.equals("nt:resource") || primaryType.equals("sling:File"));
        typeFile |= this.resource != null && primaryType == null;
        boolean typeUnstructured = primaryType != null && primaryType.equals("nt:unstructured");
        boolean isVaultFile = this.resource != null && this.isVaultFile(this.resource);
        String mimeType = null;
        mimeType = this.getJcrContentProperty("jcr:mimeType");
        if (mimeType == null) {
            mimeType = this.getProperty("jcr:mimeType").getValueAsString();
        }
        if (typeUnstructured) {
            return WhitelabelSupport.getJcrNodeIcon().createImage();
        }
        if (plainFolder || typeFolder) {
            return workbenchLabelProvider.getImage((Object)ProjectUtil.getSyncDirectory((IProject)this.getProject()));
        }
        if (typeFile && this.resource != null) {
            ImageDescriptor desc;
            if (mimeType != null && mimeType.length() != 0 && (desc = this.getImageDescriptor(this.resource.getName(), mimeType)) != null) {
                return desc.createImage();
            }
            if (isVaultFile) {
                return WhitelabelSupport.getJcrNodeIcon().createImage();
            }
            return workbenchLabelProvider.getImage((Object)this.resource);
        }
        if (this.resource != null && !isVaultFile) {
            return workbenchLabelProvider.getImage((Object)this.resource);
        }
        return WhitelabelSupport.getJcrNodeIcon().createImage();
    }

    private boolean probablyFolderType(String primaryType) {
        return primaryType != null && (primaryType.equals("nt:folder") || primaryType.equals("sling:Folder"));
    }

    private ImageDescriptor getImageDescriptor(String filename, String jcrMimeType) {
        String modifiedFilename;
        if (jcrMimeType.equals("image/jpeg")) {
            modifiedFilename = filename + ".jpg";
        } else if (jcrMimeType.contains("/")) {
            modifiedFilename = filename + "." + jcrMimeType.substring(jcrMimeType.indexOf("/") + 1);
        } else {
            return null;
        }
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(modifiedFilename, null);
    }

    private String getJcrContentProperty(String propertyKey) {
        Object[] objectArray = this.getChildren(false);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            JcrNode jcrNode = (JcrNode)element;
            if ("jcr:content".equals(jcrNode.getName())) {
                return jcrNode.getProperty(propertyKey).getValueAsString();
            }
            ++n2;
        }
        return null;
    }

    private String getPropertyAsString(String propertyKey) {
        String propertyValue;
        if (this.properties != null && (propertyValue = this.properties.getValue(propertyKey)) != null) {
            return String.valueOf(propertyValue);
        }
        return null;
    }

    public String getName() {
        if (this.domElement != null) {
            return ISO9075.decode((String)this.getDomName());
        }
        if (this.resource != null) {
            return this.resource.getName();
        }
        return "";
    }

    private String getDomName() {
        String prefix;
        Object domName = this.domElement.getName();
        Namespace ns = this.domElement.getNamespace();
        if (ns != null && !(prefix = ns.getPrefix()).isEmpty()) {
            domName = prefix + ":" + (String)domName;
        }
        return domName;
    }

    public String getJcrPath() {
        Object prefix;
        if (this.parent == null) {
            prefix = "";
        } else {
            prefix = this.parent.getJcrPath();
            if (!((String)prefix).endsWith("/")) {
                prefix = (String)prefix + "/";
            }
        }
        return (String)prefix + this.getJcrPathName();
    }

    String getJcrPathName() {
        if (this.domElement != null) {
            return ISO9075.decode((String)this.getDomName());
        }
        if (this.resource != null) {
            if (this.underlying != null && this.resource == this.underlying.getResource()) {
                IResource res = this.underlying.getResource();
                String fullname = res.getName();
                if (fullname.endsWith(".xml")) {
                    return fullname.substring(0, fullname.length() - 4);
                }
                return res.getName();
            }
            return this.resource.getName();
        }
        return "";
    }

    public Object getAdapter(Class adapter) {
        return this.doGetAdapter(adapter);
    }

    private Object doGetAdapter(Class adapter) {
        if (adapter == ITabbedPropertySheetPageContributor.class) {
            return new ITabbedPropertySheetPageContributor(){

                public String getContributorId() {
                    return "org.eclipse.ui.navigator.ProjectExplorer";
                }
            };
        }
        if (adapter == IPropertySource.class) {
            return null;
        }
        if (adapter == IFile.class) {
            if (this.resource instanceof IFile) {
                return this.resource;
            }
            return null;
        }
        if (adapter == IFolder.class) {
            if (this.resource instanceof IFolder) {
                return this.resource;
            }
            return null;
        }
        if (adapter == IContributorResourceAdapter.class) {
            return new IContributorResourceAdapter(){

                public IResource getAdaptedResource(IAdaptable adaptable) {
                    if (!(adaptable instanceof JcrNode)) {
                        return null;
                    }
                    JcrNode node = (JcrNode)adaptable;
                    if (node.resource != null) {
                        return node.resource;
                    }
                    return node.underlying.file;
                }
            };
        }
        if (adapter == IResource.class) {
            if (this.resource != null) {
                return this.resource;
            }
            return null;
        }
        if (adapter == ResourceMapping.class) {
            boolean t = true;
            if (!t) {
                return null;
            }
            return new ResourceMapping(){

                public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
                    if (JcrNode.this.resource != null) {
                        return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{JcrNode.this.resource}, 2, 0)};
                    }
                    return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{JcrNode.this.underlying.file}, 2, 0)};
                }

                public IProject[] getProjects() {
                    if (JcrNode.this.resource != null) {
                        return new IProject[]{JcrNode.this.resource.getProject()};
                    }
                    return new IProject[]{JcrNode.this.underlying.file.getProject()};
                }

                public String getModelProviderId() {
                    return "org.apache.sling.ide.eclipse.ui.nav.model.JcrNode.ResourceMapping";
                }

                public Object getModelObject() {
                    if (JcrNode.this.resource != null) {
                        return JcrNode.this.resource;
                    }
                    return JcrNode.this.underlying.file;
                }
            };
        }
        return null;
    }

    public ModifiableProperties getProperties() {
        return this.properties;
    }

    protected boolean isBrowsable() {
        return true;
    }

    public IFile getFileForEditor() {
        if ("nt:folder".equals(this.getPrimaryType())) {
            return null;
        }
        if (this.resource instanceof IFile) {
            return (IFile)this.resource;
        }
        if (this.properties != null && this.properties.getUnderlying() != null && this.properties.getUnderlying().file != null) {
            return this.properties.getUnderlying().file;
        }
        if (this.underlying != null && this.underlying.file != null) {
            return this.underlying.file;
        }
        org.apache.sling.ide.eclipse.ui.internal.Activator.getDefault().getPluginLogger().warn("No file found for editor for node=" + String.valueOf(this));
        return null;
    }

    public IResource getResourceForImportExport() {
        JcrNode thisParent;
        String path = this.getJcrPath();
        StringTokenizer st = new StringTokenizer(path, "/");
        JcrNode root = this.getParent();
        while ((thisParent = root.getParent()) != null) {
            root = thisParent;
        }
        if (!(root instanceof SyncDir)) {
            return null;
        }
        IFolder folder = ((SyncDir)root).getFolder();
        while (st.hasMoreTokens()) {
            String nodeStr = st.nextToken();
            IResource child = folder.findMember(nodeStr);
            if (child == null || !(child instanceof IFolder)) break;
            folder = (IFolder)child;
        }
        return folder;
    }

    public void rename(final String string) {
        if (this.domElement != null && this.underlying != null) {
            this.domElement.setName(string);
            this.underlying.save();
        }
        if (this.resource != null) {
            IWorkspaceRunnable r = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IPath fileRenamePath = JcrNode.this.resource.getParent().getFullPath().append(string);
                    JcrNode.this.resource.move(fileRenamePath, true, monitor);
                    if (JcrNode.this.dirSibling != null) {
                        IPath dirRenamePath = JcrNode.this.dirSibling.getResource().getParent().getFullPath().append(string + ".dir");
                        JcrNode.this.dirSibling.getResource().move(dirRenamePath, true, monitor);
                    }
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(r, null);
            }
            catch (CoreException e) {
                Activator.getDefault().getPluginLogger().error("Error renaming resource (" + String.valueOf(this.resource) + "): " + String.valueOf((Object)e), (Throwable)e);
            }
        }
    }

    public boolean canBeRenamed() {
        if (this.parent == null) {
            return false;
        }
        if (this.resource != null) {
            return true;
        }
        return this.domElement != null && this.underlying != null;
    }

    public JcrNode getParent() {
        return this.parent;
    }

    JcrNode getChild(String name) {
        for (JcrNode child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public IResource getResource() {
        return this.resource;
    }

    private SerializationKind getSerializationKind(String nodeType) {
        SerializationKindManager skm = new SerializationKindManager();
        Repository repo = ServerUtil.getDefaultRepository((IProject)this.getProject());
        if (repo == null) {
            return this.getFallbackSerializationKind(nodeType);
        }
        try {
            skm.init(repo);
            return skm.getSerializationKind(nodeType, new ArrayList());
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return this.getFallbackSerializationKind(nodeType);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createChild(final String childNodeName, final String childNodeType) {
        String thisNodeType = this.getPrimaryType();
        final SerializationKind parentSk = this.getSerializationKind(thisNodeType);
        SerializationKind childSk = this.getSerializationKind(childNodeType);
        final SerializationManager serializationManager = Activator.getDefault().getSerializationManager();
        if (parentSk == SerializationKind.METADATA_FULL) {
            this.createDomChild(childNodeName, childNodeType);
            return;
        } else {
            if (parentSk == SerializationKind.FILE) {
                throw new IllegalStateException("cannot create child of nt:file");
            }
            if (childSk == SerializationKind.FOLDER) {
                IWorkspaceRunnable r = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        IFolder newFolder = JcrNode.this.prepareCreateFolderChild(childNodeName);
                        if (parentSk == SerializationKind.METADATA_PARTIAL) {
                            JcrNode.this.createDomChild(childNodeName, null);
                        }
                        if (!childNodeType.equals("nt:folder")) {
                            JcrNode.this.createVaultFile(newFolder, ".content.xml", childNodeType);
                        }
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(r, null);
                    if (!childNodeType.equals("nt:folder") || parentSk != SerializationKind.FOLDER) return;
                    ServerUtil.triggerIncrementalBuild((IResource)this.resource, null);
                    return;
                }
                catch (CoreException e) {
                    Activator.getDefault().getPluginLogger().error("Error creating child " + childNodeName + ": " + String.valueOf((Object)e), (Throwable)e);
                    e.printStackTrace();
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error creating node", (String)("Error creating child of " + thisNodeType + " with type " + childNodeType + ": " + String.valueOf((Object)e)));
                    return;
                }
            } else if ((parentSk == SerializationKind.FOLDER || parentSk == SerializationKind.METADATA_PARTIAL) && childSk == SerializationKind.METADATA_FULL) {
                this.createVaultFile((IFolder)this.resource, serializationManager.getLocalName(childNodeName) + ".xml", childNodeType);
                return;
            } else if (parentSk == SerializationKind.FOLDER && childSk == SerializationKind.METADATA_PARTIAL) {
                IWorkspaceRunnable r = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        IFolder f = (IFolder)JcrNode.this.resource;
                        IFolder newFolder = null;
                        newFolder = f.getFolder(serializationManager.getLocalName(childNodeName));
                        newFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                        JcrNode.this.createVaultFile(newFolder, ".content.xml", childNodeType);
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(r, null);
                    return;
                }
                catch (CoreException e) {
                    Activator.getDefault().getPluginLogger().error("Error creating child " + childNodeName + ": " + String.valueOf((Object)e), (Throwable)e);
                    e.printStackTrace();
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error creating node", (String)("Error creating child of " + thisNodeType + " with type " + childNodeType + ": " + String.valueOf((Object)e)));
                    return;
                }
            } else if (parentSk != SerializationKind.FOLDER && childSk == SerializationKind.METADATA_PARTIAL) {
                this.createDomChild(childNodeName, childNodeType);
                return;
            } else {
                if (childNodeType.equals("nt:file")) {
                    IFolder f = (IFolder)this.resource;
                    this.createNtFile(f, childNodeName, childNodeType);
                    return;
                }
                Activator.getDefault().getPluginLogger().error("Cannot create child node of type " + childNodeType + ", serializationKind " + String.valueOf(childSk) + " under child node of type " + thisNodeType + ", serializationKind " + String.valueOf(parentSk));
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Error creating node", (String)("Cannot create child of " + thisNodeType + " with type " + childNodeType + " (yet?)"));
                return;
            }
        }
    }

    void createDomChild(String childNodeName, String childNodeType) {
        this.properties.getUnderlying();
        if (this.domElement == this.properties.getDomElement()) {
            try {
                this.createChild(childNodeName, childNodeType, this.domElement, this.underlying);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error creating new JCR node", (String)("The following error occurred: " + e.getMessage()));
            }
        } else {
            try {
                this.createChild(childNodeName, childNodeType, this.properties.getDomElement(), this.properties.getUnderlying());
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error creating new JCR node", (String)("The following error occurred: " + e.getMessage()));
            }
        }
    }

    private void createVaultFile(IFolder parent, String filename, String childNodeType) {
        this.createVaultFileWithContent(parent, filename, childNodeType, null);
    }

    private void createVaultFileWithContent(IFolder parent, String filename, String childNodeType, Element content) {
        Object xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<jcr:root \n    xmlns:sling=\"http://sling.apache.org/jcr/sling/1.0\"\n    xmlns:jcr=\"http://www.jcp.org/jcr/1.0\"\n    jcr:primaryType=\"" + childNodeType + "\"/>";
        IFile file = parent.getFile(filename);
        try {
            if (content != null) {
                Document document = TolerantXMLParser.parse((String)xml, file.getFullPath().toOSString());
                List attributes = content.getAttributes();
                for (Attribute attribute : attributes) {
                    if (attribute.getName().equals("jcr:primaryType")) continue;
                    document.getRootElement().addAttribute(attribute);
                }
                document.getRootElement().addNodes((Collection)content.getChildren());
                xml = document.toXML();
            }
            if (file.exists()) {
                file.setContents((InputStream)new ByteArrayInputStream(((String)xml).getBytes()), true, true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                file.create((InputStream)new ByteArrayInputStream(((String)xml).getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Cannot create JCR node on a File", (String)("Following Exception encountered: " + String.valueOf(e)));
        }
    }

    private void createNtFile(IFolder parent, String filename, String childNodeType) {
        IFile file = parent.getFile(filename);
        if (file.exists()) {
            return;
        }
        try {
            file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)("Cannot create file " + filename), (String)("Following Exception encountered: " + String.valueOf((Object)e)));
        }
    }

    private SerializationKind getFallbackSerializationKind(String nodeType) {
        if (nodeType.equals("nt:file")) {
            return SerializationKind.FILE;
        }
        if (this.probablyFolderType(nodeType)) {
            return SerializationKind.FOLDER;
        }
        return SerializationKind.METADATA_PARTIAL;
    }

    protected void createChild(String nodeName, String nodeType, Element domElement, GenericJcrRootFile effectiveUnderlying) {
        if (domElement == null) {
            throw new IllegalArgumentException("domNode must not be null");
        }
        if (effectiveUnderlying == null) {
            throw new IllegalArgumentException("effectiveUnderlying must not be null");
        }
        Element element = new Element(nodeName);
        if (nodeType != null) {
            element.addAttribute("jcr:primaryType", nodeType);
        }
        StringBuilder indent = new StringBuilder();
        Element parElement = domElement.getParentElement();
        while (parElement != null) {
            indent.append("    ");
            parElement = parElement.getParentElement();
        }
        domElement.addNode((Node)new Text("\n    " + indent.toString()));
        element = domElement.addNode((Node)element);
        domElement.addNode((Node)new Text("\n" + indent.toString()));
        new JcrNode(this, element, null);
        effectiveUnderlying.save();
    }

    public boolean canBeDeleted() {
        if (this.parent == null) {
            return false;
        }
        if (this.resource != null) {
            return true;
        }
        return this.domElement != null && this.underlying != null;
    }

    public void delete() {
        if (this.parent == null) {
            return;
        }
        this.parent.children.remove(this);
        if (this.resource != null) {
            IWorkspaceRunnable r = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    JcrNode.this.resource.delete(true, monitor);
                    if (JcrNode.this.dirSibling != null) {
                        JcrNode.this.dirSibling.getResource().delete(true, monitor);
                    }
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(r, null);
            }
            catch (CoreException e) {
                Activator.getDefault().getPluginLogger().error("Error renaming resource (" + String.valueOf(this.resource) + "): " + String.valueOf((Object)e), (Throwable)e);
            }
        }
        if (this.domElement != null) {
            Element parentNode = this.domElement.getParentElement();
            this.domElement.remove();
            if (parentNode != null) {
                List allChildNodes = parentNode.getNodes();
                boolean nonTextChild = false;
                for (Node node : allChildNodes) {
                    if (node.getType() == XMLTokenizer.Type.TEXT) continue;
                    nonTextChild = true;
                }
                if (!nonTextChild) {
                    Iterator it = allChildNodes.iterator();
                    while (it.hasNext()) {
                        Node cfr_ignored_0 = (Node)it.next();
                        it.remove();
                    }
                    if (!parentNode.hasNodes()) {
                        parentNode.setCompactEmpty(true);
                    }
                }
            }
        }
        if (this.underlying != null) {
            this.underlying.save();
        }
    }

    public IProject getProject() {
        if (this.resource != null) {
            return this.resource.getProject();
        }
        if (this.underlying != null) {
            return this.underlying.file.getProject();
        }
        return null;
    }

    public boolean isInContentXml() {
        return this.domElement != null;
    }

    public boolean canCreateChild() {
        RepositoryPath relativeFilePath;
        Filter filter;
        block3: {
            try {
                IProject project = this.getProject();
                filter = ProjectUtil.loadFilter((IProject)project);
                relativeFilePath = new RepositoryPath(this.getJcrPath());
                if (filter != null) break block3;
                Activator.getDefault().getPluginLogger().error("No filter.xml found for " + String.valueOf(project));
                return true;
            }
            catch (CoreException e) {
                Logger logger = Activator.getDefault().getPluginLogger();
                logger.error("Could not verify child node allowance: " + String.valueOf(this), (Throwable)e);
                return false;
            }
        }
        FilterResult result = filter.filter(relativeFilePath);
        return result == FilterResult.ALLOW;
    }

    public String getPrimaryType() {
        String pt = this.properties.getValue("jcr:primaryType");
        if (pt != null && pt.length() != 0) {
            return pt;
        }
        if (this.resource != null) {
            if (this.resource instanceof IContainer) {
                return "nt:folder";
            }
            return "nt:file";
        }
        return "";
    }

    public void deleteProperty(String displayName) {
        this.properties.deleteProperty(displayName);
    }

    public SyncDir getSyncDir() {
        return this.getParent().getSyncDir();
    }

    public void setPropertyValue(Object key, Object value) {
        this.properties.setPropertyValue(key, value);
    }

    void changePrimaryType(String newPrimaryType) {
        NodeTypeRegistry ntManager;
        Repository repository = ServerUtil.getDefaultRepository((IProject)this.getProject());
        NodeTypeRegistry nodeTypeRegistry = ntManager = repository == null ? null : repository.getNodeTypeRegistry();
        if (ntManager == null) {
            MessageDialog.openWarning(null, (String)"Unable to change primary type", (String)("Unable to change primary type since project " + this.getProject().getName() + " is not associated with a server or the server is not started."));
            return;
        }
        try {
            if (!ntManager.isAllowedPrimaryChildNodeType(this.getParent().getPrimaryType(), newPrimaryType) && !MessageDialog.openQuestion(null, (String)"Unable to change primary type", (String)("Parent (type '" + this.getParent().getPrimaryType() + "') does not accept child with primary type '" + newPrimaryType + "'. Change anyway?"))) {
                return;
            }
        }
        catch (RepositoryException e1) {
            MessageDialog.openWarning(null, (String)"Unable to change primary type", (String)("Exception occured while trying to verify node types: " + String.valueOf((Object)e1)));
            return;
        }
        String thisNodeType = this.getPrimaryType();
        SerializationKind currentSk = this.getSerializationKind(thisNodeType);
        SerializationKind newSk = this.getSerializationKind(newPrimaryType);
        if (currentSk.equals((Object)newSk)) {
            if (newSk != SerializationKind.FOLDER) {
                this.properties.doSetPropertyValue("jcr:primaryType", newPrimaryType);
            } else if (thisNodeType.equals("nt:folder")) {
                this.createVaultFile((IFolder)this.resource, ".content.xml", newPrimaryType);
            } else if (newPrimaryType.equals("nt:folder")) {
                if (this.domElement != null) {
                    MessageDialog.openWarning(null, (String)"Unable to change primaryType", (String)"Unable to change jcr:primaryType to nt:folder since the node is contained in a .content.xml");
                    return;
                }
                if (!this.verifyNodeTypeChange(ntManager, newPrimaryType)) {
                    return;
                }
                if (!(this.resource instanceof IFolder)) {
                    MessageDialog.openWarning(null, (String)"Unable to change primaryType", (String)"Unable to change jcr:primaryType to nt:folder as there is no underlying folder");
                    return;
                }
                IFolder folder = (IFolder)this.resource;
                IFile contentXml = folder.getFile(".content.xml");
                if (contentXml.exists()) {
                    try {
                        contentXml.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        Logger logger = Activator.getDefault().getPluginLogger();
                        logger.error("Could not delete " + String.valueOf(contentXml.getFullPath()) + ", e=" + String.valueOf((Object)e), (Throwable)e);
                        MessageDialog.openError(null, (String)"Could not delete file", (String)("Could not delete " + String.valueOf(contentXml.getFullPath()) + ", " + String.valueOf((Object)e)));
                    }
                }
            } else {
                this.properties.doSetPropertyValue("jcr:primaryType", newPrimaryType);
            }
            return;
        }
        if (newSk == SerializationKind.FOLDER) {
            if (currentSk == SerializationKind.FILE) {
                MessageDialog.openWarning(null, (String)"Unable to change primary type", (String)"Changing from a file to a folder type is currently not supported");
                return;
            }
            if (newPrimaryType.equals("nt:folder") && !this.verifyNodeTypeChange(ntManager, newPrimaryType)) {
                return;
            }
            try {
                IFile contentXml;
                IFolder newFolder = this.getParent().prepareCreateFolderChild(this.getJcrPathName());
                if (!newPrimaryType.equals("nt:folder")) {
                    this.createVaultFileWithContent(newFolder, ".content.xml", newPrimaryType, this.domElement);
                }
                if (this.domElement != null) {
                    this.domElement.remove();
                    if (this.underlying != null) {
                        this.underlying.save();
                    }
                }
                this.getParent().createDomChild(this.getJcrPathName(), null);
                if (newPrimaryType.equals("nt:folder") && this.properties != null && this.properties.getUnderlying() != null && (contentXml = this.properties.getUnderlying().file) != null && contentXml.exists()) {
                    contentXml.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                ServerUtil.triggerIncrementalBuild((IResource)newFolder, null);
                return;
            }
            catch (CoreException e) {
                MessageDialog.openWarning(null, (String)"Unable to change primaryType", (String)("Exception occurred: " + String.valueOf((Object)e)));
                Logger logger = Activator.getDefault().getPluginLogger();
                logger.error("Exception occurred", (Throwable)e);
                return;
            }
        }
        if (newSk == SerializationKind.FILE) {
            MessageDialog.openWarning(null, (String)"Unable to change primary type", (String)"Changing to/from a file is currently not supported");
            return;
        }
        if (this.domElement == null && this.resource instanceof IFolder) {
            this.createVaultFile((IFolder)this.resource, ".content.xml", newPrimaryType);
        } else {
            if (this.domElement.getAttributeMap().containsKey("jcr:primaryType")) {
                this.domElement.setAttribute("jcr:primaryType", newPrimaryType);
            } else {
                this.domElement.addAttribute("jcr:primaryType", newPrimaryType);
            }
            Element propDomElement = this.properties.getDomElement();
            if (propDomElement != null) {
                List attributes = propDomElement.getAttributes();
                for (Attribute anAttribute : attributes) {
                    if (anAttribute.getName().startsWith("xmlns:") || anAttribute.getName().equals("jcr:primaryType")) continue;
                    if (this.domElement.getAttributeMap().containsKey(anAttribute.getName())) {
                        this.domElement.setAttribute(anAttribute.getName(), anAttribute.getValue());
                        continue;
                    }
                    this.domElement.addAttribute(anAttribute);
                }
                List c2 = propDomElement.getChildren();
                if (c2 != null && c2.size() != 0) {
                    this.domElement.addNodes((Collection)c2);
                }
            }
            if (this.properties.getUnderlying() != null && this.properties.getUnderlying().file != null) {
                try {
                    this.properties.getUnderlying().file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    this.prune(this.properties.getUnderlying().file.getParent());
                }
                catch (CoreException e) {
                    MessageDialog.openError(null, (String)"Unable to change primary type", (String)("Could not delete vault file " + String.valueOf(this.properties.getUnderlying().file) + ": " + String.valueOf((Object)e)));
                    Activator.getDefault().getPluginLogger().error("Error changing jcr:primaryType. Could not delete vault file " + String.valueOf(this.properties.getUnderlying().file) + ": " + e.getMessage(), (Throwable)e);
                    return;
                }
            }
            this.underlying.save();
        }
    }

    private void prune(IContainer folder) throws CoreException {
        if (folder == null || !(folder instanceof IFolder)) {
            return;
        }
        IFolder f = (IFolder)folder;
        IResource[] members = f.members();
        if (members != null && members.length != 0) {
            return;
        }
        f.delete(true, (IProgressMonitor)new NullProgressMonitor());
        this.prune(folder.getParent());
    }

    private boolean verifyNodeTypeChange(NodeTypeRegistry ntManager, String newNodeType) {
        Object[] cn = this.getChildren(true);
        int i = 0;
        while (i < cn.length) {
            JcrNode node = (JcrNode)cn[i];
            try {
                if (!ntManager.isAllowedPrimaryChildNodeType(newNodeType, node.getPrimaryType())) {
                    MessageDialog.openWarning(null, (String)"Unable to change primaryType", (String)("Unable to change jcr:primaryType to nt:folder since nt:folder cannot have child of type " + node.getPrimaryType()));
                    return false;
                }
            }
            catch (RepositoryException e) {
                Logger logger = Activator.getDefault().getPluginLogger();
                logger.error("Could not determine allowed primary child node types", (Throwable)e);
            }
            ++i;
        }
        return true;
    }

    public void addProperty(String name, String value) {
        this.properties.addProperty(name, value);
    }

    public NodeType getNodeType() {
        NodeTypeRegistry ntManager;
        Repository repository = ServerUtil.getDefaultRepository((IProject)this.getProject());
        NodeTypeRegistry nodeTypeRegistry = ntManager = repository == null ? null : repository.getNodeTypeRegistry();
        if (ntManager == null) {
            return null;
        }
        return ntManager.getNodeType(this.getPrimaryType());
    }

    public int getPropertyType(String propertyName) {
        PropertyDefinition pd = this.getPropertyDefinition(propertyName);
        if (pd != null) {
            return pd.getRequiredType();
        }
        GenericJcrRootFile u = this.properties.getUnderlying();
        if (u == null) {
            Activator.getDefault().getPluginLogger().warn("No underlying properties file, cannot derive propertyType (" + propertyName + ") for " + String.valueOf(this));
            return -1;
        }
        ProjectUtil.getSyncDirectory((IProject)this.getProject());
        IFile file = u.file;
        WorkspaceFile resourceFile = (WorkspaceFile)EclipseResources.create((IResource)file);
        try {
            Activator.getDefault().getSerializationManager().readSerializationData(resourceFile);
            String rawValue = this.properties.getValue(propertyName);
            return PropertyTypeSupport.propertyTypeOfString(rawValue);
        }
        catch (Exception e) {
            Activator.getDefault().getPluginLogger().warn("Exception occurred during analyzing propertyType (" + propertyName + ") for " + String.valueOf(this), (Throwable)e);
            return -1;
        }
    }

    private Object doGetProperty(ResourceProxy resourceProxy, String propertyName) {
        if (resourceProxy.getPath().equals((Object)this.getJcrPath())) {
            Map props = resourceProxy.getProperties();
            if (props.containsKey(propertyName)) {
                Object p0 = props.get(propertyName);
                return p0;
            }
        } else {
            List resourceProxyChildren = resourceProxy.getChildren();
            for (ResourceProxy aChild : resourceProxyChildren) {
                Object p1 = this.doGetProperty(aChild, propertyName);
                if (p1 == null) continue;
                return p1;
            }
        }
        return null;
    }

    public PropertyDefinition getPropertyDefinition(String propertyName) {
        NodeType nt0 = this.getNodeType();
        if (nt0 == null) {
            return null;
        }
        LinkedList<NodeType> nodeTypes = new LinkedList<NodeType>();
        nodeTypes.add(nt0);
        nodeTypes.addAll(Arrays.asList(nt0.getSupertypes()));
        for (NodeType nt : nodeTypes) {
            PropertyDefinition[] pds = nt.getPropertyDefinitions();
            int i = 0;
            while (i < pds.length) {
                PropertyDefinition propertyDefinition = pds[i];
                if (propertyDefinition.getName().equals(propertyName)) {
                    return propertyDefinition;
                }
                ++i;
            }
        }
        return null;
    }

    public JcrProperty getProperty(final String name) {
        if (this.properties == null) {
            return null;
        }
        return new JcrProperty(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getType() {
                return JcrNode.this.getPropertyType(name);
            }

            @Override
            public String getTypeAsString() {
                int t = JcrNode.this.getPropertyType(name);
                return PropertyType.nameFromValue((int)t);
            }

            @Override
            public String getValueAsString() {
                String rawValue = JcrNode.this.getProperties().getValue(name);
                if (rawValue == null) {
                    return null;
                }
                if (rawValue.startsWith("{")) {
                    int curlyEnd = rawValue.indexOf("}", 1);
                    rawValue = rawValue.substring(curlyEnd + 1);
                }
                return rawValue;
            }

            @Override
            public boolean isMultiple() {
                String rawValue = JcrNode.this.getProperties().getValue(name);
                if (rawValue == null) {
                    return false;
                }
                if (rawValue.startsWith("{")) {
                    int curlyEnd = rawValue.indexOf("}", 1);
                    rawValue = rawValue.substring(curlyEnd + 1);
                }
                return rawValue.startsWith("[") && rawValue.endsWith("]");
            }

            @Override
            public String[] getValuesAsString() {
                String rawValue = JcrNode.this.getProperties().getValue(name);
                if (rawValue.startsWith("{")) {
                    int curlyEnd = rawValue.indexOf("}", 1);
                    rawValue = rawValue.substring(curlyEnd + 1);
                }
                rawValue = rawValue.substring(1, rawValue.length() - 1);
                return org.apache.jackrabbit.util.Text.explode((String)rawValue, (int)44);
            }
        };
    }

    public void renameProperty(String oldKey, String newKey) {
        this.properties.renameProperty(oldKey, newKey);
    }

    public void changePropertyType(String key, int propertyType) {
        this.properties.changePropertyType(key, propertyType);
    }

    private IFolder prepareCreateFolderChild(String childNodeName) throws CoreException {
        LinkedList<String> parentNames = new LinkedList<String>();
        JcrNode node = this;
        while (!(node.resource instanceof IFolder) && !(node instanceof SyncDir)) {
            parentNames.add(0, node.getJcrPathName());
            node = node.getParent();
        }
        if (!(node.resource instanceof IFolder)) {
            throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", "Could not find base folder for creating child. (1) Expected a folder at " + String.valueOf(node.resource)));
        }
        IFolder folder = (IFolder)node.resource;
        parentNames.add(childNodeName);
        Iterator it = parentNames.iterator();
        while (it.hasNext()) {
            String aParentName = (String)it.next();
            String encodedParentName = DirNode.encode(aParentName);
            IResource member = folder.findMember(encodedParentName);
            if (member != null && !(member instanceof IFolder)) {
                throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", "Could not find base folder for creating child. (2) Expected a folder at " + String.valueOf(member)));
            }
            if (member != null && member.exists()) {
                folder = (IFolder)member;
                it.remove();
                continue;
            }
            if ((folder = folder.getFolder(encodedParentName)).exists()) continue;
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        return folder;
    }

    public IStatus validateDrop(int operation, TransferData transferType) {
        NodeTypeRegistry ntManager;
        Repository repository = ServerUtil.getDefaultRepository((IProject)this.getProject());
        NodeTypeRegistry nodeTypeRegistry = ntManager = repository == null ? null : repository.getNodeTypeRegistry();
        if (ntManager == null) {
            return new Status(8, "org.apache.sling.ide.eclipse-core", 1, "Cannot drop element here because corresponding server is not started! (Needed to determine node types)", null);
        }
        try {
            if (this.getPrimaryType().equals("nt:file")) {
                return new Status(8, "org.apache.sling.ide.eclipse-core", 1, "Cannot drop element onto nt:file", null);
            }
            if (ntManager.isAllowedPrimaryChildNodeType(this.getPrimaryType(), "nt:file")) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
        catch (RepositoryException e) {
            Activator.getDefault().getPluginLogger().error("validateDrop: Got Exception while verifying nodeType: " + String.valueOf((Object)e), (Throwable)e);
            return Status.CANCEL_STATUS;
        }
    }

    public IStatus handleDrop(Object data, int detail) throws CoreException {
        IFolder folder = (IFolder)this.resource;
        if (data instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)data;
            Object firstElem = sel.getFirstElement();
            if (firstElem instanceof IResource) {
                IResource resource = (IResource)firstElem;
                return this.handleDropResource(folder, resource, detail);
            }
            if (firstElem instanceof JcrNode) {
                JcrNode node = (JcrNode)firstElem;
                return this.handleDropNode(folder, node, detail);
            }
            return new Status(8, "org.apache.sling.ide.eclipse-core", 1, "Cannot drop on this type of element (yet) [1]", null);
        }
        return new Status(8, "org.apache.sling.ide.eclipse-core", 1, "Cannot drop this type of selection", null);
    }

    private IStatus handleDropNode(IFolder targetFolder, JcrNode droppedNode, int dropDetail) throws CoreException {
        if (this.domElement != null && droppedNode.domElement != null && droppedNode.resource == null) {
            this.domElement.addNodes(new Node[]{droppedNode.domElement.copy()});
            this.underlying.save();
            if (dropDetail == 2) {
                droppedNode.delete();
            }
            return Status.OK_STATUS;
        }
        if (droppedNode.resource != null && droppedNode.domElement == null) {
            IStatus status = this.handleDropResource(targetFolder, droppedNode.resource, dropDetail);
            if (!status.isOK()) {
                return status;
            }
            if (droppedNode.dirSibling != null) {
                return this.handleDropResource(targetFolder, droppedNode.dirSibling.getResource(), dropDetail);
            }
            return Status.OK_STATUS;
        }
        return new Status(8, "org.apache.sling.ide.eclipse-core", 1, "Cannot drop on this (mixed) type of element (yet) [2]", null);
    }

    private IStatus handleDropResource(IFolder targetFolder, IResource droppedResourceRoot, int detail) throws CoreException {
        if (targetFolder == null) {
            return new Status(8, "org.apache.sling.ide.eclipse-core", 1, "Cannot drop on this type of element (yet)", null);
        }
        if (droppedResourceRoot == null) {
            throw new IllegalArgumentException("droppedResourceRoot must not be null");
        }
        IFile copyToFile = targetFolder.getFile(droppedResourceRoot.getName());
        IPath copyToPath = copyToFile.getFullPath();
        switch (detail) {
            case 1: {
                droppedResourceRoot.copy(copyToPath, true, (IProgressMonitor)new NullProgressMonitor());
                break;
            }
            case 2: {
                droppedResourceRoot.move(copyToPath, true, (IProgressMonitor)new NullProgressMonitor());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown drop action (detail: " + detail + ")");
            }
        }
        return Status.OK_STATUS;
    }

    public IContainer getDropContainer() {
        if (this.resource instanceof IContainer) {
            return (IContainer)this.resource;
        }
        return null;
    }

    public boolean canBeCopiedToClipboard() {
        if (this.getPrimaryType().equals("nt:file")) {
            return true;
        }
        return this.domElement != null && this.resource == null;
    }

    public void copyToClipboard(Clipboard clipboard) {
        if (!this.canBeCopiedToClipboard()) {
            MessageDialog.openWarning(null, (String)"Cannot copy", (String)"Cannot copy this type of node (yet)");
            return;
        }
        if (this.getPrimaryType().equals("nt:file")) {
            this.copyFileToClipboard(clipboard);
        } else if (this.domElement != null && this.resource == null) {
            this.copyDomToClipboard(clipboard);
        }
    }

    private void copyDomToClipboard(Clipboard clipboard) {
        String text = this.domElement.toXML();
        clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
    }

    private void copyFileToClipboard(Clipboard clipboard) {
        String[] fileNames;
        IResource[] resources;
        if (this.dirSibling == null) {
            String[] stringArray;
            resources = new IResource[]{this.resource};
            IPath location = this.resource.getLocation();
            if (location == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = location.toOSString();
            }
            fileNames = stringArray;
        } else {
            String[] stringArray;
            resources = new IResource[]{this.resource, this.dirSibling.getResource()};
            IPath resLocation = this.resource.getLocation();
            IPath siblLocation = this.dirSibling.getResource().getLocation();
            if (resLocation == null || siblLocation == null) {
                stringArray = null;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = resLocation.toOSString();
                stringArray = stringArray3;
                stringArray3[1] = siblLocation.toOSString();
            }
            fileNames = stringArray;
        }
        if (fileNames != null) {
            clipboard.setContents(new Object[]{resources, fileNames}, new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance()});
        } else {
            clipboard.setContents(new Object[]{resources}, new Transfer[]{ResourceTransfer.getInstance()});
        }
    }

    public boolean canBePastedTo(Clipboard clipboard) {
        Repository repository = ServerUtil.getDefaultRepository((IProject)this.getProject());
        if (repository != null) {
            repository.getNodeTypeRegistry();
        }
        IResource[] resourceData = (IResource[])clipboard.getContents((Transfer)ResourceTransfer.getInstance());
        if (resourceData != null) {
            IContainer container = this.getDropContainer();
            return container != null;
        }
        String[] fileData = (String[])clipboard.getContents((Transfer)FileTransfer.getInstance());
        if (fileData != null) {
            IContainer container = this.getDropContainer();
            return container != null;
        }
        String text = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
        if (text != null) {
            return this.domElement != null;
        }
        return false;
    }

    public void pasteFromClipboard(Clipboard clipboard) {
        NodeTypeRegistry ntManager;
        if (!this.canBePastedTo(clipboard)) {
            MessageDialog.openInformation(null, (String)"Cannot paste", (String)"No applicable node (type) for pasting found.");
            return;
        }
        Repository repository = ServerUtil.getDefaultRepository((IProject)this.getProject());
        NodeTypeRegistry nodeTypeRegistry = ntManager = repository == null ? null : repository.getNodeTypeRegistry();
        if (ntManager == null) {
            MessageDialog.openWarning(null, (String)"Cannot paste", (String)"Cannot paste if corresponding server is not started");
            return;
        }
        IResource[] resourceData = (IResource[])clipboard.getContents((Transfer)ResourceTransfer.getInstance());
        if (resourceData != null && resourceData.length > 0) {
            if (resourceData[0].getType() == 4) {
                MessageDialog.openInformation(null, (String)"Cannot paste project(s)", (String)"Pasting of a project onto a (JCR) node is not possible");
                return;
            }
            CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(null);
            operation.copyResources(resourceData, this.getDropContainer());
            return;
        }
        String[] fileData = (String[])clipboard.getContents((Transfer)FileTransfer.getInstance());
        if (fileData != null) {
            CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(null);
            operation.copyFiles(fileData, this.getDropContainer());
            return;
        }
        String text = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
        if (text != null && this.domElement != null) {
            try {
                Document document = TolerantXMLParser.parse(text, "pasted from clipboard");
                this.domElement.addNode((Node)document.getRootElement());
                this.underlying.save();
            }
            catch (IOException e) {
                MessageDialog.openError(null, (String)"Could not paste from clipboard", (String)("Exception encountered while pasting from clipboard: " + String.valueOf(e)));
                Activator.getDefault().getPluginLogger().error("Error pasting from clipboard: " + String.valueOf(e), (Throwable)e);
            }
        }
    }
}

