/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.views;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.PropertyType;
import org.apache.sling.ide.eclipse.core.ServerUtil;
import org.apache.sling.ide.eclipse.ui.nav.model.JcrNode;
import org.apache.sling.ide.eclipse.ui.nav.model.JcrProperty;
import org.apache.sling.ide.eclipse.ui.nav.model.JcrTextPropertyDescriptor;
import org.apache.sling.ide.eclipse.ui.nav.model.ModifiableProperties;
import org.apache.sling.ide.eclipse.ui.views.DateTimeCellEditor;
import org.apache.sling.ide.eclipse.ui.views.JcrPropertiesView;
import org.apache.sling.ide.eclipse.ui.views.MVNCellEditor;
import org.apache.sling.ide.eclipse.ui.views.NewRow;
import org.apache.sling.ide.eclipse.ui.views.PropertyTypeSupport;
import org.apache.sling.ide.transport.NodeTypeRegistry;
import org.apache.sling.ide.transport.Repository;
import org.apache.sling.ide.transport.RepositoryException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class JcrEditingSupport
extends EditingSupport {
    private final ColumnId columnId;
    private final TableViewer tableViewer;
    private final JcrPropertiesView view;

    public JcrEditingSupport(JcrPropertiesView view, TableViewer viewer, ColumnId columnType) {
        super((ColumnViewer)viewer);
        this.view = view;
        this.columnId = columnType;
        this.tableViewer = viewer;
    }

    protected CellEditor getCellEditor(Object element) {
        try {
            CellEditor result = this.doGetCellEditor(element);
            if (result != null) {
                Field field = this.asField(element);
                this.view.setLastValueEdited(field.getPropertyName(), field.getNewPropertyName(), this.columnId);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected CellEditor doGetCellEditor(Object element) {
        if (!this.canEdit(element)) {
            return null;
        }
        switch (this.columnId) {
            case NAME: {
                return new TextCellEditor((Composite)this.tableViewer.getTable());
            }
            case TYPE: {
                ComboBoxCellEditor editor = new ComboBoxCellEditor((Composite)this.tableViewer.getTable(), PropertyTypeSupport.PROPERTY_TYPES, 0);
                editor.setActivationStyle(11);
                return editor;
            }
            case VALUE: {
                Field field = this.asField(element);
                if (this.getNode().getProperty(field.getPropertyName()).isMultiple()) {
                    return new MVNCellEditor((Composite)this.tableViewer.getTable(), this.getNode(), field.getPropertyName());
                }
                if (field.getPropertyType() == 5) {
                    return new DateTimeCellEditor((Composite)this.tableViewer.getTable(), this.getNode(), field.getPropertyName());
                }
                if (field.getPropertyType() == 6) {
                    return new ComboBoxCellEditor((Composite)this.tableViewer.getTable(), new String[]{"false", "true"}, 8);
                }
                TextCellEditor editor = field.getPropertyName().equals("jcr:primaryType") ? new TextCellEditor((Composite)this.tableViewer.getTable()){

                    protected Control createControl(Composite parent) {
                        NodeTypeRegistry ntManager;
                        Text text = (Text)super.createControl(parent);
                        Repository repository = ServerUtil.getDefaultRepository((IProject)JcrEditingSupport.this.getNode().getProject());
                        NodeTypeRegistry nodeTypeRegistry = ntManager = repository == null ? null : repository.getNodeTypeRegistry();
                        if (ntManager == null) {
                            return text;
                        }
                        try {
                            Collection types = ntManager.getAllowedPrimaryChildNodeTypes(JcrEditingSupport.this.getNode().getParent().getPrimaryType());
                            SimpleContentProposalProvider proposalProvider = new SimpleContentProposalProvider(types.toArray(new String[0]));
                            proposalProvider.setFiltering(true);
                            ContentProposalAdapter adapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)proposalProvider, null, null);
                            adapter.setPropagateKeys(true);
                            adapter.setProposalAcceptanceStyle(2);
                            return text;
                        }
                        catch (RepositoryException repositoryException) {
                            return text;
                        }
                    }
                } : new TextCellEditor((Composite)this.tableViewer.getTable());
                int propertyType = this.getNode().getPropertyType(field.getPropertyName());
                switch (propertyType) {
                    case 1: 
                    case 7: {
                        break;
                    }
                    case 12: {
                        editor.setValidator((ICellEditorValidator)new DecimalValidator((CellEditor)editor));
                        break;
                    }
                }
                return editor;
            }
            case MULTIPLE: {
                if (element instanceof NewRow) {
                    return null;
                }
                return new ComboBoxCellEditor((Composite)this.tableViewer.getTable(), new String[]{"false", "true"}, 8);
            }
        }
        throw new IllegalStateException("Unknown columnId: " + String.valueOf((Object)this.columnId));
    }

    protected boolean canEdit(Object element) {
        return this.asField(element).canEdit();
    }

    private Field asField(Object element) {
        if (element instanceof NewRow) {
            return new NewRowField((NewRow)element);
        }
        return new Field(element);
    }

    protected Object getValue(Object element) {
        return this.asField(element).getValue();
    }

    protected void setValue(Object element, Object value) {
        Field field = this.asField(element);
        if (!field.canEdit()) {
            return;
        }
        String newPropertyName = this.columnId == ColumnId.NAME ? String.valueOf(value) : field.getPropertyName();
        this.view.setLastValueEdited(field.getPropertyName(), newPropertyName, this.columnId);
        field.setValue(element, value);
    }

    void handleNewRowUpdate(NewRow newRow) {
        if (newRow.isComplete()) {
            this.tableViewer.remove((Object)newRow);
            JcrNode jcrNode = (JcrNode)this.tableViewer.getInput();
            Integer type = newRow.getType();
            Object encodeValueAsString = PropertyTypeSupport.encodeValueAsString(newRow.getValue(), type);
            if (type != 1 && type != 7) {
                encodeValueAsString = "{" + PropertyType.nameFromValue((int)type) + "}" + (String)encodeValueAsString;
            }
            String propertyName = String.valueOf(newRow.getName());
            jcrNode.addProperty(propertyName, (String)encodeValueAsString);
            this.view.refreshContent();
        } else {
            this.tableViewer.update((Object)newRow, null);
        }
    }

    private JcrNode getNode() {
        return (JcrNode)this.tableViewer.getInput();
    }

    static enum ColumnId {
        NAME,
        TYPE,
        VALUE,
        MULTIPLE;

    }

    private class DecimalValidator
    implements ICellEditorValidator {
        private final CellEditor editor;

        DecimalValidator(CellEditor editor) {
            this.editor = editor;
        }

        public String isValid(Object value) {
            Control cn = this.editor.getControl();
            Color red = new Color((Device)Display.getCurrent(), new RGB(255, 100, 100));
            cn.setBackground(red);
            return null;
        }
    }

    private class Field {
        private final Object element;

        Field(Object element) {
            this.element = element;
        }

        public boolean canEdit() {
            IPropertyDescriptor pd = (IPropertyDescriptor)this.element;
            Map.Entry me = (Map.Entry)pd.getId();
            if (me.getKey().equals("jcr:primaryType")) {
                return JcrEditingSupport.this.columnId == ColumnId.VALUE;
            }
            return true;
        }

        public Object getValue() {
            IPropertyDescriptor pd = (IPropertyDescriptor)this.element;
            JcrEditingSupport.this.getNode();
            Map.Entry me = (Map.Entry)pd.getId();
            switch (JcrEditingSupport.this.columnId) {
                case NAME: {
                    return String.valueOf(me.getKey());
                }
                case TYPE: {
                    int propertyType = JcrEditingSupport.this.getNode().getPropertyType(this.getPropertyName());
                    if (propertyType != -1) {
                        return PropertyTypeSupport.indexOfPropertyType(propertyType);
                    }
                    return PropertyTypeSupport.indexOfPropertyType(1);
                }
                case VALUE: {
                    int propertyType = JcrEditingSupport.this.getNode().getPropertyType(this.getPropertyName());
                    String rawValue = String.valueOf(me.getValue());
                    int index = rawValue.indexOf("}");
                    if (index != -1) {
                        rawValue = rawValue.substring(index + 1);
                    }
                    if (propertyType != -1 && propertyType == 6) {
                        try {
                            if (Boolean.parseBoolean(String.valueOf(rawValue))) {
                                return 1;
                            }
                            return 0;
                        }
                        catch (Exception exception) {
                            return 0;
                        }
                    }
                    if (propertyType != -1 && propertyType != 1) {
                        return rawValue;
                    }
                    return String.valueOf(me.getValue());
                }
                case MULTIPLE: {
                    boolean isMultiple = JcrEditingSupport.this.getNode().getProperty(this.getPropertyName()).isMultiple();
                    return isMultiple ? 1 : 0;
                }
            }
            throw new IllegalStateException("Unknown columnId: " + String.valueOf((Object)JcrEditingSupport.this.columnId));
        }

        public String getPropertyName() {
            IPropertyDescriptor pd = (IPropertyDescriptor)this.element;
            Map.Entry me = (Map.Entry)pd.getId();
            return String.valueOf(me.getKey());
        }

        public void setValue(Object element, Object value) {
            if (this.getValue().equals(value)) {
                return;
            }
            JcrTextPropertyDescriptor pd = (JcrTextPropertyDescriptor)((Object)element);
            JcrNode jcrNode = JcrEditingSupport.this.getNode();
            Map.Entry me = (Map.Entry)pd.getId();
            switch (JcrEditingSupport.this.columnId) {
                case NAME: {
                    String oldKey = String.valueOf(this.getValue());
                    String newKey = String.valueOf(value);
                    pd.setNewPropertyName(newKey);
                    HashMap<String, String> pseudoMap = new HashMap<String, String>();
                    String propertyValue = jcrNode.getProperties().getValue(oldKey);
                    pseudoMap.put(newKey, propertyValue);
                    Map.Entry mapEntry = pseudoMap.entrySet().iterator().next();
                    element = new TextPropertyDescriptor(mapEntry, propertyValue);
                    jcrNode.renameProperty(oldKey, newKey);
                    break;
                }
                case TYPE: {
                    int propertyType = PropertyTypeSupport.propertyTypeOfIndex((Integer)value);
                    jcrNode.changePropertyType(String.valueOf(me.getKey()), propertyType);
                    break;
                }
                case VALUE: {
                    try {
                        Object encodedValue;
                        JcrProperty property = JcrEditingSupport.this.getNode().getProperty(this.getPropertyName());
                        int propertyType = property.getType();
                        if (property.isMultiple()) {
                            Object[] values = (Object[])value;
                            encodedValue = "";
                            int i = 0;
                            while (i < values.length) {
                                Object aValue = values[i];
                                String aValueAsString = PropertyTypeSupport.encodeValueAsString(aValue, propertyType);
                                encodedValue = i == 0 ? aValueAsString : (String)encodedValue + "," + aValueAsString;
                                ++i;
                            }
                            encodedValue = "[" + (String)encodedValue + "]";
                        } else {
                            encodedValue = PropertyTypeSupport.encodeValueAsString(value, propertyType);
                        }
                        if (propertyType != 1 && propertyType != 7) {
                            encodedValue = "{" + PropertyType.nameFromValue((int)propertyType) + "}" + (String)encodedValue;
                        }
                        jcrNode.setPropertyValue(me.getKey(), encodedValue);
                    }
                    catch (Exception exception) {
                        jcrNode.setPropertyValue(me.getKey(), String.valueOf(value));
                    }
                    break;
                }
                case MULTIPLE: {
                    Object newValue;
                    String rawValue;
                    String prefix;
                    JcrProperty property;
                    boolean oldIsMultiple;
                    if (!(value instanceof Integer)) {
                        return;
                    }
                    Integer newIsMultipleValue = (Integer)value;
                    boolean newIsMultiple = newIsMultipleValue == 1;
                    if (newIsMultiple == (oldIsMultiple = (property = JcrEditingSupport.this.getNode().getProperty(this.getPropertyName())).isMultiple())) {
                        return;
                    }
                    String oldPropertyValue = JcrEditingSupport.this.getNode().getProperties().getValue(this.getPropertyName());
                    int cPos = oldPropertyValue.indexOf("}");
                    if (cPos == -1) {
                        prefix = "";
                        rawValue = oldPropertyValue;
                    } else {
                        prefix = oldPropertyValue.substring(0, cPos + 1);
                        rawValue = oldPropertyValue.substring(cPos + 1);
                    }
                    if (newIsMultiple) {
                        newValue = prefix + "[" + rawValue + "]";
                    } else {
                        newValue = rawValue.substring(1, rawValue.length() - 1);
                        int commaPos = ((String)newValue).indexOf(",");
                        if (commaPos != -1) {
                            newValue = ((String)newValue).substring(0, commaPos);
                        }
                        newValue = prefix + (String)newValue;
                    }
                    jcrNode.setPropertyValue(this.getPropertyName(), newValue);
                }
            }
            JcrEditingSupport.this.view.refreshContent();
        }

        public int getPropertyType() {
            IPropertyDescriptor pd = (IPropertyDescriptor)this.element;
            Map.Entry me = (Map.Entry)pd.getId();
            String value = String.valueOf(me.getValue());
            return PropertyTypeSupport.propertyTypeOfString(value);
        }

        public String getNewPropertyName() {
            JcrTextPropertyDescriptor pd = (JcrTextPropertyDescriptor)((Object)this.element);
            if (pd.getNewPropertyName() != null) {
                return pd.getNewPropertyName();
            }
            return this.getPropertyName();
        }
    }

    private class NewRowField
    extends Field {
        private final NewRow newRow;

        NewRowField(NewRow newRow) {
            super(newRow);
            this.newRow = newRow;
        }

        @Override
        public boolean canEdit() {
            return true;
        }

        @Override
        public int getPropertyType() {
            return this.newRow.getType();
        }

        @Override
        public Object getValue() {
            if (JcrEditingSupport.this.columnId == ColumnId.NAME) {
                return this.newRow.getName();
            }
            if (JcrEditingSupport.this.columnId == ColumnId.VALUE) {
                int propertyType = this.newRow.getType();
                if (propertyType == 6) {
                    try {
                        if (Boolean.parseBoolean(String.valueOf(this.newRow.getValue()))) {
                            return 1;
                        }
                        return 0;
                    }
                    catch (Exception exception) {
                        return 0;
                    }
                }
                return this.newRow.getValue();
            }
            if (JcrEditingSupport.this.columnId == ColumnId.TYPE) {
                int propertyType = this.newRow.getType();
                if (propertyType != -1) {
                    return PropertyTypeSupport.indexOfPropertyType(propertyType);
                }
                return PropertyTypeSupport.indexOfPropertyType(1);
            }
            if (JcrEditingSupport.this.columnId == ColumnId.MULTIPLE) {
                return 0;
            }
            return null;
        }

        @Override
        public String getPropertyName() {
            return String.valueOf(this.newRow.getName());
        }

        @Override
        public String getNewPropertyName() {
            return this.getPropertyName();
        }

        @Override
        public void setValue(Object element, Object value) {
            if (this.getValue().equals(value)) {
                return;
            }
            if (JcrEditingSupport.this.columnId == ColumnId.NAME) {
                Object newName = String.valueOf(value);
                ModifiableProperties props = JcrEditingSupport.this.getNode().getProperties();
                int cnt = 1;
                while (props.getValue((String)newName) != null) {
                    newName = String.valueOf(value) + cnt++;
                }
                this.newRow.setName((String)newName);
            } else if (JcrEditingSupport.this.columnId == ColumnId.VALUE) {
                this.newRow.setValue(PropertyTypeSupport.encodeValueAsString(value, this.getPropertyType()));
            } else if (JcrEditingSupport.this.columnId == ColumnId.TYPE) {
                int propertyType = PropertyTypeSupport.propertyTypeOfIndex((Integer)value);
                this.newRow.setType(propertyType);
            } else if (JcrEditingSupport.this.columnId != ColumnId.MULTIPLE) {
                return;
            }
            JcrEditingSupport.this.handleNewRowUpdate(this.newRow);
        }
    }
}

