/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.impl;

import java.util.Iterator;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;

public final class ConfigurationResourceWrapper
extends AbstractResource {
    private final Resource resource;
    private final ValueMap props;

    public ConfigurationResourceWrapper(Resource resource, ValueMap props) {
        this.resource = ConfigurationResourceWrapper.unwrap(resource);
        this.props = props;
    }

    private static Resource unwrap(Resource resource) {
        if (resource instanceof ConfigurationResourceWrapper) {
            return ((ConfigurationResourceWrapper)resource).resource;
        }
        return resource;
    }

    public <AdapterType> AdapterType adaptTo(@NotNull Class<AdapterType> type) {
        if (type == ValueMap.class) {
            return (AdapterType)this.props;
        }
        return (AdapterType)super.adaptTo(type);
    }

    public ValueMap getValueMap() {
        return this.props;
    }

    @NotNull
    public String getPath() {
        return this.resource.getPath();
    }

    public String getName() {
        return this.resource.getName();
    }

    public Resource getParent() {
        return this.resource.getParent();
    }

    public Iterator<Resource> listChildren() {
        return this.resource.listChildren();
    }

    public Iterable<Resource> getChildren() {
        return this.resource.getChildren();
    }

    public Resource getChild(String relPath) {
        return this.resource.getChild(relPath);
    }

    @NotNull
    public String getResourceType() {
        return this.resource.getResourceType();
    }

    public String getResourceSuperType() {
        return this.resource.getResourceSuperType();
    }

    public boolean hasChildren() {
        return this.resource.hasChildren();
    }

    public boolean isResourceType(String resourceType) {
        return this.resource.isResourceType(resourceType);
    }

    @NotNull
    public ResourceMetadata getResourceMetadata() {
        return this.resource.getResourceMetadata();
    }

    @NotNull
    public ResourceResolver getResourceResolver() {
        return this.resource.getResourceResolver();
    }

    public String toString() {
        String className = ((Object)((Object)this)).getClass().getSimpleName().length() == 0 ? ((Object)((Object)this)).getClass().getName() : ((Object)((Object)this)).getClass().getSimpleName();
        return className + ", type=" + this.getResourceType() + ", path=" + this.getPath() + ", resource=[" + this.resource + "]";
    }
}

