/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.commons;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicBackgroundJob
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PeriodicBackgroundJob.class);
    private final long intervalSeconds;
    private final Runnable runnable;
    private final String threadName;
    private volatile boolean stopping = false;
    private volatile boolean stopped = false;

    public PeriodicBackgroundJob(long intervalSeconds, String threadName, Runnable runnable) {
        this.intervalSeconds = intervalSeconds;
        this.runnable = runnable;
        this.threadName = threadName;
        Thread th = new Thread((Runnable)this, threadName);
        th.setDaemon(true);
        th.start();
    }

    public void stop() {
        this.stopping = true;
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public void run() {
        try {
            while (!this.stopping) {
                try {
                    Thread.sleep(this.intervalSeconds * 1000L);
                }
                catch (InterruptedException e) {
                    logger.info("run: got interrupted: " + e, (Throwable)e);
                }
                if (this.stopping) {
                    break;
                }
                this.safelyRun(this.runnable);
            }
        }
        finally {
            this.stopped = true;
        }
    }

    private void safelyRun(Runnable r) {
        try {
            r.run();
        }
        catch (RuntimeException re) {
            logger.error("safelyRun: got a RuntimeException executing '" + this.threadName + "': " + re, (Throwable)re);
        }
        catch (Error er) {
            logger.error("safelyRun: got an Error executing '" + this.threadName + "'. BackgroundJob will terminate! " + er, (Throwable)er);
            throw er;
        }
    }
}

