/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlethelpers;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.sling.servlethelpers.MockJakartaServletContext;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public class MockJakartaHttpSession
implements HttpSession {
    private final Map<String, Object> attributeMap = new HashMap<String, Object>();
    private final String sessionID = UUID.randomUUID().toString();
    private final long creationTime = System.currentTimeMillis();
    private boolean invalidated = false;
    private boolean isNew = true;
    private int maxActiveInterval = 1800;
    private final ServletContext servletContext = this.newMockServletContext();

    protected MockJakartaServletContext newMockServletContext() {
        return new MockJakartaServletContext();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public Object getAttribute(String name) {
        this.checkInvalidatedState();
        return this.attributeMap.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        this.checkInvalidatedState();
        return IteratorUtils.asEnumeration(this.attributeMap.keySet().iterator());
    }

    public String getId() {
        return this.sessionID;
    }

    public long getCreationTime() {
        this.checkInvalidatedState();
        return this.creationTime;
    }

    public void removeAttribute(String name) {
        this.checkInvalidatedState();
        this.attributeMap.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.checkInvalidatedState();
        this.attributeMap.put(name, value);
    }

    public void invalidate() {
        this.checkInvalidatedState();
        this.invalidated = true;
    }

    private void checkInvalidatedState() {
        if (this.invalidated) {
            throw new IllegalStateException("Session is already invalidated.");
        }
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    public boolean isNew() {
        this.checkInvalidatedState();
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public long getLastAccessedTime() {
        this.checkInvalidatedState();
        return this.creationTime;
    }

    public int getMaxInactiveInterval() {
        return this.maxActiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxActiveInterval = interval;
    }
}

