/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.guava.common.base;

import java.io.Serializable;
import org.apache.jackrabbit.guava.common.annotations.GwtCompatible;
import org.apache.jackrabbit.guava.common.annotations.GwtIncompatible;
import org.apache.jackrabbit.guava.common.annotations.J2ktIncompatible;
import org.apache.jackrabbit.guava.common.base.Equivalence;
import org.apache.jackrabbit.guava.common.base.Function;
import org.apache.jackrabbit.guava.common.base.Objects;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.jspecify.annotations.Nullable;

@GwtCompatible
final class FunctionalEquivalence<F, T>
extends Equivalence<F>
implements Serializable {
    @GwtIncompatible
    @J2ktIncompatible
    private static final long serialVersionUID = 0L;
    private final Function<? super F, ? extends @Nullable T> function;
    private final Equivalence<T> resultEquivalence;

    FunctionalEquivalence(Function<? super F, ? extends @Nullable T> function, Equivalence<T> resultEquivalence) {
        this.function = Preconditions.checkNotNull(function);
        this.resultEquivalence = Preconditions.checkNotNull(resultEquivalence);
    }

    @Override
    protected boolean doEquivalent(F a, F b) {
        return this.resultEquivalence.equivalent(this.function.apply(a), this.function.apply(b));
    }

    @Override
    protected int doHash(F a) {
        return this.resultEquivalence.hash(this.function.apply(a));
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FunctionalEquivalence) {
            FunctionalEquivalence that = (FunctionalEquivalence)obj;
            return this.function.equals(that.function) && this.resultEquivalence.equals(that.resultEquivalence);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.function, this.resultEquivalence);
    }

    public String toString() {
        return this.resultEquivalence + ".onResultOf(" + this.function + ")";
    }
}

