/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.jetbrains.annotations.NotNull;

final class CacheConfiguration {
    public static final String PARAM_CACHE_EXPIRATION = "cacheExpiration";
    public static final String PARAM_CACHE_MAX_STALE = "cacheMaxStale";
    public static final long EXPIRATION_NO_CACHE = 0L;
    public static final long NO_STALE_CACHE = 0L;
    private static final int MEMBERSHIP_THRESHOLD = 0;
    private final UserConfiguration userConfig;
    private final long expiration;
    private final long maxStale;
    private final String propertyName;
    private final int membershipThreshold;
    private final String expirationPropertyName;

    private CacheConfiguration(UserConfiguration userConfig, long expiration, long maxStale, @NotNull String propertyName, @NotNull String expirationPropertyName) {
        this.userConfig = userConfig;
        this.expiration = expiration;
        this.maxStale = maxStale;
        this.propertyName = propertyName;
        this.expirationPropertyName = expirationPropertyName;
        this.membershipThreshold = 0;
    }

    CacheConfiguration(UserConfiguration userConfig, long expiration, long maxStale, @NotNull String propertyName, @NotNull String expirationPropertyName, int membershipThreshold) {
        this.userConfig = userConfig;
        this.expiration = expiration;
        this.maxStale = maxStale;
        this.propertyName = propertyName;
        this.expirationPropertyName = expirationPropertyName;
        this.membershipThreshold = Math.max(membershipThreshold, 0);
    }

    public static CacheConfiguration fromUserConfiguration(@NotNull UserConfiguration config, @NotNull String propertyName, @NotNull String expirationPropertyName) {
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            throw new IllegalArgumentException("Invalid property name: " + propertyName);
        }
        if (StringUtils.isBlank((CharSequence)expirationPropertyName) || !expirationPropertyName.startsWith("rep:expiration")) {
            throw new IllegalArgumentException("Invalid expiration property name: " + expirationPropertyName);
        }
        long maxStale = config.getParameters().getConfigValue(PARAM_CACHE_MAX_STALE, 0L);
        long expiration = config.getParameters().getConfigValue(PARAM_CACHE_EXPIRATION, 0L);
        return new CacheConfiguration(config, expiration, maxStale, propertyName, expirationPropertyName);
    }

    static CacheConfiguration fromUserConfiguration(@NotNull UserConfiguration config, @NotNull String propertyName) {
        return CacheConfiguration.fromUserConfiguration(config, propertyName, "rep:expiration");
    }

    public boolean isCacheEnabled() {
        return this.expiration > 0L;
    }

    long getExpiration() {
        return this.expiration;
    }

    long getMaxStale() {
        return this.maxStale;
    }

    String getPropertyName() {
        return this.propertyName;
    }

    String getExpirationPropertyName() {
        return this.expirationPropertyName;
    }

    UserConfiguration getUserConfiguration() {
        return this.userConfig;
    }

    int getMembershipThreshold() {
        return this.membershipThreshold;
    }
}

