/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.maven.mojos.AbstractRepositoryMojo;
import org.apache.sling.feature.maven.mojos.FeatureSelectionConfig;

@Mojo(name="collect-artifacts", requiresProject=false, threadSafe=true)
public final class CollectArtifactsMojo
extends AbstractRepositoryMojo {
    private final Pattern gavPattern = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?:([^: ]+)");
    @Parameter(property="features")
    private String csvFeaturesGAV;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        File artifactDir = this.project.getBuild().getDirectory().contains("${project.basedir}") ? new File(this.repositoryDir) : new File(this.project.getBuild().getDirectory(), this.repositoryDir);
        this.doExecute(artifactDir, this.getFeatures(), null);
    }

    protected Map<String, Feature> getFeatures() throws MojoExecutionException {
        FeatureSelectionConfig config = new FeatureSelectionConfig();
        if (this.csvFeaturesGAV != null && !this.csvFeaturesGAV.isEmpty()) {
            StringTokenizer tokenizer = new StringTokenizer(this.csvFeaturesGAV, ",");
            while (tokenizer.hasMoreTokens()) {
                String gav = tokenizer.nextToken();
                Matcher gavMatcher = this.gavPattern.matcher(gav);
                if (!gavMatcher.matches()) {
                    this.getLog().warn((CharSequence)("Wrong GAV coordinates " + gav + " specified on 'features' property, expected format is groupId:artifactId[:packaging[:classifier]]:version"));
                }
                Dependency dep = new Dependency();
                dep.setGroupId(gavMatcher.group(1));
                dep.setArtifactId(gavMatcher.group(2));
                dep.setVersion(gavMatcher.group(7));
                dep.setType(gavMatcher.group(4));
                dep.setClassifier(gavMatcher.group(6));
                config.setIncludeArtifact(dep);
            }
        }
        return this.getSelectedFeatures(config);
    }
}

