% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQLContext.R
\name{tableToDF}
\alias{tableToDF}
\title{Create a SparkDataFrame from a SparkSQL table or view}
\usage{
tableToDF(tableName)
}
\arguments{
\item{tableName}{the qualified or unqualified name that designates a table or view. If a database
is specified, it identifies the table/view from the database.
Otherwise, it first attempts to find a temporary view with the given name
and then match the table/view from the current database.}
}
\value{
SparkDataFrame
}
\description{
Returns the specified table or view as a SparkDataFrame. The table or view must already exist or
have already been registered in the SparkSession.
}
\note{
tableToDF since 2.0.0
}
\examples{
\dontrun{
sparkR.session()
path <- "path/to/file.json"
df <- read.json(path)
createOrReplaceTempView(df, "table")
new_df <- tableToDF("table")
}
}
