/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.classic;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.streaming.WriteToStream;
import org.apache.spark.sql.catalyst.streaming.WriteToStreamStatement;
import org.apache.spark.sql.classic.Dataset;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.classic.StreamingQuery;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.RealTimeTrigger;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution;
import org.apache.spark.sql.execution.streaming.runtime.AsyncProgressTrackingMicroBatchExecution;
import org.apache.spark.sql.execution.streaming.runtime.AsyncProgressTrackingMicroBatchExecution$;
import org.apache.spark.sql.execution.streaming.runtime.MicroBatchExecution;
import org.apache.spark.sql.execution.streaming.runtime.StreamExecution;
import org.apache.spark.sql.execution.streaming.runtime.StreamingQueryListenerBus;
import org.apache.spark.sql.execution.streaming.runtime.StreamingQueryWrapper;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@Evolving
@ScalaSignature(bytes="\u0006\u0005\r}a\u0001\u0002\u0015*\u0001QB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"11\n\u0001C\u0001W1C\u0001\u0002\u0015\u0001C\u0002\u0013\u00051&\u0015\u0005\u00077\u0002\u0001\u000b\u0011\u0002*\t\u000fq\u0003!\u0019!C\u0005;\"1A\r\u0001Q\u0001\nyCq!\u001a\u0001C\u0002\u0013%a\r\u0003\u0004}\u0001\u0001\u0006Ia\u001a\u0005\n\u0003+\u0001!\u0019!C\u0005\u0003/A\u0001\"!\n\u0001A\u0003%\u0011\u0011\u0004\u0005\n\u0003O\u0001!\u0019!C\u0005\u0003/A\u0001\"!\u000b\u0001A\u0003%\u0011\u0011\u0004\u0005\f\u0003W\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0003C\u0006\u0002>\u0001\u0001\r\u00111A\u0005\n\u0005}\u0002bCA&\u0001\u0001\u0007\t\u0011)Q\u0005\u0003_Aq!!\u0015\u0001\t\u0003\t\u0019\u0006C\u0004\u0002\\\u0001!\t!!\u0018\t\u000f\u0005m\u0003\u0001\"\u0001\u0002d!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0004bBA?\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u0003w\u0003A\u0011AA@\u0011\u001d\ti\f\u0001C\u0001\u0003\u007fCq!a3\u0001\t\u0003\ti\rC\u0004\u0002R\u0002!\t!a5\t\u0011\u0005]\u0007\u0001\"\u0001,\u00033Dq!!<\u0001\t\u0013\ty\u000fC\u0004\u0002|\u0002!I!!@\t\u0013\tu\u0005!%A\u0005\n\t}\u0005\"\u0003BY\u0001E\u0005I\u0011\u0002BZ\u0011!\u00119\f\u0001C\u0001W\te\u0006B\u0003Bw\u0001E\u0005I\u0011A\u0016\u0003p\"Q!1\u001f\u0001\u0012\u0002\u0013\u00051Fa<\t\u0015\tU\b!%A\u0005\u0002-\u00129\u0010\u0003\u0006\u0003|\u0002\t\n\u0011\"\u0001,\u0005{D!b!\u0001\u0001#\u0003%\ta\u000bBP\u0011)\u0019\u0019\u0001AI\u0001\n\u0003Y#1\u0017\u0005\t\u0007\u000b\u0001A\u0011A\u0016\u0004\b!91Q\u0002\u0001\u0005\n\r=!!F*ue\u0016\fW.\u001b8h#V,'/_'b]\u0006<WM\u001d\u0006\u0003U-\nqa\u00197bgNL7M\u0003\u0002-[\u0005\u00191/\u001d7\u000b\u00059z\u0013!B:qCJ\\'B\u0001\u00192\u0003\u0019\t\u0007/Y2iK*\t!'A\u0002pe\u001e\u001c\u0001aE\u0002\u0001ki\u0002\"AN\u001d\u000e\u0003]R!\u0001O\u0016\u0002\u0013M$(/Z1nS:<\u0017B\u0001\u00158!\tYd(D\u0001=\u0015\tiT&\u0001\u0005j]R,'O\\1m\u0013\tyDHA\u0004M_\u001e<\u0017N\\4\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005\t\u001bU\"A\u0015\n\u0005\u0011K#\u0001D*qCJ\\7+Z:tS>t\u0017aB:rY\u000e{gN\u001a\t\u0003\u000f&k\u0011\u0001\u0013\u0006\u0003{-J!A\u0013%\u0003\u000fM\u000bFjQ8oM\u00061A(\u001b8jiz\"2!\u0014(P!\t\u0011\u0005\u0001C\u0003A\u0007\u0001\u0007\u0011\tC\u0003F\u0007\u0001\u0007a)A\u000bti\u0006$Xm\u0015;pe\u0016\u001cun\u001c:eS:\fGo\u001c:\u0016\u0003I\u0003\"aU-\u000e\u0003QS!!\u0016,\u0002\u000bM$\u0018\r^3\u000b\u0005a:&B\u0001-,\u0003%)\u00070Z2vi&|g.\u0003\u0002[)\nA2\u000b^1uKN#xN]3D_>\u0014H-\u001b8bi>\u0014(+\u001a4\u0002-M$\u0018\r^3Ti>\u0014XmQ8pe\u0012Lg.\u0019;pe\u0002\n1\u0002\\5ti\u0016tWM\u001d\"vgV\ta\f\u0005\u0002`E6\t\u0001M\u0003\u0002b-\u00069!/\u001e8uS6,\u0017BA2a\u0005e\u0019FO]3b[&tw-U;fefd\u0015n\u001d;f]\u0016\u0014()^:\u0002\u00191L7\u000f^3oKJ\u0014Uo\u001d\u0011\u0002\u001b\u0005\u001cG/\u001b<f#V,'/[3t+\u00059\u0007\u0003\u00025pcfl\u0011!\u001b\u0006\u0003U.\fq!\\;uC\ndWM\u0003\u0002m[\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u00039\fQa]2bY\u0006L!\u0001]5\u0003\u000f!\u000b7\u000f['baB\u0011!o^\u0007\u0002g*\u0011A/^\u0001\u0005kRLGNC\u0001w\u0003\u0011Q\u0017M^1\n\u0005a\u001c(\u0001B+V\u0013\u0012\u0003\"A\u0011>\n\u0005mL#AD*ue\u0016\fW.\u001b8h#V,'/_\u0001\u000fC\u000e$\u0018N^3Rk\u0016\u0014\u0018.Z:!Q\u0019Ia0!\u0005\u0002\u0014A\u0019q0!\u0004\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\t!bY8oGV\u0014(/\u001a8u\u0015\u0011\t9!!\u0003\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002\u0002\f\u0005)!.\u0019<bq&!\u0011qBA\u0001\u0005%9U/\u0019:eK\u0012\u0014\u00150A\u0003wC2,X-\t\u0002\u0002\u0016\u00059\u0012m\u0019;jm\u0016\fV/\u001a:jKN\u001c\u0006.\u0019:fI2{7m[\u000b\u0003\u00033\u0001B!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?)\u0018\u0001\u00027b]\u001eLA!a\t\u0002\u001e\t1qJ\u00196fGR\f\u0001$Y2uSZ,\u0017+^3sS\u0016\u001c8\u000b[1sK\u0012dunY6!\u0003Q\tw/Y5u)\u0016\u0014X.\u001b8bi&|g\u000eT8dW\u0006)\u0012m^1jiR+'/\\5oCRLwN\u001c'pG.\u0004\u0013\u0001\b7bgR$VM]7j]\u0006$X\rZ)vKJLX\t_2faRLwN\\\u000b\u0003\u0003_\u0001b!!\r\u00024\u0005]R\"A7\n\u0007\u0005URN\u0001\u0004PaRLwN\u001c\t\u0004m\u0005e\u0012bAA\u001eo\t92\u000b\u001e:fC6LgnZ)vKJLX\t_2faRLwN\\\u0001!Y\u0006\u001cH\u000fV3s[&t\u0017\r^3e#V,'/_#yG\u0016\u0004H/[8o?\u0012*\u0017\u000f\u0006\u0003\u0002B\u0005\u001d\u0003\u0003BA\u0019\u0003\u0007J1!!\u0012n\u0005\u0011)f.\u001b;\t\u0013\u0005%s\"!AA\u0002\u0005=\u0012a\u0001=%c\u0005iB.Y:u)\u0016\u0014X.\u001b8bi\u0016$\u0017+^3ss\u0016C8-\u001a9uS>t\u0007\u0005\u000b\u0004\u0011}\u0006E\u0011qJ\u0011\u0003\u0003O\ta!Y2uSZ,WCAA+!\u0015\t\t$a\u0016z\u0013\r\tI&\u001c\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0004O\u0016$HcA=\u0002`!1\u0011\u0011\r\nA\u0002E\f!!\u001b3\u0015\u0007e\f)\u0007C\u0004\u0002bM\u0001\r!a\u001a\u0011\t\u0005%\u0014q\u000f\b\u0005\u0003W\n\u0019\bE\u0002\u0002n5l!!a\u001c\u000b\u0007\u0005E4'\u0001\u0004=e>|GOP\u0005\u0004\u0003kj\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002z\u0005m$AB*ue&twMC\u0002\u0002v5\f1#Y<bSR\fe.\u001f+fe6Lg.\u0019;j_:$\"!!\u0011)\u000bQ\t\u0019)!#\u0011\r\u0005E\u0012QQA\u001c\u0013\r\t9)\u001c\u0002\u0007i\"\u0014xn^:2\u000b\u0015\nY)!)+\t\u00055\u0015\u0011\u0013\t\u0005\u00037\ty)\u0003\u0003\u0002z\u0005u1FAAJ!\u0011\t)*!(\u000e\u0005\u0005]%\u0002BAM\u00037\u000bA!\\3uC*\u0019\u0011qA7\n\t\u0005}\u0015q\u0013\u0002\u000bI\u00164\u0017-\u001e7u\u0003J<\u0017EAAR\u0003\u0001!B!a*\u0002.B!\u0011\u0011GAU\u0013\r\tY+\u001c\u0002\b\u0005>|G.Z1o\u0011\u001d\ty+\u0006a\u0001\u0003c\u000b\u0011\u0002^5nK>,H/T:\u0011\t\u0005E\u00121W\u0005\u0004\u0003kk'\u0001\u0002'p]\u001eDS!FAB\u0003s\u000bT!JAF\u0003C\u000bqB]3tKR$VM]7j]\u0006$X\rZ\u0001\fC\u0012$G*[:uK:,'\u000f\u0006\u0003\u0002B\u0005\u0005\u0007bBAb/\u0001\u0007\u0011QY\u0001\tY&\u001cH/\u001a8feB\u0019a'a2\n\u0007\u0005%wG\u0001\fTiJ,\u0017-\\5oOF+XM]=MSN$XM\\3s\u00039\u0011X-\\8wK2K7\u000f^3oKJ$B!!\u0011\u0002P\"9\u00111\u0019\rA\u0002\u0005\u0015\u0017!\u00047jgRd\u0015n\u001d;f]\u0016\u00148\u000f\u0006\u0002\u0002VB1\u0011\u0011GA,\u0003\u000b\f\u0011\u0003]8ti2K7\u000f^3oKJ,e/\u001a8u)\u0011\t\t%a7\t\u000f\u0005u'\u00041\u0001\u0002`\u0006)QM^3oiB!\u0011\u0011]At\u001d\r1\u00141]\u0005\u0004\u0003K<\u0014AF*ue\u0016\fW.\u001b8h#V,'/\u001f'jgR,g.\u001a:\n\t\u0005%\u00181\u001e\u0002\u0006\u000bZ,g\u000e\u001e\u0006\u0004\u0003K<\u0014\u0001G;tK\u0006\u001b\u0018P\\2Qe><'/Z:t)J\f7m[5oOR!\u0011qUAy\u0011\u001d\t\u0019p\u0007a\u0001\u0003k\fA\"\u001a=ue\u0006|\u0005\u000f^5p]N\u0004\u0002\"!\u001b\u0002x\u0006\u001d\u0014qM\u0005\u0005\u0003s\fYHA\u0002NCB\f1b\u0019:fCR,\u0017+^3ssRQ\u0012q B\u0003\u0005\u0017\u0011yA!\r\u00034\t\u001d#\u0011\u000bB+\u00053\u0012\u0019G!\u001d\u0003\nB\u0019qL!\u0001\n\u0007\t\r\u0001MA\u000bTiJ,\u0017-\\5oOF+XM]=Xe\u0006\u0004\b/\u001a:\t\u000f\t\u001dA\u00041\u0001\u0003\n\u0005\tRo]3s'B,7-\u001b4jK\u0012t\u0015-\\3\u0011\r\u0005E\u00121GA4\u0011\u001d\u0011i\u0001\ba\u0001\u0005\u0013\tq$^:feN\u0003XmY5gS\u0016$7\t[3dWB|\u0017N\u001c;M_\u000e\fG/[8o\u0011\u001d\u0011\t\u0002\ba\u0001\u0005'\t!\u0001\u001a41\t\tU!q\u0004\t\u0006\u0005\n]!1D\u0005\u0004\u00053I#a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0005;\u0011y\u0002\u0004\u0001\u0005\u0019\t\u0005\"qBA\u0001\u0002\u0003\u0015\tAa\t\u0003\u0007}#\u0013'\u0005\u0003\u0003&\t-\u0002\u0003BA\u0019\u0005OI1A!\u000bn\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!!\r\u0003.%\u0019!qF7\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002tr\u0001\r!!>\t\u000f\tUB\u00041\u0001\u00038\u0005!1/\u001b8l!\u0011\u0011IDa\u0011\u000e\u0005\tm\"\u0002\u0002B\u001f\u0005\u007f\tqaY1uC2|wMC\u0002\u0003B-\n\u0011bY8o]\u0016\u001cGo\u001c:\n\t\t\u0015#1\b\u0002\u0006)\u0006\u0014G.\u001a\u0005\b\u0005\u0013b\u0002\u0019\u0001B&\u0003)yW\u000f\u001e9vi6{G-\u001a\t\u0004m\t5\u0013b\u0001B(o\tQq*\u001e;qkRlu\u000eZ3\t\u000f\tMC\u00041\u0001\u0002(\u0006IRo]3UK6\u00048\t[3dWB|\u0017N\u001c;M_\u000e\fG/[8o\u0011\u001d\u00119\u0006\ba\u0001\u0003O\u000bQD]3d_Z,'O\u0012:p[\u000eCWmY6q_&tG\u000fT8dCRLwN\u001c\u0005\b\u00057b\u0002\u0019\u0001B/\u0003\u001d!(/[4hKJ\u00042A\u000eB0\u0013\r\u0011\tg\u000e\u0002\b)JLwmZ3s\u0011\u001d\u0011)\u0007\ba\u0001\u0005O\nA\u0002\u001e:jO\u001e,'o\u00117pG.\u0004BA!\u001b\u0003n5\u0011!1\u000e\u0006\u0003i6JAAa\u001c\u0003l\t)1\t\\8dW\"I!1\u000f\u000f\u0011\u0002\u0003\u0007!QO\u0001\u0010G\u0006$\u0018\r\\8h\u0003:$\u0017\nZ3oiB1\u0011\u0011GA\u001a\u0005o\u0002\u0002\"!\r\u0003z\tu$1Q\u0005\u0004\u0005wj'A\u0002+va2,'\u0007\u0005\u0003\u0003:\t}\u0014\u0002\u0002BA\u0005w\u0011A\u0002V1cY\u0016\u001c\u0015\r^1m_\u001e\u0004BA!\u000f\u0003\u0006&!!q\u0011B\u001e\u0005)IE-\u001a8uS\u001aLWM\u001d\u0005\n\u0005\u0017c\u0002\u0013!a\u0001\u0005\u001b\u000bAbY1uC2|w\rV1cY\u0016\u0004b!!\r\u00024\t=\u0005\u0003\u0002BI\u00053k!Aa%\u000b\t\tu\"Q\u0013\u0006\u0004\u0005/[\u0013\u0001C2bi\u0006d\u0017p\u001d;\n\t\tm%1\u0013\u0002\r\u0007\u0006$\u0018\r\\8h)\u0006\u0014G.Z\u0001\u0017GJ,\u0017\r^3Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132cU\u0011!\u0011\u0015\u0016\u0005\u0005k\u0012\u0019k\u000b\u0002\u0003&B!!q\u0015BW\u001b\t\u0011IK\u0003\u0003\u0003,\u0006m\u0015!C;oG\",7m[3e\u0013\u0011\u0011yK!+\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\fde\u0016\fG/Z)vKJLH\u0005Z3gCVdG\u000fJ\u00193+\t\u0011)L\u000b\u0003\u0003\u000e\n\r\u0016AC:uCJ$\u0018+^3ssRI\u0012Pa/\u0003>\n}&1\u001aBg\u0005\u001f\u0014\tNa5\u0003V\n]'\u0011\u001cBn\u0011\u001d\u00119a\ba\u0001\u0005\u0013AqA!\u0004 \u0001\u0004\u0011I\u0001C\u0004\u0003\u0012}\u0001\rA!11\t\t\r'q\u0019\t\u0006\u0005\n]!Q\u0019\t\u0005\u0005;\u00119\r\u0002\u0007\u0003J\n}\u0016\u0011!A\u0001\u0006\u0003\u0011\u0019CA\u0002`IIBq!a= \u0001\u0004\t)\u0010C\u0004\u00036}\u0001\rAa\u000e\t\u000f\t%s\u00041\u0001\u0003L!I!1K\u0010\u0011\u0002\u0003\u0007\u0011q\u0015\u0005\n\u0005/z\u0002\u0013!a\u0001\u0003OC\u0011Ba\u0017 !\u0003\u0005\rA!\u0018\t\u0013\t\u0015t\u0004%AA\u0002\t\u001d\u0004\"\u0003B:?A\u0005\t\u0019\u0001B;\u0011%\u0011Yi\bI\u0001\u0002\u0004\u0011i\tK\u0003 \u0005?\u0014Y\u000f\u0005\u0004\u00022\u0005\u0015%\u0011\u001d\t\u0005\u0005G\u00149/\u0004\u0002\u0003f*\u0019\u00111A:\n\t\t%(Q\u001d\u0002\u0011)&lWm\\;u\u000bb\u001cW\r\u001d;j_:\fT!JAF\u0003C\u000bAc\u001d;beR\fV/\u001a:zI\u0011,g-Y;mi\u0012:TC\u0001ByU\u0011\t9Ka)\u0002)M$\u0018M\u001d;Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00139\u0003Q\u0019H/\u0019:u#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%sU\u0011!\u0011 \u0016\u0005\u0005;\u0012\u0019+A\u000bti\u0006\u0014H/U;fef$C-\u001a4bk2$H%\r\u0019\u0016\u0005\t}(\u0006\u0002B4\u0005G\u000bQc\u001d;beR\fV/\u001a:zI\u0011,g-Y;mi\u0012\n\u0014'A\u000bti\u0006\u0014H/U;fef$C-\u001a4bk2$H%\r\u001a\u0002-9|G/\u001b4z#V,'/\u001f+fe6Lg.\u0019;j_:$B!!\u0011\u0004\n!111\u0002\u0014A\u0002e\fq\u0002^3s[&t\u0017\r^3e#V,'/_\u0001\u001bk:\u0014XmZ5ti\u0016\u0014H+\u001a:nS:\fG/\u001a3TiJ,\u0017-\u001c\u000b\u0005\u0003\u0003\u001a\t\u0002\u0003\u0004\u0004\f\u001d\u0002\r!\u001f\u0015\u0004\u0001\rU\u0001\u0003BB\f\u00077i!a!\u0007\u000b\u0007\u0005\u001dQ&\u0003\u0003\u0004\u001e\re!\u0001C#w_24\u0018N\\4")
public class StreamingQueryManager
extends org.apache.spark.sql.streaming.StreamingQueryManager
implements Logging {
    private final SparkSession sparkSession;
    private final SQLConf sqlConf;
    private final StateStoreCoordinatorRef stateStoreCoordinator;
    private final StreamingQueryListenerBus listenerBus;
    @GuardedBy(value="activeQueriesSharedLock")
    private final HashMap<UUID, StreamingQuery> activeQueries;
    private final Object activeQueriesSharedLock;
    private final Object awaitTerminationLock;
    @GuardedBy(value="awaitTerminationLock")
    private Option<StreamingQueryException> lastTerminatedQueryException;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public StateStoreCoordinatorRef stateStoreCoordinator() {
        return this.stateStoreCoordinator;
    }

    private StreamingQueryListenerBus listenerBus() {
        return this.listenerBus;
    }

    private HashMap<UUID, StreamingQuery> activeQueries() {
        return this.activeQueries;
    }

    private Object activeQueriesSharedLock() {
        return this.activeQueriesSharedLock;
    }

    private Object awaitTerminationLock() {
        return this.awaitTerminationLock;
    }

    private Option<StreamingQueryException> lastTerminatedQueryException() {
        return this.lastTerminatedQueryException;
    }

    private void lastTerminatedQueryException_$eq(Option<StreamingQueryException> x$1) {
        this.lastTerminatedQueryException = x$1;
    }

    public StreamingQuery[] active() {
        StreamingQuery[] streamingQueryArray;
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            streamingQueryArray = (StreamingQuery[])this.activeQueries().values().toArray(ClassTag$.MODULE$.apply(StreamingQuery.class));
        }
        return streamingQueryArray;
    }

    public StreamingQuery get(UUID id) {
        StreamingQuery streamingQuery;
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            streamingQuery = (StreamingQuery)this.activeQueries().get((Object)id).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return streamingQuery;
    }

    public StreamingQuery get(String id) {
        return this.get(UUID.fromString(id));
    }

    public void awaitAnyTermination() throws StreamingQueryException {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (this.lastTerminatedQueryException() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQueryException() != null && this.lastTerminatedQueryException().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQueryException().get();
            }
        }
    }

    public boolean awaitAnyTermination(long timeoutMs) throws StreamingQueryException {
        boolean bl;
        long startTime = System.nanoTime();
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (!StreamingQueryManager.isTimedout$1(startTime, timeoutMs) && this.lastTerminatedQueryException() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQueryException() != null && this.lastTerminatedQueryException().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQueryException().get();
            }
            bl = this.lastTerminatedQueryException() != null;
        }
        return bl;
    }

    public void resetTerminated() {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            this.lastTerminatedQueryException_$eq(null);
        }
    }

    public void addListener(StreamingQueryListener listener) {
        this.listenerBus().addListener(listener);
    }

    public void removeListener(StreamingQueryListener listener) {
        this.listenerBus().removeListener(listener);
    }

    public StreamingQueryListener[] listListeners() {
        return (StreamingQueryListener[])CollectionConverters$.MODULE$.ListHasAsScala(this.listenerBus().listeners()).asScala().toArray(ClassTag$.MODULE$.apply(StreamingQueryListener.class));
    }

    public void postListenerEvent(StreamingQueryListener.Event event) {
        this.listenerBus().post(event);
    }

    private boolean useAsyncProgressTracking(scala.collection.immutable.Map<String, String> extraOptions) {
        return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)extraOptions.getOrElse((Object)AsyncProgressTrackingMicroBatchExecution$.MODULE$.ASYNC_PROGRESS_TRACKING_ENABLED(), (Function0 & Serializable)() -> "false")));
    }

    private StreamingQueryWrapper createQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<?> df, scala.collection.immutable.Map<String, String> extraOptions, Table sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock, Option<Tuple2<TableCatalog, Identifier>> catalogAndIdent, Option<CatalogTable> catalogTable) {
        MicroBatchExecution microBatchExecution;
        LogicalPlan analyzedPlan = df.queryExecution().analyzed();
        df.queryExecution().assertAnalyzed();
        if (trigger instanceof RealTimeTrigger) {
            long minBatchDuration = BoxesRunTime.unboxToLong(this.sparkSession.conf().get(SQLConf$.MODULE$.STREAMING_REAL_TIME_MODE_MIN_BATCH_DURATION()));
            RealTimeTrigger realTimeTrigger = (RealTimeTrigger)trigger;
            if (realTimeTrigger.batchDurationMs() < minBatchDuration) {
                throw new SparkIllegalArgumentException("INVALID_STREAMING_REAL_TIME_MODE_TRIGGER_INTERVAL", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"interval"), (Object)Long.toString(realTimeTrigger.batchDurationMs())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"minBatchDuration"), (Object)Long.toString(minBatchDuration))})));
            }
        }
        WriteToStreamStatement dataStreamWritePlan = new WriteToStreamStatement(userSpecifiedName, userSpecifiedCheckpointLocation, useTempCheckpointLocation, recoverFromCheckpointLocation, sink, outputMode, df.sparkSession().sessionState().newHadoopConf(), trigger, analyzedPlan, catalogAndIdent, catalogTable);
        WriteToStream analyzedStreamWritePlan = (WriteToStream)this.sparkSession.sessionState().executePlan((LogicalPlan)dataStreamWritePlan, this.sparkSession.sessionState().executePlan$default$2()).analyzed();
        Tuple2 tuple2 = new Tuple2((Object)sink, (Object)trigger);
        if (tuple2 != null) {
            Trigger trigger2 = (Trigger)tuple2._2();
            if (tuple2._1() instanceof SupportsWrite && trigger2 instanceof ContinuousTrigger) {
                ContinuousTrigger continuousTrigger = (ContinuousTrigger)trigger2;
                return new StreamingQueryWrapper(new ContinuousExecution(this.sparkSession, (Trigger)continuousTrigger, triggerClock, extraOptions, analyzedStreamWritePlan));
            }
        }
        if (this.useAsyncProgressTracking(extraOptions)) {
            if (trigger instanceof RealTimeTrigger) {
                throw new SparkIllegalArgumentException("STREAMING_REAL_TIME_MODE.ASYNC_PROGRESS_TRACKING_NOT_SUPPORTED");
            }
            microBatchExecution = new AsyncProgressTrackingMicroBatchExecution(this.sparkSession, trigger, triggerClock, extraOptions, analyzedStreamWritePlan);
        } else {
            microBatchExecution = new MicroBatchExecution(this.sparkSession, trigger, triggerClock, extraOptions, analyzedStreamWritePlan);
        }
        MicroBatchExecution microBatchExecution2 = microBatchExecution;
        return new StreamingQueryWrapper(microBatchExecution2);
    }

    private Option<Tuple2<TableCatalog, Identifier>> createQuery$default$11() {
        return None$.MODULE$;
    }

    private Option<CatalogTable> createQuery$default$12() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StreamingQuery startQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<?> df, scala.collection.immutable.Map<String, String> extraOptions, Table sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock, Option<Tuple2<TableCatalog, Identifier>> catalogAndIdent, Option<CatalogTable> catalogTable) throws TimeoutException {
        None$ none$;
        StreamingQueryWrapper query = this.createQuery(userSpecifiedName, userSpecifiedCheckpointLocation, df, extraOptions, sink, outputMode, useTempCheckpointLocation, recoverFromCheckpointLocation, trigger, triggerClock, catalogAndIdent, catalogTable);
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            None$ none$2;
            userSpecifiedName.foreach((Function1 & Serializable)name -> {
                StreamingQueryManager.$anonfun$startQuery$1(this, name);
                return BoxedUnit.UNIT;
            });
            Option activeOption = Option$.MODULE$.apply((Object)this.sparkSession.sharedState().activeStreamingQueries().get(query.id())).orElse((Function0 & Serializable)() -> this.activeQueries().get((Object)query.id()));
            boolean shouldStopActiveRun = BoxesRunTime.unboxToBoolean((Object)this.sparkSession.sessionState().conf().getConf(SQLConf$.MODULE$.STREAMING_STOP_ACTIVE_RUN_ON_RESTART()));
            if (activeOption.isDefined()) {
                if (!shouldStopActiveRun) throw new IllegalStateException("Cannot start query with id " + query.id() + " as another query with same id is already active. Perhaps you are attempting to restart a query from checkpoint that is already active. You may stop the old query by setting the SQL configuration: spark.conf.set(\"" + SQLConf$.MODULE$.STREAMING_STOP_ACTIVE_RUN_ON_RESTART().key() + "\", true) and retry.");
                StreamingQuery oldQuery = (StreamingQuery)activeOption.get();
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping existing streaming query [id=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.QUERY_ID, query.id())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"runId=", "], as a new run is being started."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.RUN_ID, oldQuery.runId())})))));
                none$2 = new Some((Object)oldQuery);
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        None$ activeRunOpt = none$;
        activeRunOpt.foreach((Function1 & Serializable)x$3 -> {
            x$3.stop();
            return BoxedUnit.UNIT;
        });
        Object object2 = this.activeQueriesSharedLock();
        synchronized (object2) {
            StreamExecution oldActiveQuery = this.sparkSession.sharedState().activeStreamingQueries().put(query.id(), query.streamingQuery());
            if (oldActiveQuery != null) {
                throw QueryExecutionErrors$.MODULE$.concurrentQueryInstanceError();
            }
            this.activeQueries().put((Object)query.id(), (Object)query);
        }
        try {
            query.streamingQuery().start();
            return query;
        }
        catch (Throwable e) {
            this.unregisterTerminatedStream(query);
            throw e;
        }
    }

    public boolean startQuery$default$7() {
        return false;
    }

    public boolean startQuery$default$8() {
        return true;
    }

    public Trigger startQuery$default$9() {
        return Trigger.ProcessingTime((long)0L);
    }

    public Clock startQuery$default$10() {
        return new SystemClock();
    }

    public Option<Tuple2<TableCatalog, Identifier>> startQuery$default$11() {
        return None$.MODULE$;
    }

    public Option<CatalogTable> startQuery$default$12() {
        return None$.MODULE$;
    }

    public void notifyQueryTermination(StreamingQuery terminatedQuery) {
        this.unregisterTerminatedStream(terminatedQuery);
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            if (this.lastTerminatedQueryException() == null || terminatedQuery.exception().nonEmpty()) {
                this.lastTerminatedQueryException_$eq((Option<StreamingQueryException>)terminatedQuery.exception());
            }
            this.awaitTerminationLock().notifyAll();
        }
        this.stateStoreCoordinator().deactivateInstances(terminatedQuery.runId());
    }

    private void unregisterTerminatedStream(StreamingQuery terminatedQuery) {
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            this.sparkSession.sharedState().activeStreamingQueries().remove(terminatedQuery.id(), terminatedQuery);
            HashMap cfr_ignored_0 = (HashMap)this.activeQueries().$minus$eq((Object)terminatedQuery.id());
        }
    }

    public static final /* synthetic */ void $anonfun$new$3(StreamingQueryManager $this, StreamingQueryListener listener) {
        $this.addListener(listener);
        $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Registered listener ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.CLASS_NAME, listener.getClass().getName())}))));
    }

    private static final boolean isTimedout$1(long startTime$1, long timeoutMs$1) {
        return System.nanoTime() - startTime$1 >= TimeUnit.MILLISECONDS.toNanos(timeoutMs$1);
    }

    public static final /* synthetic */ boolean $anonfun$startQuery$2(String name$1, StreamingQuery x$2) {
        String string = x$2.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$startQuery$1(StreamingQueryManager $this, String name) {
        if ($this.activeQueries().values().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StreamingQueryManager.$anonfun$startQuery$2(name, x$2)))) {
            throw new IllegalArgumentException("Cannot start query with name " + name + " as a query with that name is already active in this SparkSession");
        }
    }

    public StreamingQueryManager(SparkSession sparkSession, SQLConf sqlConf) {
        this.sparkSession = sparkSession;
        this.sqlConf = sqlConf;
        Logging.$init$((Logging)this);
        this.stateStoreCoordinator = StateStoreCoordinatorRef$.MODULE$.forDriver(sparkSession.sparkContext().env(), sqlConf);
        this.listenerBus = new StreamingQueryListenerBus((Option<LiveListenerBus>)new Some((Object)sparkSession.sparkContext().listenerBus()));
        this.activeQueries = new HashMap();
        this.activeQueriesSharedLock = sparkSession.sharedState().activeQueriesLock();
        this.awaitTerminationLock = new Object();
        try {
            ((Option)sparkSession.sparkContext().conf().get((ConfigEntry)StaticSQLConf$.MODULE$.STREAMING_QUERY_LISTENERS())).foreach((Function1 & Serializable)classNames -> {
                SQLConf$.MODULE$.withExistingConf(this.sqlConf, (Function0)(JFunction0.mcV.sp & Serializable)() -> Utils$.MODULE$.loadExtensions(StreamingQueryListener.class, classNames, this.sparkSession.sparkContext().conf()).foreach((Function1 & Serializable)listener -> {
                    StreamingQueryManager.$anonfun$new$3($this, listener);
                    return BoxedUnit.UNIT;
                }));
                return BoxedUnit.UNIT;
            });
            sparkSession.sharedState().streamingQueryStatusListener().foreach((Function1 & Serializable)listener -> {
                this.addListener(listener);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            throw QueryExecutionErrors$.MODULE$.registeringStreamingQueryListenerError(e);
        }
    }
}

