/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.DataSourceManager$;
import org.apache.spark.sql.execution.datasources.v2.python.UserDefinedPythonDataSource;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.StringContext;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a\u0001B\n\u0015\u0001\u0005BQA\f\u0001\u0005\u0002=B\u0001B\r\u0001\t\u0006\u0004%Ia\r\u0005\b\u0015\u0002\u0011\r\u0011\"\u0003L\u0011\u00191\u0006\u0001)A\u0005\u0019\")q\u000b\u0001C\u00011\")\u0001\r\u0001C\u0001C\")1\r\u0001C\u0001I\")\u0011\u000e\u0001C\u0005U\")q\u000e\u0001C!_\u001d)\u0001\u000f\u0006E\u0001c\u001a)1\u0003\u0006E\u0001e\")af\u0003C\u0001g\"AAo\u0003a\u0001\n\u0003QR\u000f\u0003\u0005x\u0017\u0001\u0007I\u0011\u0001\u000ey\u0011\u0019Y8\u0002)Q\u0005m\"AAp\u0003EC\u0002\u0013%Q\u0010C\u0003\u007f\u0017\u0011%q\u0010\u0003\u0004\u0002\u0004-!Ia\r\u0002\u0012\t\u0006$\u0018mU8ve\u000e,W*\u00198bO\u0016\u0014(BA\u000b\u0017\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005]A\u0012!C3yK\u000e,H/[8o\u0015\tI\"$A\u0002tc2T!a\u0007\u000f\u0002\u000bM\u0004\u0018M]6\u000b\u0005uq\u0012AB1qC\u000eDWMC\u0001 \u0003\ry'oZ\u0002\u0001'\r\u0001!\u0005\u000b\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-R\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u00055R#a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003A\u0002\"!\r\u0001\u000e\u0003Q\t\u0001d\u001d;bi&\u001cG)\u0019;b'>,(oY3Ck&dG-\u001a:t+\u0005!\u0004\u0003B\u001b=\u007f\ts!A\u000e\u001e\u0011\u0005]\"S\"\u0001\u001d\u000b\u0005e\u0002\u0013A\u0002\u001fs_>$h(\u0003\u0002<I\u00051\u0001K]3eK\u001aL!!\u0010 \u0003\u00075\u000b\u0007O\u0003\u0002<IA\u0011Q\u0007Q\u0005\u0003\u0003z\u0012aa\u0015;sS:<\u0007CA\"I\u001b\u0005!%BA#G\u0003\u0019\u0001\u0018\u0010\u001e5p]*\u0011q\tF\u0001\u0003mJJ!!\u0013#\u00037U\u001bXM\u001d#fM&tW\r\u001a)zi\"|g\u000eR1uCN{WO]2f\u0003e\u0011XO\u001c;j[\u0016$\u0015\r^1T_V\u00148-\u001a\"vS2$WM]:\u0016\u00031\u0003B!\u0014+@\u00056\taJ\u0003\u0002P!\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005E\u0013\u0016\u0001B;uS2T\u0011aU\u0001\u0005U\u00064\u0018-\u0003\u0002V\u001d\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u00025I,h\u000e^5nK\u0012\u000bG/Y*pkJ\u001cWMQ;jY\u0012,'o\u001d\u0011\u0002%I,w-[:uKJ$\u0015\r^1T_V\u00148-\u001a\u000b\u00043rs\u0006CA\u0012[\u0013\tYFE\u0001\u0003V]&$\b\"B/\u0006\u0001\u0004y\u0014\u0001\u00028b[\u0016DQaX\u0003A\u0002\t\u000baa]8ve\u000e,\u0017\u0001\u00057p_.,\b\u000fR1uCN{WO]2f)\t\u0011%\rC\u0003^\r\u0001\u0007q(\u0001\teCR\f7k\\;sG\u0016,\u00050[:ugR\u0011Q\r\u001b\t\u0003G\u0019L!a\u001a\u0013\u0003\u000f\t{w\u000e\\3b]\")Ql\u0002a\u0001\u007f\u0005iq-\u001a;ECR\f7k\\;sG\u0016$\"a\u001b8\u0011\u0007\rb')\u0003\u0002nI\t1q\n\u001d;j_:DQ!\u0018\u0005A\u0002}\nQa\u00197p]\u0016\f\u0011\u0003R1uCN{WO]2f\u001b\u0006t\u0017mZ3s!\t\t4bE\u0002\fE!\"\u0012!]\u0001\u0013I\u0006$\u0018mU8ve\u000e,')^5mI\u0016\u00148/F\u0001w!\r\u0019C\u000eN\u0001\u0017I\u0006$\u0018mU8ve\u000e,')^5mI\u0016\u00148o\u0018\u0013fcR\u0011\u0011,\u001f\u0005\bu:\t\t\u00111\u0001w\u0003\rAH%M\u0001\u0014I\u0006$\u0018mU8ve\u000e,')^5mI\u0016\u00148\u000fI\u0001\u001cg\"|W\u000f\u001c3M_\u0006$\u0007+\u001f;i_:$\u0015\r^1T_V\u00148-Z:\u0016\u0003\u0015\f\u0011B\\8s[\u0006d\u0017N_3\u0015\u0007}\n\t\u0001C\u0003^#\u0001\u0007q(A\u0010j]&$\u0018.\u00197Ti\u0006$\u0018n\u0019#bi\u0006\u001cv.\u001e:dK\n+\u0018\u000e\u001c3feN\u0004")
public class DataSourceManager
implements Logging {
    private Map<String, UserDefinedPythonDataSource> staticDataSourceBuilders;
    private final ConcurrentHashMap<String, UserDefinedPythonDataSource> runtimeDataSourceBuilders;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Map<String, UserDefinedPythonDataSource> staticDataSourceBuilders$lzycompute() {
        DataSourceManager dataSourceManager = this;
        synchronized (dataSourceManager) {
            if (!this.bitmap$0) {
                this.staticDataSourceBuilders = DataSourceManager$.MODULE$.org$apache$spark$sql$execution$datasources$DataSourceManager$$initialStaticDataSourceBuilders();
                this.bitmap$0 = true;
            }
        }
        return this.staticDataSourceBuilders;
    }

    private Map<String, UserDefinedPythonDataSource> staticDataSourceBuilders() {
        if (!this.bitmap$0) {
            return this.staticDataSourceBuilders$lzycompute();
        }
        return this.staticDataSourceBuilders;
    }

    private ConcurrentHashMap<String, UserDefinedPythonDataSource> runtimeDataSourceBuilders() {
        return this.runtimeDataSourceBuilders;
    }

    public void registerDataSource(String name, UserDefinedPythonDataSource source) {
        String normalizedName = DataSourceManager$.MODULE$.org$apache$spark$sql$execution$datasources$DataSourceManager$$normalize(name);
        UserDefinedPythonDataSource previousValue = this.runtimeDataSourceBuilders().put(normalizedName, source);
        if (previousValue != null) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"The data source ", " replaced a previously "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.DATA_SOURCE, name)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"registered data source."}))).log((Seq)Nil$.MODULE$))));
            return;
        }
        if (this.staticDataSourceBuilders().contains((Object)normalizedName)) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"The data source ", " replaced a statically "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.DATA_SOURCE, name)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"registered data source."}))).log((Seq)Nil$.MODULE$))));
            return;
        }
    }

    public UserDefinedPythonDataSource lookupDataSource(String name) {
        return (UserDefinedPythonDataSource)this.getDataSource(name).getOrElse((Function0 & Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.dataSourceDoesNotExist(name);
        });
    }

    public boolean dataSourceExists(String name) {
        return this.getDataSource(name).isDefined();
    }

    private Option<UserDefinedPythonDataSource> getDataSource(String name) {
        String normalizedName = DataSourceManager$.MODULE$.org$apache$spark$sql$execution$datasources$DataSourceManager$$normalize(name);
        return Option$.MODULE$.apply((Object)this.runtimeDataSourceBuilders().get(normalizedName)).orElse((Function0 & Serializable)() -> this.staticDataSourceBuilders().get((Object)normalizedName));
    }

    public DataSourceManager clone() {
        DataSourceManager manager = new DataSourceManager();
        this.runtimeDataSourceBuilders().forEach((k, v) -> manager.registerDataSource((String)k, (UserDefinedPythonDataSource)v));
        return manager;
    }

    public DataSourceManager() {
        Logging.$init$((Logging)this);
        this.runtimeDataSourceBuilders = new ConcurrentHashMap();
    }
}

