/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.jobs;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.status.api.v1.ThreadStackTrace;
import org.apache.spark.ui.SparkUITab;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.Text$;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0005y3QAB\u0004\u0001\u0017EA\u0001B\u0006\u0001\u0003\u0002\u0003\u0006I\u0001\u0007\u0005\t7\u0001\u0011\t\u0011)A\u00059!)a\u0005\u0001C\u0001O!)A\u0006\u0001C\u0005[!)A\n\u0001C!\u001b\n\u0011B+Y:l)\"\u0014X-\u00193Ek6\u0004\b+Y4f\u0015\tA\u0011\"\u0001\u0003k_\n\u001c(B\u0001\u0006\f\u0003\t)\u0018N\u0003\u0002\r\u001b\u0005)1\u000f]1sW*\u0011abD\u0001\u0007CB\f7\r[3\u000b\u0003A\t1a\u001c:h'\t\u0001!\u0003\u0005\u0002\u0014)5\t\u0011\"\u0003\u0002\u0016\u0013\tIq+\u001a2V\u0013B\u000bw-Z\u0001\u0007a\u0006\u0014XM\u001c;\u0004\u0001A\u00111#G\u0005\u00035%\u0011!b\u00159be.,\u0016\nV1c\u0003\t\u00198\rE\u0002\u001eA\tj\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\r\"S\"A\u0006\n\u0005\u0015Z!\u0001D*qCJ\\7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0002)U-\u0002\"!\u000b\u0001\u000e\u0003\u001dAQAF\u0002A\u0002aAQaG\u0002A\u0002q\tQ#\u001a=fGV$xN\u001d+ie\u0016\fG\rR;naV\u0013H\u000e\u0006\u0003/s\u0015;\u0005CA\u00187\u001d\t\u0001D\u0007\u0005\u00022=5\t!G\u0003\u00024/\u00051AH]8pizJ!!\u000e\u0010\u0002\rA\u0013X\rZ3g\u0013\t9\u0004H\u0001\u0004TiJLgn\u001a\u0006\u0003kyAQA\u000f\u0003A\u0002m\nqA]3rk\u0016\u001cH\u000f\u0005\u0002=\u00076\tQH\u0003\u0002?\u007f\u0005!\u0001\u000e\u001e;q\u0015\t\u0001\u0015)A\u0004tKJ4H.\u001a;\u000b\u0003\t\u000bqA[1lCJ$\u0018-\u0003\u0002E{\t\u0011\u0002\n\u001e;q'\u0016\u0014h\u000f\\3u%\u0016\fX/Z:u\u0011\u00151E\u00011\u0001/\u0003))\u00070Z2vi>\u0014\u0018\n\u001a\u0005\u0006\u0011\u0012\u0001\r!S\u0001\u0011E2|7m[5oORC'/Z1e\u0013\u0012\u0004\"!\b&\n\u0005-s\"\u0001\u0002'p]\u001e\faA]3oI\u0016\u0014HC\u0001(^!\ryEk\u0016\b\u0003!Js!!M)\n\u0003}I!a\u0015\u0010\u0002\u000fA\f7m[1hK&\u0011QK\u0016\u0002\u0004'\u0016\f(BA*\u001f!\tA6,D\u0001Z\u0015\tQf$A\u0002y[2L!\u0001X-\u0003\t9{G-\u001a\u0005\u0006u\u0015\u0001\ra\u000f")
public class TaskThreadDumpPage
extends WebUIPage {
    private final SparkUITab parent;
    private final Option<SparkContext> sc;

    private String executorThreadDumpUrl(HttpServletRequest request, String executorId, long blockingThreadId) {
        String uiRoot = UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3());
        return uiRoot + "/executors/?executorId=" + executorId + "#" + blockingThreadId + "_td_id";
    }

    @Override
    public scala.collection.immutable.Seq<Node> render(HttpServletRequest request) {
        String executorId2 = (String)Option$.MODULE$.apply((Object)request.getParameter("executorId")).map((Function1 & Serializable)executorId -> UIUtils$.MODULE$.decodeURLParameter((String)executorId)).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Missing executorId parameter");
        });
        long taskId2 = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)request.getParameter("taskId")).map((Function1 & Serializable)taskId -> BoxesRunTime.boxToLong((long)TaskThreadDumpPage.$anonfun$render$3(taskId))).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Missing taskId parameter");
        }));
        long time = System.currentTimeMillis();
        Option<ThreadStackTrace> maybeThreadDump = ((SparkContext)this.sc.get()).getTaskThreadDump(taskId2, executorId2);
        Node content = (Node)maybeThreadDump.map((Function1 & Serializable)thread -> {
            Text text;
            long threadId = thread.threadId();
            Option<Object> option = thread.blockedByThreadId();
            if (option instanceof Some) {
                Some some = (Some)option;
                long blockingThreadId = BoxesRunTime.unboxToLong((Object)some.value());
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n            Blocked by\n            "));
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("href", this.executorThreadDumpUrl(request, executorId2, blockingThreadId), (MetaData)$md);
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("\n              Thread\n              "));
                $buf2.$amp$plus((Object)BoxesRunTime.boxToLong((long)blockingThreadId));
                $buf2.$amp$plus((Object)thread.blockedByLock());
                $buf2.$amp$plus((Object)new Text("\n            "));
                $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
                $buf.$amp$plus((Object)new Text("\n          "));
                Elem elem = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
                text = elem;
            } else if (None$.MODULE$.equals(option)) {
                text = Text$.MODULE$.apply("");
            } else {
                throw new MatchError(option);
            }
            Text blockedBy = text;
            scala.collection.immutable.Seq synchronizers = (scala.collection.immutable.Seq)thread.synchronizers().map((Function1 & Serializable)l -> "Lock(" + l + ")");
            scala.collection.immutable.Seq monitors = (scala.collection.immutable.Seq)thread.monitors().map((Function1 & Serializable)m -> "Monitor(" + m + ")");
            String heldLocks = ((IterableOnceOps)synchronizers.$plus$plus((IterableOnce)monitors)).mkString(", ");
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("row"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("class", (Seq)new Text("col-12"), (MetaData)$md2);
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("Updated at "));
            $buf4.$amp$plus((Object)UIUtils$.MODULE$.formatDate(time));
            $buf3.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector()));
            $buf3.$amp$plus((Object)new Text("\n          "));
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("class", UIUtils$.MODULE$.TABLE_CLASS_NOT_STRIPED() + " accordion-group", (MetaData)$md3);
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)new Text("Thread ID"));
            $buf6.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf7.toVector()));
            $buf6.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf8 = new NodeBuffer();
            $buf8.$amp$plus((Object)new Text("Thread Name"));
            $buf6.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf8.toVector()));
            $buf6.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf9 = new NodeBuffer();
            $buf9.$amp$plus((Object)new Text("Thread State"));
            $buf6.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf9.toVector()));
            $buf6.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf10 = new NodeBuffer();
            $buf10.$amp$plus((Object)new Text("\n                "));
            Null$ $md4 = Null$.MODULE$;
            $md4 = new UnprefixedAttribute("title", (Seq)new Text("Objects whose lock the thread currently holds"), (MetaData)$md4);
            $md4 = new UnprefixedAttribute("data-placement", (Seq)new Text("top"), (MetaData)$md4);
            $md4 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md4);
            NodeBuffer $buf11 = new NodeBuffer();
            $buf11.$amp$plus((Object)new Text("\n                  Thread Locks\n                "));
            $buf10.$amp$plus((Object)new Elem(null, "span", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf11.toVector()));
            $buf10.$amp$plus((Object)new Text("\n              "));
            $buf6.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf10.toVector()));
            $buf6.$amp$plus((Object)new Text("\n            "));
            $buf5.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf6.toVector()));
            $buf5.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf12 = new NodeBuffer();
            $buf12.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf13 = new NodeBuffer();
            $buf13.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf14 = new NodeBuffer();
            $buf14.$amp$plus((Object)BoxesRunTime.boxToLong((long)threadId));
            $buf13.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf14.toVector()));
            $buf13.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf15 = new NodeBuffer();
            $buf15.$amp$plus((Object)thread.threadName());
            $buf13.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf15.toVector()));
            $buf13.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf16 = new NodeBuffer();
            $buf16.$amp$plus((Object)thread.threadState());
            $buf13.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf16.toVector()));
            $buf13.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf17 = new NodeBuffer();
            $buf17.$amp$plus((Object)blockedBy);
            $buf17.$amp$plus((Object)heldLocks);
            $buf13.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf17.toVector()));
            $buf13.$amp$plus((Object)new Text("\n              "));
            $buf12.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf13.toVector()));
            $buf12.$amp$plus((Object)new Text("\n            "));
            $buf5.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf12.toVector()));
            $buf5.$amp$plus((Object)new Text("\n          "));
            $buf3.$amp$plus((Object)new Elem(null, "table", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
            $buf3.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
            $buf.$amp$plus((Object)new Text("\n\n        "));
            NodeBuffer $buf18 = new NodeBuffer();
            $buf18.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf19 = new NodeBuffer();
            $buf19.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf20 = new NodeBuffer();
            $buf20.$amp$plus((Object)thread.toString());
            $buf19.$amp$plus((Object)new Elem(null, "pre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf20.toVector()));
            $buf19.$amp$plus((Object)new Text("\n          "));
            $buf18.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf19.toVector()));
            $buf18.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf18.toVector()));
            $buf.$amp$plus((Object)new Text("\n      "));
            return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
        }).getOrElse((Function0 & Serializable)() -> Text$.MODULE$.apply("Task " + taskId2 + " finished or some error occurred during dumping thread"));
        return UIUtils$.MODULE$.headerSparkPage(request, "Thread dump for task " + taskId2, (Function0<scala.collection.immutable.Seq<Node>>)(Function0 & Serializable)() -> content, this.parent, UIUtils$.MODULE$.headerSparkPage$default$5(), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7());
    }

    public static final /* synthetic */ long $anonfun$render$3(String taskId) {
        String decoded = UIUtils$.MODULE$.decodeURLParameter(taskId);
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(decoded));
    }

    public TaskThreadDumpPage(SparkUITab parent, Option<SparkContext> sc) {
        this.parent = parent;
        this.sc = sc;
        super("taskThreadDump");
    }
}

