/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util.wrapped.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FutureIO {
    private static final Logger LOG = LoggerFactory.getLogger(FutureIO.class);

    public static <T> T awaitFuture(Future<T> future, long timeout, TimeUnit unit) throws InterruptedIOException, IOException, RuntimeException, TimeoutException {
        try {
            LOG.debug("Awaiting future");
            return future.get(timeout, unit);
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException(e.toString()).initCause(e);
        }
        catch (CompletionException | ExecutionException e) {
            throw FutureIO.unwrapInnerException(e);
        }
    }

    public static <T> T awaitFuture(Future<T> future) throws InterruptedIOException, IOException, RuntimeException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException(e.toString()).initCause(e);
        }
        catch (ExecutionException e) {
            throw FutureIO.unwrapInnerException(e);
        }
    }

    public static IOException unwrapInnerException(Throwable e) {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            return (IOException)cause;
        }
        if (cause instanceof UncheckedIOException) {
            return ((UncheckedIOException)cause).getCause();
        }
        if (cause instanceof CompletionException || cause instanceof ExecutionException) {
            return FutureIO.unwrapInnerException(cause);
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        if (cause != null) {
            return new IOException(cause);
        }
        return new IOException(e);
    }
}

