/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopK$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopKAggregateBuffer;
import org.apache.spark.sql.catalyst.expressions.aggregate.CombineInternal$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.DataType;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\ra\u0001\u0002\u000b\u0016\u0001\u0011B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\ty\u0001\u0011\t\u0019!C\u0001{!AA\t\u0001BA\u0002\u0013\u0005Q\t\u0003\u0005L\u0001\t\u0005\t\u0015)\u0003?\u0011!a\u0005A!a\u0001\n\u0003i\u0005\u0002C)\u0001\u0005\u0003\u0007I\u0011\u0001*\t\u0011Q\u0003!\u0011!Q!\n9CQ!\u0016\u0001\u0005\u0002YCQa\u0017\u0001\u0005\u0002qCQ!\u0018\u0001\u0005\u0002uBQA\u0018\u0001\u0005\u00025CQa\u0018\u0001\u0005\u0002\u0001DQ\u0001\u001b\u0001\u0005\u0002%DQ\u0001\u001c\u0001\u0005\u00025DQ\u0001\u001d\u0001\u0005\u0002E<Q\u0001_\u000b\t\u0002e4Q\u0001F\u000b\t\u0002iDQ!V\t\u0005\u0002mDQ\u0001`\t\u0005\u0002u\u0014qbQ8nE&tW-\u00138uKJt\u0017\r\u001c\u0006\u0003-]\t\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005aI\u0012aC3yaJ,7o]5p]NT!AG\u000e\u0002\u0011\r\fG/\u00197zgRT!\u0001H\u000f\u0002\u0007M\fHN\u0003\u0002\u001f?\u0005)1\u000f]1sW*\u0011\u0001%I\u0001\u0007CB\f7\r[3\u000b\u0003\t\n1a\u001c:h\u0007\u0001)\"!J\u001a\u0014\u0005\u00011\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g-A\ntW\u0016$8\r[,ji\"tU\u000f\u001c7D_VtG\u000fE\u0002/_Ej\u0011!F\u0005\u0003aU\u0011\u0011$\u00119qe>DHk\u001c9L\u0003\u001e<'/Z4bi\u0016\u0014UO\u001a4feB\u0011!g\r\u0007\u0001\t\u0015!\u0004A1\u00016\u0005\u0005!\u0016C\u0001\u001c:!\t9s'\u0003\u00029Q\t9aj\u001c;iS:<\u0007CA\u0014;\u0013\tY\u0004FA\u0002B]f\fA\"\u001b;f[\u0012\u000bG/\u0019+za\u0016,\u0012A\u0010\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003n\tQ\u0001^=qKNL!a\u0011!\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f\u0001#\u001b;f[\u0012\u000bG/\u0019+za\u0016|F%Z9\u0015\u0005\u0019K\u0005CA\u0014H\u0013\tA\u0005F\u0001\u0003V]&$\bb\u0002&\u0004\u0003\u0003\u0005\rAP\u0001\u0004q\u0012\n\u0014!D5uK6$\u0015\r^1UsB,\u0007%A\bnCbLE/Z7t)J\f7m[3e+\u0005q\u0005CA\u0014P\u0013\t\u0001\u0006FA\u0002J]R\f1#\\1y\u0013R,Wn\u001d+sC\u000e\\W\rZ0%KF$\"AR*\t\u000f)3\u0011\u0011!a\u0001\u001d\u0006\u0001R.\u0019=Ji\u0016l7\u000f\u0016:bG.,G\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t]C\u0016L\u0017\t\u0004]\u0001\t\u0004\"\u0002\u0017\t\u0001\u0004i\u0003\"\u0002\u001f\t\u0001\u0004q\u0004\"\u0002'\t\u0001\u0004q\u0015AF4fiN[W\r^2i/&$\bNT;mY\u000e{WO\u001c;\u0016\u00035\nqbZ3u\u0013R,W\u000eR1uCRK\b/Z\u0001\u0013O\u0016$X*\u0019=Ji\u0016l7\u000f\u0016:bG.,G-A\u000bva\u0012\fG/Z'bq&#X-\\:Ue\u0006\u001c7.\u001a3\u0015\u0007\u0019\u000bg\rC\u0003c\u0019\u0001\u00071-\u0001\u000bd_6\u0014\u0017N\\3TSj,7\u000b]3dS\u001aLW\r\u001a\t\u0003O\u0011L!!\u001a\u0015\u0003\u000f\t{w\u000e\\3b]\")q\r\u0004a\u0001\u001d\u0006\u0011b.Z<NCbLE/Z7t)J\f7m[3e\u0003I)\b\u000fZ1uK&#X-\u001c#bi\u0006$\u0016\u0010]3\u0015\u0005\u0019S\u0007\"B6\u000e\u0001\u0004q\u0014!E5oaV$\u0018\n^3n\t\u0006$\u0018\rV=qK\u0006IR\u000f\u001d3bi\u0016\u001c6.\u001a;dQ^KG\u000f\u001b(vY2\u001cu.\u001e8u)\t1e\u000eC\u0003p\u001d\u0001\u0007Q&\u0001\rpi\",'oU6fi\u000eDw+\u001b;i\u001dVdGnQ8v]R\f\u0011b]3sS\u0006d\u0017N_3\u0015\u0003I\u00042aJ:v\u0013\t!\bFA\u0003BeJ\f\u0017\u0010\u0005\u0002(m&\u0011q\u000f\u000b\u0002\u0005\u0005f$X-A\bD_6\u0014\u0017N\\3J]R,'O\\1m!\tq\u0013c\u0005\u0002\u0012MQ\t\u00110A\u0006eKN,'/[1mSj,GC\u0001@\u0000!\rq\u0003!\u000f\u0005\u0007\u0003\u0003\u0019\u0002\u0019\u0001:\u0002\r\t,hMZ3s\u0001")
public class CombineInternal<T> {
    private final ApproxTopKAggregateBuffer<T> sketchWithNullCount;
    private DataType itemDataType;
    private int maxItemsTracked;

    public static CombineInternal<Object> deserialize(byte[] buffer) {
        return CombineInternal$.MODULE$.deserialize(buffer);
    }

    public DataType itemDataType() {
        return this.itemDataType;
    }

    public void itemDataType_$eq(DataType x$1) {
        this.itemDataType = x$1;
    }

    public int maxItemsTracked() {
        return this.maxItemsTracked;
    }

    public void maxItemsTracked_$eq(int x$1) {
        this.maxItemsTracked = x$1;
    }

    public ApproxTopKAggregateBuffer<T> getSketchWithNullCount() {
        return this.sketchWithNullCount;
    }

    public DataType getItemDataType() {
        return this.itemDataType();
    }

    public int getMaxItemsTracked() {
        return this.maxItemsTracked();
    }

    public void updateMaxItemsTracked(boolean combineSizeSpecified, int newMaxItemsTracked) {
        if (!combineSizeSpecified) {
            if (this.maxItemsTracked() == ApproxTopK$.MODULE$.VOID_MAX_ITEMS_TRACKED()) {
                this.maxItemsTracked_$eq(newMaxItemsTracked);
                return;
            }
            if (this.maxItemsTracked() != newMaxItemsTracked) {
                throw QueryExecutionErrors$.MODULE$.approxTopKSketchSizeNotMatch(this.maxItemsTracked(), newMaxItemsTracked);
            }
            return;
        }
    }

    public void updateItemDataType(DataType inputItemDataType) {
        if (this.itemDataType() == null) {
            this.itemDataType_$eq(inputItemDataType);
            return;
        }
        if (inputItemDataType != null) {
            DataType dataType = this.itemDataType();
            DataType dataType2 = inputItemDataType;
            if (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) {
                throw QueryExecutionErrors$.MODULE$.approxTopKSketchTypeNotMatch(this.itemDataType(), inputItemDataType);
            }
        }
    }

    public void updateSketchWithNullCount(ApproxTopKAggregateBuffer<T> otherSketchWithNullCount) {
        this.sketchWithNullCount.merge(otherSketchWithNullCount);
    }

    public byte[] serialize() {
        byte[] sketchWithNullCountBytes = this.sketchWithNullCount.serialize(ApproxTopK$.MODULE$.genSketchSerDe(this.itemDataType()));
        String itemDataTypeDDL = ApproxTopK$.MODULE$.dataTypeToDDL(this.itemDataType());
        byte[] ddlBytes = itemDataTypeDDL.getBytes(StandardCharsets.UTF_8);
        byte[] byteArray = new byte[sketchWithNullCountBytes.length + 4 + 4 + ddlBytes.length];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteArray);
        byteBuffer.putInt(this.maxItemsTracked());
        byteBuffer.putInt(ddlBytes.length);
        byteBuffer.put(ddlBytes);
        byteBuffer.put(sketchWithNullCountBytes);
        return byteArray;
    }

    public CombineInternal(ApproxTopKAggregateBuffer<T> sketchWithNullCount, DataType itemDataType, int maxItemsTracked) {
        this.sketchWithNullCount = sketchWithNullCount;
        this.itemDataType = itemDataType;
        this.maxItemsTracked = maxItemsTracked;
    }
}

