/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import scala.collection.SortedSet;
import scala.collection.SortedSet$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.runtime.ScalaRunTime$;

public final class CharsetProvider$ {
    public static final CharsetProvider$ MODULE$ = new CharsetProvider$();
    private static SortedSet<String> VALID_CHARSETS;
    private static volatile boolean bitmap$0;

    private SortedSet<String> VALID_CHARSETS$lzycompute() {
        CharsetProvider$ charsetProvider$ = this;
        synchronized (charsetProvider$) {
            if (!bitmap$0) {
                VALID_CHARSETS = (SortedSet)SortedSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"us-ascii", "iso-8859-1", "utf-8", "utf-16be", "utf-16le", "utf-16", "utf-32"}), (Object)Ordering.String$.MODULE$);
                bitmap$0 = true;
            }
        }
        return VALID_CHARSETS;
    }

    public final SortedSet<String> VALID_CHARSETS() {
        if (!bitmap$0) {
            return this.VALID_CHARSETS$lzycompute();
        }
        return VALID_CHARSETS;
    }

    public Charset forName(String charset, boolean legacyCharsets, String caller) {
        String lowercasedCharset = charset.toLowerCase(Locale.ROOT);
        if (legacyCharsets || this.VALID_CHARSETS().contains((Object)lowercasedCharset)) {
            Charset charset2;
            try {
                charset2 = Charset.forName(lowercasedCharset);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IllegalCharsetNameException ? true : (throwable2 instanceof UnsupportedCharsetException ? true : throwable2 instanceof IllegalArgumentException)) {
                    throw QueryExecutionErrors$.MODULE$.invalidCharsetError(caller, charset);
                }
                throw throwable;
            }
            return charset2;
        }
        throw QueryExecutionErrors$.MODULE$.invalidCharsetError(caller, charset);
    }

    public boolean forName$default$2() {
        return SQLConf$.MODULE$.get().legacyJavaCharsets();
    }

    public String forName$default$3() {
        return "";
    }

    public CharsetEncoder newEncoder(String charset, boolean legacyCharsets, boolean legacyErrorAction, String caller) {
        CodingErrorAction codingErrorAction = legacyErrorAction ? CodingErrorAction.REPLACE : CodingErrorAction.REPORT;
        return this.forName(charset, legacyCharsets, caller).newEncoder().onMalformedInput(codingErrorAction).onUnmappableCharacter(codingErrorAction);
    }

    public String newEncoder$default$4() {
        return "encode";
    }

    public CharsetDecoder newDecoder(String charset, boolean legacyCharsets, boolean legacyErrorAction, String caller) {
        CodingErrorAction codingErrorAction = legacyErrorAction ? CodingErrorAction.REPLACE : CodingErrorAction.REPORT;
        return this.forName(charset, legacyCharsets, caller).newDecoder().onMalformedInput(codingErrorAction).onUnmappableCharacter(codingErrorAction);
    }

    public boolean newDecoder$default$2() {
        return SQLConf$.MODULE$.get().legacyJavaCharsets();
    }

    public boolean newDecoder$default$3() {
        return SQLConf$.MODULE$.get().legacyCodingErrorAction();
    }

    public String newDecoder$default$4() {
        return "decode";
    }

    private CharsetProvider$() {
    }
}

