/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.read.streaming;

import java.io.IOException;
import java.util.Optional;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.streaming.PartitionOffset;

@Evolving
public interface SupportsRealTimeRead<T>
extends PartitionReader<T> {
    public PartitionOffset getOffset();

    public RecordStatus nextWithTimeout(Long var1) throws IOException;

    public static class RecordStatus {
        private final boolean hasRecord;
        private final Optional<Long> recArrivalTime;

        private RecordStatus(boolean hasRecord, Optional<Long> recArrivalTime) {
            this.hasRecord = hasRecord;
            this.recArrivalTime = recArrivalTime;
        }

        public static RecordStatus newStatusWithoutArrivalTime(boolean hasRecord) {
            return new RecordStatus(hasRecord, Optional.empty());
        }

        public static RecordStatus newStatusWithArrivalTimeMs(Long recArrivalTime) {
            return new RecordStatus(true, Optional.of(recArrivalTime));
        }

        public boolean hasRecord() {
            return this.hasRecord;
        }

        public Optional<Long> recArrivalTime() {
            return this.recArrivalTime;
        }
    }
}

