/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.config.Kryo$;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.Word2VecBase;
import org.apache.spark.ml.feature.Word2VecModel$;
import org.apache.spark.ml.feature.Word2VecModel$Word2VecModelReader$;
import org.apache.spark.ml.feature.Word2VecModel$Word2VecModelWriter$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.ReadWriteUtils$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.VersionUtils$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0005\rme\u0001B!C\u00015C\u0001\"\u0018\u0001\u0003\u0006\u0004%\tE\u0018\u0005\tk\u0002\u0011\t\u0011)A\u0005?\"Aq\u000f\u0001BC\u0002\u0013%\u0001\u0010\u0003\u0005\u0000\u0001\t\u0005\t\u0015!\u0003z\u0011!\tY\u0001\u0001C\u0001\t\u00065\u0001\u0002CA\u0006\u0001\u0011\u0005A)!\u0006\t\u0015\u0005]\u0001\u0001#b\u0001\n\u0003\tI\u0002C\u0004\u0002F\u0001!\t!a\u0012\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002Z!9\u00111\u000f\u0001\u0005\u0002\u0005U\u0004bBA:\u0001\u0011\u0005\u00111\u0013\u0005\b\u00037\u0003A\u0011AAO\u0011\u001d\t9\u000b\u0001C\u0001\u0003SCq!a,\u0001\t\u0003\n\t\fC\u0004\u0002Z\u0002!\t%a7\t\u000f\u0005=\b\u0001\"\u0011\u0002r\"9!\u0011\u0002\u0001\u0005B\t-\u0001b\u0002B\r\u0001\u0011\u0005#1D\u0004\b\u0005K\u0011\u0005\u0012\u0001B\u0014\r\u0019\t%\t#\u0001\u0003*!9\u00111\u0002\u000b\u0005\u0002\t\u001dca\u0002B%)\u0001#\"1\n\u0005\n\u0003\u00172\"Q3A\u0005\u0002yC\u0011B!\u0019\u0017\u0005#\u0005\u000b\u0011B0\t\u0015\t\rdC!f\u0001\n\u0003\u0011)\u0007\u0003\u0006\u0003pY\u0011\t\u0012)A\u0005\u0005OBq!a\u0003\u0017\t\u0003\u0011\t\bC\u0005\u0002pZ\t\t\u0011\"\u0001\u0003|!I!\u0011\u0011\f\u0012\u0002\u0013\u0005!1\u0011\u0005\n\u0005/3\u0012\u0013!C\u0001\u00053C\u0011B!(\u0017\u0003\u0003%\tEa(\t\u0013\t-f#!A\u0005\u0002\t5\u0006\"\u0003BX-\u0005\u0005I\u0011\u0001BY\u0011%\u00119LFA\u0001\n\u0003\u0012I\fC\u0005\u0003HZ\t\t\u0011\"\u0001\u0003J\"I!1\u001b\f\u0002\u0002\u0013\u0005#Q\u001b\u0005\n\u000534\u0012\u0011!C!\u00057D\u0011B!\u0007\u0017\u0003\u0003%\tE!8\t\u0013\t}g#!A\u0005B\t\u0005xA\u0003Bs)\u0005\u0005\t\u0012\u0001\u000b\u0003h\u001aQ!\u0011\n\u000b\u0002\u0002#\u0005AC!;\t\u000f\u0005-\u0011\u0006\"\u0001\u0003x\"I!\u0011D\u0015\u0002\u0002\u0013\u0015#Q\u001c\u0005\n\u0005sL\u0013\u0011!CA\u0005wD\u0011b!\u0001*\u0003\u0003%\tia\u0001\t\u0013\rE\u0011&!A\u0005\n\rM\u0001\u0002CB\u000e)\u0011\u0005Ai!\b\t\u0011\rMB\u0003\"\u0001E\u0007k1qa!\u0011\u0015\u0001Q\u0019\u0019\u0005C\u0005\u0004FE\u0012\t\u0011)A\u0005%\"9\u00111B\u0019\u0005\u0002\r\u001d\u0003bBB'c\u0011E3qJ\u0004\t\u0007+\"\u0002\u0012\u0001\"\u0004X\u0019A1\u0011\t\u000b\t\u0002\t\u001bI\u0006C\u0004\u0002\fY\"\taa\u0017\t\u000f\ruc\u0007\"\u0001\u0004`\u0019111\u000f\u000b\u0005\u0007kBq!a\u0003:\t\u0003\u0019i\bC\u0005\u0004\u0002f\u0012\r\u0011\"\u0003\u0003 \"A11Q\u001d!\u0002\u0013\u0011\t\u000bC\u0004\u0004\u0006f\"\tea\"\t\u000f\r-E\u0003\"\u0011\u0004\u000e\"91Q\u0011\u000b\u0005B\rE\u0005\"CB\t)\u0005\u0005I\u0011BB\n\u000559vN\u001d33-\u0016\u001cWj\u001c3fY*\u00111\tR\u0001\bM\u0016\fG/\u001e:f\u0015\t)e)\u0001\u0002nY*\u0011q\tS\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013*\u000ba!\u00199bG\",'\"A&\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qEk\u0016\t\u0004\u001fB\u0013V\"\u0001#\n\u0005E#%!B'pI\u0016d\u0007CA*\u0001\u001b\u0005\u0011\u0005CA*V\u0013\t1&I\u0001\u0007X_J$'GV3d\u0005\u0006\u001cX\r\u0005\u0002Y76\t\u0011L\u0003\u0002[\t\u0006!Q\u000f^5m\u0013\ta\u0016L\u0001\u0006N\u0019^\u0013\u0018\u000e^1cY\u0016\f1!^5e+\u0005y\u0006C\u00011j\u001d\t\tw\r\u0005\u0002cK6\t1M\u0003\u0002e\u0019\u00061AH]8pizR\u0011AZ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0016\fa\u0001\u0015:fI\u00164\u0017B\u00016l\u0005\u0019\u0019FO]5oO*\u0011\u0001.\u001a\u0015\u0004\u00035\u001c\bC\u00018r\u001b\u0005y'B\u00019G\u0003)\tgN\\8uCRLwN\\\u0005\u0003e>\u0014QaU5oG\u0016\f\u0013\u0001^\u0001\u0006c9\"d\u0006M\u0001\u0005k&$\u0007\u0005K\u0002\u0003[N\f1b^8sIZ+7\r^8sgV\t\u0011\u0010\u0005\u0002{}6\t1P\u0003\u0002Dy*\u0011QPR\u0001\u0006[2d\u0017NY\u0005\u0003\u0003n\fAb^8sIZ+7\r^8sg\u0002B3\u0001BA\u0002!\u0011\t)!a\u0002\u000e\u0003\u0015L1!!\u0003f\u0005%!(/\u00198tS\u0016tG/\u0001\u0004=S:LGO\u0010\u000b\u0006%\u0006=\u00111\u0003\u0005\u0006;\u0016\u0001\ra\u0018\u0015\u0005\u0003\u001fi7\u000fC\u0003x\u000b\u0001\u0007\u0011\u0010F\u0001S\u0003)9W\r\u001e,fGR|'o]\u000b\u0003\u00037\u0001B!!\b\u000289!\u0011qDA\u0019\u001d\u0011\t\t#!\f\u000f\t\u0005\r\u00121\u0006\b\u0005\u0003K\tICD\u0002c\u0003OI\u0011aS\u0005\u0003\u0013*K!a\u0012%\n\u0007\u0005=b)A\u0002tc2LA!a\r\u00026\u00059\u0001/Y2lC\u001e,'bAA\u0018\r&!\u0011\u0011HA\u001e\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0003\u00024\u0005U\u0002\u0006B\u0004n\u0003\u007f\t#!!\u0011\u0002\u000bErSG\f\u0019)\u0007\u001d\t\u0019!\u0001\u0007gS:$7+\u001f8p]fl7\u000f\u0006\u0004\u0002\u001c\u0005%\u0013Q\n\u0005\u0007\u0003\u0017B\u0001\u0019A0\u0002\t]|'\u000f\u001a\u0005\b\u0003\u001fB\u0001\u0019AA)\u0003\rqW/\u001c\t\u0005\u0003\u000b\t\u0019&C\u0002\u0002V\u0015\u00141!\u00138uQ\u0011AQ.a\u0010\u0015\r\u0005m\u00111LA6\u0011\u001d\ti&\u0003a\u0001\u0003?\n1A^3d!\u0011\t\t'a\u001a\u000e\u0005\u0005\r$bAA3\t\u00061A.\u001b8bY\u001eLA!!\u001b\u0002d\t1a+Z2u_JDq!a\u0014\n\u0001\u0004\t\t\u0006\u000b\u0003\n[\u0006=\u0014EAA9\u0003\u0015\u0011d\u0006\r\u00181\u0003E1\u0017N\u001c3Ts:|g._7t\u0003J\u0014\u0018-\u001f\u000b\u0007\u0003o\nI)a#\u0011\r\u0005\u0015\u0011\u0011PA?\u0013\r\tY(\u001a\u0002\u0006\u0003J\u0014\u0018-\u001f\t\b\u0003\u000b\tyhXAB\u0013\r\t\t)\u001a\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005\u0015\u0011QQ\u0005\u0004\u0003\u000f+'A\u0002#pk\ndW\rC\u0004\u0002^)\u0001\r!a\u0018\t\u000f\u0005=#\u00021\u0001\u0002R!\"!\"\\AHC\t\t\t*A\u00033]Ir\u0003\u0007\u0006\u0004\u0002x\u0005U\u0015q\u0013\u0005\u0007\u0003\u0017Z\u0001\u0019A0\t\u000f\u0005=3\u00021\u0001\u0002R!\"1\"\\AH\u0003-\u0019X\r^%oaV$8i\u001c7\u0015\t\u0005}\u0015\u0011U\u0007\u0002\u0001!1\u00111\u0015\u0007A\u0002}\u000bQA^1mk\u0016D3\u0001D7t\u00031\u0019X\r^(viB,HoQ8m)\u0011\ty*a+\t\r\u0005\rV\u00021\u0001`Q\riQn]\u0001\niJ\fgn\u001d4pe6$B!a\u0007\u00024\"9\u0011Q\u0017\bA\u0002\u0005]\u0016a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003s\u000b)\r\u0005\u0004\u0002<\u0006u\u0016\u0011Y\u0007\u0003\u0003kIA!a0\u00026\t9A)\u0019;bg\u0016$\b\u0003BAb\u0003\u000bd\u0001\u0001\u0002\u0007\u0002H\u0006M\u0016\u0011!A\u0001\u0006\u0003\tIMA\u0002`II\nB!a3\u0002RB!\u0011QAAg\u0013\r\ty-\u001a\u0002\b\u001d>$\b.\u001b8h!\u0011\t)!a5\n\u0007\u0005UWMA\u0002B]fDCAD7\u0002p\u0005yAO]1og\u001a|'/\\*dQ\u0016l\u0017\r\u0006\u0003\u0002^\u0006%\b\u0003BAp\u0003Kl!!!9\u000b\t\u0005\r\u0018QG\u0001\u0006if\u0004Xm]\u0005\u0005\u0003O\f\tO\u0001\u0006TiJ,8\r\u001e+za\u0016Dq!a;\u0010\u0001\u0004\ti.\u0001\u0004tG\",W.\u0019\u0015\u0004\u001f5\u001c\u0018\u0001B2paf$2AUAz\u0011\u001d\t)\u0010\u0005a\u0001\u0003o\fQ!\u001a=ue\u0006\u0004B!!?\u0002\u00006\u0011\u00111 \u0006\u0004\u0003{$\u0015!\u00029be\u0006l\u0017\u0002\u0002B\u0001\u0003w\u0014\u0001\u0002U1sC6l\u0015\r\u001d\u0015\u0005!5\u0014)!\t\u0002\u0003\b\u0005)\u0011G\f\u001b/c\u0005)qO]5uKV\u0011!Q\u0002\t\u00041\n=\u0011b\u0001B\t3\nAQ\nT,sSR,'\u000f\u000b\u0003\u0012[\nU\u0011E\u0001B\f\u0003\u0015\tdF\u000e\u00181\u0003!!xn\u0015;sS:<G#A0)\tIi'qD\u0011\u0003\u0005C\tQa\r\u00181]AB3\u0001A7t\u000359vN\u001d33-\u0016\u001cWj\u001c3fYB\u00111\u000bF\n\b)\t-\"\u0011\u0007B\u001c!\u0011\t)A!\f\n\u0007\t=RM\u0001\u0004B]f\u0014VM\u001a\t\u00051\nM\"+C\u0002\u00036e\u0013!\"\u0014'SK\u0006$\u0017M\u00197f!\u0011\u0011IDa\u0011\u000e\u0005\tm\"\u0002\u0002B\u001f\u0005\u007f\t!![8\u000b\u0005\t\u0005\u0013\u0001\u00026bm\u0006LAA!\u0012\u0003<\ta1+\u001a:jC2L'0\u00192mKR\u0011!q\u0005\u0002\u0005\t\u0006$\u0018mE\u0004\u0017\u0005W\u0011iEa\u0015\u0011\t\u0005\u0015!qJ\u0005\u0004\u0005#*'a\u0002)s_\u0012,8\r\u001e\t\u0005\u0005+\u0012iF\u0004\u0003\u0003X\tmcb\u00012\u0003Z%\ta-C\u0002\u00024\u0015LAA!\u0012\u0003`)\u0019\u00111G3\u0002\u000b]|'\u000f\u001a\u0011\u0002\rY,7\r^8s+\t\u00119\u0007\u0005\u0004\u0002\u0006\u0005e$\u0011\u000e\t\u0005\u0003\u000b\u0011Y'C\u0002\u0003n\u0015\u0014QA\u00127pCR\fqA^3di>\u0014\b\u0005\u0006\u0004\u0003t\t]$\u0011\u0010\t\u0004\u0005k2R\"\u0001\u000b\t\r\u0005-3\u00041\u0001`\u0011\u001d\u0011\u0019g\u0007a\u0001\u0005O\"bAa\u001d\u0003~\t}\u0004\u0002CA&9A\u0005\t\u0019A0\t\u0013\t\rD\u0004%AA\u0002\t\u001d\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005\u000bS3a\u0018BDW\t\u0011I\t\u0005\u0003\u0003\f\nMUB\u0001BG\u0015\u0011\u0011yI!%\u0002\u0013Ut7\r[3dW\u0016$'B\u00019f\u0013\u0011\u0011)J!$\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tm%\u0006\u0002B4\u0005\u000f\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001BQ!\u0011\u0011\u0019K!+\u000e\u0005\t\u0015&\u0002\u0002BT\u0005\u007f\tA\u0001\\1oO&\u0019!N!*\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005E\u0013A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003#\u0014\u0019\fC\u0005\u00036\u0006\n\t\u00111\u0001\u0002R\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa/\u0011\r\tu&1YAi\u001b\t\u0011yLC\u0002\u0003B\u0016\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011)Ma0\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005\u0017\u0014\t\u000e\u0005\u0003\u0002\u0006\t5\u0017b\u0001BhK\n9!i\\8mK\u0006t\u0007\"\u0003B[G\u0005\u0005\t\u0019AAi\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\t\u0005&q\u001b\u0005\n\u0005k#\u0013\u0011!a\u0001\u0003#\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003#\"\"A!)\u0002\r\u0015\fX/\u00197t)\u0011\u0011YMa9\t\u0013\tUv%!AA\u0002\u0005E\u0017\u0001\u0002#bi\u0006\u00042A!\u001e*'\u0015I#1\u001eB\u001c!%\u0011iOa=`\u0005O\u0012\u0019(\u0004\u0002\u0003p*\u0019!\u0011_3\u0002\u000fI,h\u000e^5nK&!!Q\u001fBx\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0005O\fQ!\u00199qYf$bAa\u001d\u0003~\n}\bBBA&Y\u0001\u0007q\fC\u0004\u0003d1\u0002\rAa\u001a\u0002\u000fUt\u0017\r\u001d9msR!1QAB\u0007!\u0019\t)aa\u0002\u0004\f%\u00191\u0011B3\u0003\r=\u0003H/[8o!\u001d\t)!a `\u0005OB\u0011ba\u0004.\u0003\u0003\u0005\rAa\u001d\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0004\u0016A!!1UB\f\u0013\u0011\u0019IB!*\u0003\r=\u0013'.Z2u\u00035\u0019XM]5bY&TX\rR1uCR11qDB\u0013\u0007S\u0001B!!\u0002\u0004\"%\u001911E3\u0003\tUs\u0017\u000e\u001e\u0005\b\u0007Oy\u0003\u0019\u0001B:\u0003\u0011!\u0017\r^1\t\u000f\r-r\u00061\u0001\u0004.\u0005\u0019Am\\:\u0011\t\te2qF\u0005\u0005\u0007c\u0011YD\u0001\tECR\fw*\u001e;qkR\u001cFO]3b[\u0006yA-Z:fe&\fG.\u001b>f\t\u0006$\u0018\r\u0006\u0003\u0003t\r]\u0002bBB\u001da\u0001\u000711H\u0001\u0004I&\u001c\b\u0003\u0002B\u001d\u0007{IAaa\u0010\u0003<\tyA)\u0019;b\u0013:\u0004X\u000f^*ue\u0016\fWNA\nX_J$'GV3d\u001b>$W\r\\,sSR,'oE\u00022\u0005\u001b\t\u0001\"\u001b8ti\u0006t7-\u001a\u000b\u0005\u0007\u0013\u001aY\u0005E\u0002\u0003vEBaa!\u00124\u0001\u0004\u0011\u0016\u0001C:bm\u0016LU\u000e\u001d7\u0015\t\r}1\u0011\u000b\u0005\u0007\u0007'\"\u0004\u0019A0\u0002\tA\fG\u000f[\u0001\u0014/>\u0014HM\r,fG6{G-\u001a7Xe&$XM\u001d\t\u0004\u0005k24c\u0001\u001c\u0003,Q\u00111qK\u0001\u001cG\u0006d7-\u001e7bi\u0016tU/\u001c2fe>3\u0007+\u0019:uSRLwN\\:\u0015\u0011\u0005E3\u0011MB6\u0007_Bqaa\u00199\u0001\u0004\u0019)'A\tck\u001a4WM]*ju\u0016LeNQ=uKN\u0004B!!\u0002\u0004h%\u00191\u0011N3\u0003\t1{gn\u001a\u0005\b\u0007[B\u0004\u0019AA)\u0003!qW/\\,pe\u0012\u001c\bbBB9q\u0001\u0007\u0011\u0011K\u0001\u000bm\u0016\u001cGo\u001c:TSj,'aE,pe\u0012\u0014d+Z2N_\u0012,GNU3bI\u0016\u00148cA\u001d\u0004xA!\u0001l!\u001fS\u0013\r\u0019Y(\u0017\u0002\t\u001b2\u0013V-\u00193feR\u00111q\u0010\t\u0004\u0005kJ\u0014!C2mCN\u001ch*Y7f\u0003)\u0019G.Y:t\u001d\u0006lW\rI\u0001\u0005Y>\fG\rF\u0002S\u0007\u0013Caaa\u0015>\u0001\u0004y\u0016\u0001\u0002:fC\u0012,\"aa\u001e)\tyj'Q\u0003\u000b\u0004%\u000eM\u0005BBB*\u007f\u0001\u0007q\f\u000b\u0003@[\nU\u0001\u0006\u0002\u000bn\u0005+ACaE7\u0003\u0016\u0001")
public class Word2VecModel
extends Model<Word2VecModel>
implements Word2VecBase,
MLWritable {
    private transient Dataset<Row> getVectors;
    private final String uid;
    private final transient org.apache.spark.mllib.feature.Word2VecModel org$apache$spark$ml$feature$Word2VecModel$$wordVectors;
    private IntParam vectorSize;
    private IntParam windowSize;
    private IntParam numPartitions;
    private IntParam minCount;
    private IntParam maxSentenceLength;
    private LongParam seed;
    private DoubleParam stepSize;
    private IntParam maxIter;
    private Param<String> outputCol;
    private Param<String> inputCol;
    private volatile transient boolean bitmap$trans$0;

    public static Word2VecModel load(String path) {
        return Word2VecModel$.MODULE$.load(path);
    }

    public static MLReader<Word2VecModel> read() {
        return Word2VecModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getVectorSize() {
        return Word2VecBase.getVectorSize$(this);
    }

    @Override
    public int getWindowSize() {
        return Word2VecBase.getWindowSize$(this);
    }

    @Override
    public int getNumPartitions() {
        return Word2VecBase.getNumPartitions$(this);
    }

    @Override
    public int getMinCount() {
        return Word2VecBase.getMinCount$(this);
    }

    @Override
    public int getMaxSentenceLength() {
        return Word2VecBase.getMaxSentenceLength$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return Word2VecBase.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol.getOutputCol$(this);
    }

    @Override
    public final String getInputCol() {
        return HasInputCol.getInputCol$(this);
    }

    @Override
    public final IntParam vectorSize() {
        return this.vectorSize;
    }

    @Override
    public final IntParam windowSize() {
        return this.windowSize;
    }

    @Override
    public final IntParam numPartitions() {
        return this.numPartitions;
    }

    @Override
    public final IntParam minCount() {
        return this.minCount;
    }

    @Override
    public final IntParam maxSentenceLength() {
        return this.maxSentenceLength;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$vectorSize_$eq(IntParam x$1) {
        this.vectorSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$windowSize_$eq(IntParam x$1) {
        this.windowSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$numPartitions_$eq(IntParam x$1) {
        this.numPartitions = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$minCount_$eq(IntParam x$1) {
        this.minCount = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$maxSentenceLength_$eq(IntParam x$1) {
        this.maxSentenceLength = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param<String> x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param<String> x$1) {
        this.inputCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public org.apache.spark.mllib.feature.Word2VecModel org$apache$spark$ml$feature$Word2VecModel$$wordVectors() {
        return this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors;
    }

    private Dataset<Row> getVectors$lzycompute() {
        Word2VecModel word2VecModel = this;
        synchronized (word2VecModel) {
            if (!this.bitmap$trans$0) {
                SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
                Map wordVec = (Map)this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().getVectors().transform((Function2 & Serializable)(x$2, vec) -> Vectors$.MODULE$.dense((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.floatArrayOps(vec), (Function1)(JFunction1.mcDF.sp & Serializable)x$3 -> x$3, (ClassTag)ClassTag$.MODULE$.Double())));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
                public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$1(Word2VecModel $outer) {
                    }
                }
                this.getVectors = spark.createDataFrame(wordVec.toSeq(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$1(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"word", "vector"}));
                this.bitmap$trans$0 = true;
            }
        }
        return this.getVectors;
    }

    public Dataset<Row> getVectors() {
        if (!this.bitmap$trans$0) {
            return this.getVectors$lzycompute();
        }
        return this.getVectors;
    }

    public Dataset<Row> findSynonyms(String word, int num) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$2(Word2VecModel $outer) {
            }
        }
        return spark.createDataFrame((Seq)ArrayImplicits$.MODULE$.SparkArrayOps(this.findSynonymsArray(word, num)).toImmutableArraySeq(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$2(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"word", "similarity"}));
    }

    public Dataset<Row> findSynonyms(Vector vec, int num) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$3(Word2VecModel $outer) {
            }
        }
        return spark.createDataFrame((Seq)ArrayImplicits$.MODULE$.SparkArrayOps(this.findSynonymsArray(vec, num)).toImmutableArraySeq(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$3(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"word", "similarity"}));
    }

    public Tuple2<String, Object>[] findSynonymsArray(Vector vec, int num) {
        return this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().findSynonyms(vec.toArray(), num, (Option<String>)None$.MODULE$);
    }

    public Tuple2<String, Object>[] findSynonymsArray(String word, int num) {
        return this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().findSynonyms(word, num);
    }

    public Word2VecModel setInputCol(String value) {
        return (Word2VecModel)this.set(this.inputCol(), value);
    }

    public Word2VecModel setOutputCol(String value) {
        return (Word2VecModel)this.set(this.outputCol(), value);
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1(Word2VecModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$4(Word2VecModel $outer) {
            }
        }
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Broadcast bcModel = dataset.sparkSession().sparkContext().broadcast((Object)this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors(), ClassTag$.MODULE$.apply(org.apache.spark.mllib.feature.Word2VecModel.class));
        int size = BoxesRunTime.unboxToInt((Object)this.$(this.vectorSize()));
        Vector emptyVec = Vectors$.MODULE$.sparse(size, Array$.MODULE$.emptyIntArray(), Array$.MODULE$.emptyDoubleArray());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        UserDefinedFunction transformer = functions$.MODULE$.udf((Function1 & Serializable)sentence -> {
            if (sentence.isEmpty()) {
                return emptyVec;
            }
            Map<String, Object> wordIndices = ((org.apache.spark.mllib.feature.Word2VecModel)bcModel.value()).wordIndex();
            float[] wordVectors = ((org.apache.spark.mllib.feature.Word2VecModel)bcModel.value()).wordVectors();
            double[] array = (double[])Array$.MODULE$.ofDim(size, (ClassTag)ClassTag$.MODULE$.Double());
            IntRef count = IntRef.create((int)0);
            sentence.foreach((Function1 & Serializable)word -> {
                Word2VecModel.$anonfun$transform$2(wordIndices, size, array, wordVectors, count, word);
                return BoxedUnit.UNIT;
            });
            Vector vec = Vectors$.MODULE$.dense(array);
            BLAS$.MODULE$.scal(1.0 / (double)count.elem, vec);
            return vec;
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$4(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1(null)));
        return dataset.withColumn(this.$(this.outputCol()), transformer.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.inputCol()))})), outputSchema.apply(this.$(this.outputCol())).metadata());
    }

    @Override
    public StructType transformSchema(StructType schema) {
        StructType outputSchema;
        block0: {
            outputSchema = this.validateAndTransformSchema(schema);
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.outputCol())))) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateAttributeGroupSize(outputSchema, this.$(this.outputCol()), BoxesRunTime.unboxToInt((Object)this.$(this.vectorSize())));
        }
        return outputSchema;
    }

    @Override
    public Word2VecModel copy(ParamMap extra) {
        Word2VecModel copied = new Word2VecModel(this.uid(), this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors());
        return (Word2VecModel)((Model)this.copyValues(copied, extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new Word2VecModelWriter(this);
    }

    @Override
    public String toString() {
        return "Word2VecModel: uid=" + this.uid() + ", numWords=" + this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().wordIndex().size() + ", vectorSize=" + this.$(this.vectorSize());
    }

    public static final /* synthetic */ void $anonfun$transform$2(Map wordIndices$1, int size$1, double[] array$1, float[] wordVectors$1, IntRef count$1, String word) {
        wordIndices$1.get((Object)word).foreach((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
            int offset = index * size$1;
            for (int i = 0; i < size$1; ++i) {
                int n = i;
                array$1[n] = array$1[n] + (double)wordVectors$1[offset + i];
            }
        });
        ++count$1.elem;
    }

    public Word2VecModel(String uid, org.apache.spark.mllib.feature.Word2VecModel wordVectors) {
        this.uid = uid;
        this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors = wordVectors;
        HasInputCol.$init$(this);
        HasOutputCol.$init$(this);
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasSeed.$init$(this);
        Word2VecBase.$init$(this);
        MLWritable.$init$(this);
        Statics.releaseFence();
    }

    public Word2VecModel() {
        this("", null);
    }

    public static class Data
    implements Product,
    Serializable {
        private final String word;
        private final float[] vector;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String word() {
            return this.word;
        }

        public float[] vector() {
            return this.vector;
        }

        public Data copy(String word, float[] vector) {
            return new Data(word, vector);
        }

        public String copy$default$1() {
            return this.word();
        }

        public float[] copy$default$2() {
            return this.vector();
        }

        public String productPrefix() {
            return "Data";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.word();
                }
                case 1: {
                    return this.vector();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Data;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "word";
                }
                case 1: {
                    return "vector";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 45109845, true);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Data)) return false;
            boolean bl = true;
            if (!bl) return false;
            Data data = (Data)x$1;
            String string = this.word();
            String string2 = data.word();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.vector() != data.vector()) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public Data(String word, float[] vector) {
            this.word = word;
            this.vector = vector;
            Product.$init$((Product)this);
        }
    }

    private static class Word2VecModelReader
    extends MLReader<Word2VecModel> {
        private final String className = Word2VecModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public Word2VecModel load(String path) {
            org.apache.spark.mllib.feature.Word2VecModel word2VecModel;
            SparkSession spark = this.sparkSession();
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sparkSession(), this.className());
            Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int major = tuple2._1$mcI$sp();
            int minor = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(major, minor);
            int major2 = sp2._1$mcI$sp();
            int minor2 = sp2._2$mcI$sp();
            String dataPath = new Path(path, "data").toString();
            if (major2 < 2 || major2 == 2 && minor2 < 2) {
                Row data = (Row)spark.read().parquet(dataPath).select("wordIndex", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"wordVectors"})).head();
                Map wordIndex = (Map)data.getAs(0);
                float[] wordVectors = (float[])((IterableOnceOps)data.getAs(1)).toArray((ClassTag)ClassTag$.MODULE$.Float());
                word2VecModel = new org.apache.spark.mllib.feature.Word2VecModel((Map<String, Object>)wordIndex, wordVectors);
            } else {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelReader$$typecreator1$6
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.feature.Word2VecModel.Data").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelReader$$typecreator1$6(Word2VecModelReader $outer) {
                    }
                }
                Data[] datum = (Data[])ReadWriteUtils$.MODULE$.loadArray(dataPath, this.sparkSession(), (Function1 & Serializable)dis -> Word2VecModel$.MODULE$.deserializeData((DataInputStream)dis), ClassTag$.MODULE$.apply(Data.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelReader$$typecreator1$6(null)));
                Map wordVectorsMap = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])datum), (Function1 & Serializable)wordVector -> new Tuple2((Object)wordVector.word(), (Object)wordVector.vector()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                word2VecModel = new org.apache.spark.mllib.feature.Word2VecModel((Map<String, float[]>)wordVectorsMap);
            }
            org.apache.spark.mllib.feature.Word2VecModel oldModel = word2VecModel;
            Word2VecModel model = new Word2VecModel(metadata.uid(), oldModel);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class Word2VecModelWriter
    extends MLWriter {
        private final Word2VecModel instance;

        @Override
        public void saveImpl(String path) {
            public final class Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator1$5
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.feature.Word2VecModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator1$5(Word2VecModelWriter $outer) {
                }
            }
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sparkSession());
            Map<String, float[]> wordVectors = this.instance.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().getVectors();
            String dataPath = new Path(path, "data").toString();
            long bufferSizeInBytes = Utils$.MODULE$.byteStringAsBytes(this.sc().conf().get(Kryo$.MODULE$.KRYO_SERIALIZER_MAX_BUFFER_SIZE().key(), "64m"));
            int numPartitions = Word2VecModel$Word2VecModelWriter$.MODULE$.calculateNumberOfPartitions(bufferSizeInBytes, this.instance.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().wordIndex().size(), this.instance.getVectorSize());
            Data[] datum = (Data[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])wordVectors.toArray(ClassTag$.MODULE$.apply(Tuple2.class))), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String word = (String)tuple2._1();
                    float[] vector = (float[])tuple2._2();
                    return new Data(word, vector);
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(Data.class));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModelWriter.class.getClassLoader());
            ReadWriteUtils$.MODULE$.saveArray(dataPath, datum, this.sparkSession(), (Function2 & Serializable)(data, dos) -> {
                Word2VecModel$.MODULE$.serializeData(data, dos);
                return BoxedUnit.UNIT;
            }, numPartitions, ClassTag$.MODULE$.apply(Data.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator1$5(null)));
        }

        public Word2VecModelWriter(Word2VecModel instance) {
            this.instance = instance;
        }
    }
}

