/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree;

import java.io.DataInputStream;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.param.Param$;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite$;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite$NodeData$;
import org.apache.spark.ml.tree.InternalNode;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.ReadWriteUtils$;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.util.VersionUtils$;
import org.json4s.DefaultFormats$;
import org.json4s.JValue;
import org.json4s.jackson.JsonMethods$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DecisionTreeModelReadWrite$ {
    public static final DecisionTreeModelReadWrite$ MODULE$ = new DecisionTreeModelReadWrite$();

    public Node loadTreeNodes(String path, DefaultParamsReader.Metadata metadata, SparkSession sparkSession) {
        DecisionTreeModelReadWrite.NodeData[] nodeDataArray;
        DefaultFormats$ format = DefaultFormats$.MODULE$;
        JValue impurityJson = metadata.getParamValue("impurity");
        String impurityType = (String)Param$.MODULE$.jsonDecode(JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(impurityJson, JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3())));
        String dataPath = new Path(path, "data").toString();
        Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int major = tuple2._1$mcI$sp();
        int major2 = major;
        if (major2 < 3) {
            Dataset df = sparkSession.read().parquet(dataPath);
            df = df.withColumn("rawCount", functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)-1L)));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_apache_spark_ml_tree_DecisionTreeModelReadWrite$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.tree.DecisionTreeModelReadWrite.NodeData").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_tree_DecisionTreeModelReadWrite$$typecreator5$1() {
                }
            }
            nodeDataArray = (DecisionTreeModelReadWrite.NodeData[])df.as(sparkSession.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_tree_DecisionTreeModelReadWrite$$typecreator5$1()))).collect();
        } else {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_apache_spark_ml_tree_DecisionTreeModelReadWrite$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.tree.DecisionTreeModelReadWrite.NodeData").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_tree_DecisionTreeModelReadWrite$$typecreator6$1() {
                }
            }
            nodeDataArray = (DecisionTreeModelReadWrite.NodeData[])ReadWriteUtils$.MODULE$.loadArray(dataPath, sparkSession, (Function1 & Serializable)dis -> DecisionTreeModelReadWrite$NodeData$.MODULE$.deserializeData((DataInputStream)dis), ClassTag$.MODULE$.apply(DecisionTreeModelReadWrite.NodeData.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_tree_DecisionTreeModelReadWrite$$typecreator6$1()));
        }
        DecisionTreeModelReadWrite.NodeData[] nodeDataArray2 = nodeDataArray;
        return this.buildTreeFromNodes(nodeDataArray2, impurityType);
    }

    public Node buildTreeFromNodes(DecisionTreeModelReadWrite.NodeData[] data, String impurityType) {
        DecisionTreeModelReadWrite.NodeData[] nodes = (DecisionTreeModelReadWrite.NodeData[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])data), (Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.id()), (Ordering)Ordering.Int$.MODULE$);
        Predef$.MODULE$.assert(((DecisionTreeModelReadWrite.NodeData)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])nodes))).id() == 0, (Function0 & Serializable)() -> "Decision Tree load failed.  Expected smallest node ID to be 0, but found " + ((DecisionTreeModelReadWrite.NodeData)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])nodes))).id());
        Predef$.MODULE$.assert(((DecisionTreeModelReadWrite.NodeData)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])nodes))).id() == nodes.length - 1, (Function0 & Serializable)() -> "Decision Tree load failed.  Expected largest node ID to be " + (nodes.length - 1) + ", but found " + ((DecisionTreeModelReadWrite.NodeData)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])nodes))).id());
        Node[] finalNodes = new Node[nodes.length];
        ArrayOps$.MODULE$.reverseIterator$extension(Predef$.MODULE$.refArrayOps((Object[])nodes)).foreach((Function1 & Serializable)x0$1 -> {
            DecisionTreeModelReadWrite$.$anonfun$buildTreeFromNodes$4(impurityType, finalNodes, x0$1);
            return BoxedUnit.UNIT;
        });
        return (Node)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])finalNodes));
    }

    public static final /* synthetic */ void $anonfun$buildTreeFromNodes$4(String impurityType$1, Node[] finalNodes$1, DecisionTreeModelReadWrite.NodeData x0$1) {
        DecisionTreeModelReadWrite.NodeData nodeData = x0$1;
        if (nodeData != null) {
            Node node;
            DecisionTreeModelReadWrite.NodeData nodeData2 = nodeData;
            ImpurityCalculator impurityStats = ImpurityCalculator$.MODULE$.getCalculator(impurityType$1, nodeData2.impurityStats(), nodeData2.rawCount());
            if (nodeData2.leftChild() != -1) {
                Node leftChild = finalNodes$1[nodeData2.leftChild()];
                Node rightChild = finalNodes$1[nodeData2.rightChild()];
                node = new InternalNode(nodeData2.prediction(), nodeData2.impurity(), nodeData2.gain(), leftChild, rightChild, nodeData2.split().getSplit(), impurityStats);
            } else {
                node = new LeafNode(nodeData2.prediction(), nodeData2.impurity(), impurityStats);
            }
            LeafNode node2 = node;
            finalNodes$1[nodeData2.id()] = node2;
            return;
        }
        throw new MatchError((Object)nodeData);
    }

    private DecisionTreeModelReadWrite$() {
    }
}

