/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import com.aayushatharva.brotli4j.Brotli4jLoader;
import com.aayushatharva.brotli4j.decoder.DecoderJNI;
import com.aayushatharva.brotli4j.encoder.Encoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.orc.CompressionCodec;
import org.apache.orc.CompressionKind;
import org.apache.orc.impl.DirectDecompressionCodec;
import org.apache.orc.impl.OrcCodecPool;

public class BrotliCodec
implements CompressionCodec,
DirectDecompressionCodec {
    private static final BrotliOptions DEFAULT_OPTIONS;

    @Override
    public CompressionCodec.Options getDefaultOptions() {
        return DEFAULT_OPTIONS;
    }

    @Override
    public boolean compress(ByteBuffer in, ByteBuffer out, ByteBuffer overflow, CompressionCodec.Options options) throws IOException {
        BrotliOptions brotliOptions = (BrotliOptions)options;
        int inBytes = in.remaining();
        byte[] compressed = Encoder.compress((byte[])in.array(), (int)(in.arrayOffset() + in.position()), (int)inBytes, (Encoder.Parameters)brotliOptions.brotli4jParameter());
        int outBytes = compressed.length;
        if (outBytes < inBytes) {
            int remaining = out.remaining();
            if (remaining >= outBytes) {
                System.arraycopy(compressed, 0, out.array(), out.arrayOffset() + out.position(), outBytes);
                out.position(out.position() + outBytes);
            } else {
                System.arraycopy(compressed, 0, out.array(), out.arrayOffset() + out.position(), remaining);
                out.position(out.limit());
                System.arraycopy(compressed, remaining, overflow.array(), overflow.arrayOffset(), outBytes - remaining);
                overflow.position(outBytes - remaining);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decompress(ByteBuffer in, ByteBuffer out) throws IOException {
        int compressedBytes = in.remaining();
        DecoderJNI.Wrapper decoder = new DecoderJNI.Wrapper(compressedBytes);
        try {
            decoder.getInputBuffer().put(in);
            decoder.push(compressedBytes);
            block8: while (decoder.getStatus() != DecoderJNI.Status.DONE) {
                switch (decoder.getStatus()) {
                    case OK: {
                        decoder.push(0);
                        continue block8;
                    }
                    case NEEDS_MORE_OUTPUT: {
                        ByteBuffer buffer = decoder.pull();
                        out.put(buffer);
                        continue block8;
                    }
                    case NEEDS_MORE_INPUT: {
                        decoder.push(0);
                        if (decoder.getStatus() != DecoderJNI.Status.NEEDS_MORE_INPUT) continue block8;
                        return;
                    }
                }
                return;
            }
        }
        finally {
            out.flip();
            decoder.destroy();
        }
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public CompressionKind getKind() {
        return CompressionKind.BROTLI;
    }

    @Override
    public void directDecompress(ByteBuffer in, ByteBuffer out) throws IOException {
        this.decompress(in, out);
    }

    @Override
    public void reset() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void close() {
        OrcCodecPool.returnCodec(CompressionKind.BROTLI, this);
    }

    static {
        Brotli4jLoader.ensureAvailability();
        DEFAULT_OPTIONS = new BrotliOptions();
    }

    static class BrotliOptions
    implements CompressionCodec.Options {
        private Encoder.Mode mode = Encoder.Mode.GENERIC;
        private int quality = -1;
        private int lgwin = -1;

        BrotliOptions() {
        }

        BrotliOptions(int quality, int lgwin, Encoder.Mode mode) {
            this.quality = quality;
            this.lgwin = lgwin;
            this.mode = mode;
        }

        @Override
        public CompressionCodec.Options copy() {
            return new BrotliOptions(this.quality, this.lgwin, this.mode);
        }

        @Override
        public CompressionCodec.Options setSpeed(CompressionCodec.SpeedModifier newValue) {
            switch (newValue) {
                case FAST: {
                    this.quality = 1;
                    break;
                }
                case DEFAULT: {
                    this.quality = -1;
                    break;
                }
                case FASTEST: {
                    this.quality = 0;
                    break;
                }
            }
            return this;
        }

        @Override
        public CompressionCodec.Options setData(CompressionCodec.DataKind newValue) {
            switch (newValue) {
                case BINARY: {
                    this.mode = Encoder.Mode.GENERIC;
                    break;
                }
                case TEXT: {
                    this.mode = Encoder.Mode.TEXT;
                    break;
                }
            }
            return this;
        }

        public Encoder.Parameters brotli4jParameter() {
            return new Encoder.Parameters().setQuality(this.quality).setWindow(this.lgwin).setMode(this.mode);
        }
    }
}

