/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.core.textstats;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.tika.eval.core.textstats.StringStatsCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnicodeBlockCounter
implements StringStatsCalculator<Map<String, MutableInt>> {
    private static final Logger LOG = LoggerFactory.getLogger(UnicodeBlockCounter.class);
    private final int maxContentLength;

    public UnicodeBlockCounter(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    @Override
    public Map<String, MutableInt> calculate(String txt) {
        if (txt.length() < 200) {
            return Collections.EMPTY_MAP;
        }
        String s = txt;
        if (s.length() > this.maxContentLength) {
            s = s.substring(0, this.maxContentLength);
        }
        HashMap<String, MutableInt> m = new HashMap<String, MutableInt>();
        StringReader r = new StringReader(s);
        try {
            int c = ((Reader)r).read();
            while (c != -1) {
                Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
                String blockString = block == null ? "NULL" : block.toString();
                MutableInt i = (MutableInt)m.get(blockString);
                if (i == null) {
                    i = new MutableInt(0);
                    m.put(blockString, i);
                }
                i.increment();
                if (block == null) {
                    blockString = "NULL";
                }
                m.put(blockString, i);
                c = ((Reader)r).read();
            }
        }
        catch (IOException e) {
            LOG.warn("IOException", e);
        }
        return m;
    }
}

