/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.entropy;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import jj2000.j2k.IntegerSpec;
import jj2000.j2k.ModuleSpec;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.util.ParameterList;

public class PrecinctSizeSpec
extends ModuleSpec {
    private static final String optName = "Cpp";
    private IntegerSpec dls;

    public PrecinctSizeSpec(int nt, int nc, byte type, IntegerSpec dls) {
        super(nt, nc, type);
        this.dls = dls;
    }

    public PrecinctSizeSpec(int nt, int nc, byte type, BlkImgDataSrc imgsrc, IntegerSpec dls, ParameterList pl) {
        super(nt, nc, type);
        this.dls = dls;
        boolean wasReadingPrecinctSize = false;
        String param = pl.getParameter(optName);
        Vector[] tmpv = new Vector[2];
        tmpv[0] = new Vector();
        tmpv[0].addElement(new Integer(65535));
        tmpv[1] = new Vector();
        tmpv[1].addElement(new Integer(65535));
        this.setDefault(tmpv);
        if (param == null) {
            return;
        }
        StringTokenizer stk = new StringTokenizer(param);
        int curSpecType = 0;
        boolean[] tileSpec = null;
        boolean[] compSpec = null;
        boolean endOfParamList = false;
        String word = null;
        String errMsg = null;
        block8: while ((stk.hasMoreTokens() || wasReadingPrecinctSize) && !endOfParamList) {
            int ci;
            int ti;
            Vector[] v;
            block36: {
                v = new Vector[2];
                if (!wasReadingPrecinctSize) {
                    word = stk.nextToken();
                }
                wasReadingPrecinctSize = false;
                switch (word.charAt(0)) {
                    case 't': {
                        tileSpec = PrecinctSizeSpec.parseIdx(word, this.nTiles);
                        if (curSpecType == 1) {
                            curSpecType = 3;
                            continue block8;
                        }
                        curSpecType = 2;
                        continue block8;
                    }
                    case 'c': {
                        compSpec = PrecinctSizeSpec.parseIdx(word, this.nComp);
                        if (curSpecType == 2) {
                            curSpecType = 3;
                            continue block8;
                        }
                        curSpecType = 1;
                        continue block8;
                    }
                }
                if (!Character.isDigit(word.charAt(0))) {
                    errMsg = "Bad construction for parameter: " + word;
                    throw new IllegalArgumentException(errMsg);
                }
                v[0] = new Vector();
                v[1] = new Vector();
                do {
                    Integer h;
                    Integer w;
                    try {
                        w = new Integer(word);
                        try {
                            word = stk.nextToken();
                        }
                        catch (NoSuchElementException e) {
                            errMsg = "'Cpp' option : could not parse the precinct's width";
                            throw new IllegalArgumentException(errMsg);
                        }
                        h = new Integer(word);
                        if (w != 1 << MathUtil.log2(w) || h != 1 << MathUtil.log2(h)) {
                            errMsg = "Precinct dimensions must be powers of 2";
                            throw new IllegalArgumentException(errMsg);
                        }
                    }
                    catch (NumberFormatException e) {
                        errMsg = "'Cpp' option : the argument '" + word + "' could not be parsed.";
                        throw new IllegalArgumentException(errMsg);
                    }
                    v[0].addElement(w);
                    v[1].addElement(h);
                    if (!stk.hasMoreTokens()) break block36;
                } while (Character.isDigit((word = stk.nextToken()).charAt(0)));
                wasReadingPrecinctSize = true;
                if (curSpecType == 0) {
                    this.setDefault(v);
                } else if (curSpecType == 2) {
                    for (ti = tileSpec.length - 1; ti >= 0; --ti) {
                        if (!tileSpec[ti]) continue;
                        this.setTileDef(ti, v);
                    }
                } else if (curSpecType == 1) {
                    for (ci = compSpec.length - 1; ci >= 0; --ci) {
                        if (!compSpec[ci]) continue;
                        this.setCompDef(ci, v);
                    }
                } else {
                    for (ti = tileSpec.length - 1; ti >= 0; --ti) {
                        for (ci = compSpec.length - 1; ci >= 0; --ci) {
                            if (!tileSpec[ti] || !compSpec[ci]) continue;
                            this.setTileCompVal(ti, ci, v);
                        }
                    }
                }
                curSpecType = 0;
                tileSpec = null;
                compSpec = null;
                continue;
            }
            if (curSpecType == 0) {
                this.setDefault(v);
            } else if (curSpecType == 2) {
                for (ti = tileSpec.length - 1; ti >= 0; --ti) {
                    if (!tileSpec[ti]) continue;
                    this.setTileDef(ti, v);
                }
            } else if (curSpecType == 1) {
                for (ci = compSpec.length - 1; ci >= 0; --ci) {
                    if (!compSpec[ci]) continue;
                    this.setCompDef(ci, v);
                }
            } else {
                for (ti = tileSpec.length - 1; ti >= 0; --ti) {
                    for (ci = compSpec.length - 1; ci >= 0; --ci) {
                        if (!tileSpec[ti] || !compSpec[ci]) continue;
                        this.setTileCompVal(ti, ci, v);
                    }
                }
            }
            endOfParamList = true;
        }
    }

    public int getPPX(int t, int c, int rl) {
        int mrl;
        boolean compSpecified;
        Vector[] v = null;
        boolean tileSpecified = t != -1;
        boolean bl = compSpecified = c != -1;
        if (tileSpecified && compSpecified) {
            mrl = (Integer)this.dls.getTileCompVal(t, c);
            v = (Vector[])this.getTileCompVal(t, c);
        } else if (tileSpecified && !compSpecified) {
            mrl = (Integer)this.dls.getTileDef(t);
            v = (Vector[])this.getTileDef(t);
        } else if (!tileSpecified && compSpecified) {
            mrl = (Integer)this.dls.getCompDef(c);
            v = (Vector[])this.getCompDef(c);
        } else {
            mrl = (Integer)this.dls.getDefault();
            v = (Vector[])this.getDefault();
        }
        int idx = mrl - rl;
        if (v[0].size() > idx) {
            return (Integer)v[0].elementAt(idx);
        }
        return (Integer)v[0].elementAt(v[0].size() - 1);
    }

    public int getPPY(int t, int c, int rl) {
        int mrl;
        boolean compSpecified;
        Vector[] v = null;
        boolean tileSpecified = t != -1;
        boolean bl = compSpecified = c != -1;
        if (tileSpecified && compSpecified) {
            mrl = (Integer)this.dls.getTileCompVal(t, c);
            v = (Vector[])this.getTileCompVal(t, c);
        } else if (tileSpecified && !compSpecified) {
            mrl = (Integer)this.dls.getTileDef(t);
            v = (Vector[])this.getTileDef(t);
        } else if (!tileSpecified && compSpecified) {
            mrl = (Integer)this.dls.getCompDef(c);
            v = (Vector[])this.getCompDef(c);
        } else {
            mrl = (Integer)this.dls.getDefault();
            v = (Vector[])this.getDefault();
        }
        int idx = mrl - rl;
        if (v[1].size() > idx) {
            return (Integer)v[1].elementAt(idx);
        }
        return (Integer)v[1].elementAt(v[1].size() - 1);
    }
}

