/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.fmrc;

import java.util.ArrayList;
import java.util.List;
import ucar.nc2.dataset.CoordinateAxis1D;

public class EnsCoord
implements Comparable {
    private String name;
    private int id;
    public int ensembles;
    public int pdn;
    public int[] ensTypes;

    EnsCoord() {
    }

    EnsCoord(CoordinateAxis1D axis, int[] einfo) {
        this.name = axis.getFullName();
        this.ensembles = einfo[0];
        this.pdn = einfo[1];
        this.ensTypes = new int[this.ensembles];
        System.arraycopy(einfo, 2, this.ensTypes, 0, this.ensembles);
    }

    EnsCoord(EnsCoord ec) {
        this.name = ec.getName();
        this.id = ec.getId();
        this.ensembles = ec.getNEnsembles();
        this.pdn = ec.getPDN();
        this.ensTypes = (int[])ec.getEnsTypes().clone();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getNEnsembles() {
        return this.ensembles;
    }

    public void setNEnsembles(int ensembles) {
        this.ensembles = ensembles;
    }

    public int getPDN() {
        return this.pdn;
    }

    public void setPDN(int pdn) {
        this.pdn = pdn;
    }

    public int[] getEnsTypes() {
        return this.ensTypes;
    }

    public void setEnsTypes(int[] ensTypes) {
        this.ensTypes = ensTypes;
    }

    public int getSize() {
        return this.ensembles;
    }

    public boolean equalsData(EnsCoord other) {
        if (this.ensembles != other.ensembles) {
            return false;
        }
        if (this.pdn != other.pdn) {
            return false;
        }
        for (int i = 0; i < this.ensTypes.length; ++i) {
            if (this.ensTypes[i] == other.ensTypes[i]) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object o) {
        EnsCoord other = (EnsCoord)o;
        return this.name.compareTo(other.name);
    }

    public static EnsCoord findEnsCoord(List<EnsCoord> ensCoords, EnsCoord want) {
        if (want == null) {
            return null;
        }
        for (EnsCoord ec : ensCoords) {
            if (!want.equalsData(ec)) continue;
            return ec;
        }
        EnsCoord result = new EnsCoord(want);
        ensCoords.add(result);
        return result;
    }

    public static void normalize(EnsCoord result, List<EnsCoord> ecList) {
        ArrayList<EnsCoord> extra = new ArrayList<EnsCoord>();
        for (EnsCoord ec : ecList) {
            if (result.equalsData(ec)) continue;
            extra.add(ec);
        }
        if (extra.size() == 0) {
            return;
        }
        for (EnsCoord ec : extra) {
            if (ec.getNEnsembles() < result.getNEnsembles()) continue;
            result = ec;
        }
    }
}

