/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.bundle.internal.osgi;

import java.util.Hashtable;
import org.apache.karaf.cellar.bundle.BundleEventHandler;
import org.apache.karaf.cellar.bundle.BundleSynchronizer;
import org.apache.karaf.cellar.bundle.LocalBundleListener;
import org.apache.karaf.cellar.bundle.management.CellarBundleMBean;
import org.apache.karaf.cellar.bundle.management.internal.CellarBundleMBeanImpl;
import org.apache.karaf.cellar.core.ClusterManager;
import org.apache.karaf.cellar.core.GroupManager;
import org.apache.karaf.cellar.core.Synchronizer;
import org.apache.karaf.cellar.core.event.EventHandler;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.ProvideService;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Services(provides={@ProvideService(value=EventHandler.class), @ProvideService(value=Synchronizer.class), @ProvideService(value=CellarBundleMBean.class)}, requires={@RequireService(value=ClusterManager.class), @RequireService(value=GroupManager.class), @RequireService(value=ConfigurationAdmin.class), @RequireService(value=EventProducer.class), @RequireService(value=FeaturesService.class)})
public class Activator
extends BaseActivator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private LocalBundleListener localBundleListener;
    private BundleSynchronizer synchronizer;
    private BundleEventHandler eventHandler;
    private ServiceRegistration mbeanRegistration;

    @Override
    public void doStart() throws Exception {
        ClusterManager clusterManager = this.getTrackedService(ClusterManager.class);
        if (clusterManager == null) {
            return;
        }
        GroupManager groupManager = this.getTrackedService(GroupManager.class);
        if (groupManager == null) {
            return;
        }
        ConfigurationAdmin configurationAdmin = this.getTrackedService(ConfigurationAdmin.class);
        if (configurationAdmin == null) {
            return;
        }
        EventProducer eventProducer = this.getTrackedService(EventProducer.class);
        if (eventProducer == null) {
            return;
        }
        FeaturesService featuresService = this.getTrackedService(FeaturesService.class);
        if (featuresService == null) {
            return;
        }
        LOGGER.debug("CELLAR BUNDLE: init even handler");
        this.eventHandler = new BundleEventHandler();
        this.eventHandler.setConfigurationAdmin(configurationAdmin);
        this.eventHandler.setClusterManager(clusterManager);
        this.eventHandler.setGroupManager(groupManager);
        this.eventHandler.setBundleContext(this.bundleContext);
        this.eventHandler.setFeaturesService(featuresService);
        this.eventHandler.init();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("managed", "true");
        this.register(EventHandler.class, this.eventHandler, props);
        LOGGER.debug("CELLAR BUNDLE: init local listener");
        this.localBundleListener = new LocalBundleListener();
        this.localBundleListener.setClusterManager(clusterManager);
        this.localBundleListener.setGroupManager(groupManager);
        this.localBundleListener.setConfigurationAdmin(configurationAdmin);
        this.localBundleListener.setEventProducer(eventProducer);
        this.localBundleListener.setFeaturesService(featuresService);
        this.localBundleListener.setBundleContext(this.bundleContext);
        this.localBundleListener.init();
        LOGGER.debug("CELLAR BUNDLE: init synchronizer");
        this.synchronizer = new BundleSynchronizer();
        this.synchronizer.setConfigurationAdmin(configurationAdmin);
        this.synchronizer.setGroupManager(groupManager);
        this.synchronizer.setClusterManager(clusterManager);
        this.synchronizer.setBundleContext(this.bundleContext);
        this.synchronizer.setEventProducer(eventProducer);
        this.synchronizer.init(this.bundleContext);
        props = new Hashtable();
        props.put("resource", "bundle");
        this.register(Synchronizer.class, this.synchronizer, props);
        LOGGER.debug("CELLAR BUNDLE: register MBean");
        CellarBundleMBeanImpl mbean = new CellarBundleMBeanImpl();
        mbean.setClusterManager(clusterManager);
        mbean.setConfigurationAdmin(configurationAdmin);
        mbean.setGroupManager(groupManager);
        mbean.setEventProducer(eventProducer);
        mbean.setBundleContext(this.bundleContext);
        props = new Hashtable();
        props.put("jmx.objectname", "org.apache.karaf.cellar:type=bundle,name=" + System.getProperty("karaf.name"));
        this.mbeanRegistration = this.bundleContext.registerService(this.getInterfaceNames(mbean), (Object)mbean, props);
    }

    @Override
    public void doStop() {
        super.doStop();
        if (this.mbeanRegistration != null) {
            this.mbeanRegistration.unregister();
            this.mbeanRegistration = null;
        }
        if (this.synchronizer != null) {
            this.synchronizer.destroy();
            this.synchronizer = null;
        }
        if (this.localBundleListener != null) {
            this.localBundleListener.destroy();
            this.localBundleListener = null;
        }
        if (this.eventHandler != null) {
            this.eventHandler.destroy();
            this.eventHandler = null;
        }
    }
}

