/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.core.processor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.unomi.router.api.ImportConfiguration;
import org.apache.unomi.router.api.ImportExportConfiguration;
import org.apache.unomi.router.api.ImportLineError;
import org.apache.unomi.router.api.ProfileToImport;
import org.apache.unomi.router.api.RouterUtils;
import org.apache.unomi.router.api.services.ImportExportConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportRouteCompletionProcessor
implements Processor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ImportRouteCompletionProcessor.class.getName());
    private ImportExportConfigurationService<ImportConfiguration> importConfigurationService;
    private int executionsHistorySize;
    private int execErrReportSize;

    public void process(Exchange exchange) throws Exception {
        String importConfigId = null;
        ImportConfiguration importConfigOneShot = (ImportConfiguration)exchange.getIn().getHeader("importConfigOneShot");
        importConfigId = importConfigOneShot != null ? importConfigOneShot.getItemId() : exchange.getFromRouteId();
        ImportConfiguration importConfiguration = (ImportConfiguration)this.importConfigurationService.load(importConfigId);
        long successCount = 0L;
        long failureCount = 0L;
        long ignoreCount = 0L;
        ArrayList<ImportLineError> errors = new ArrayList<ImportLineError>();
        for (Object line : (ArrayList)exchange.getIn().getBody(ArrayList.class)) {
            if (line instanceof ProfileToImport) {
                ++successCount;
                continue;
            }
            if (line instanceof ImportLineError) {
                ++failureCount;
                if (errors.size() >= this.execErrReportSize) continue;
                errors.add((ImportLineError)line);
                continue;
            }
            ++ignoreCount;
        }
        Integer nbTotal = (Integer)exchange.getProperty("CamelSplitSize");
        if (importConfiguration.isHasHeader()) {
            Object line;
            line = nbTotal;
            nbTotal = nbTotal - 1;
        }
        HashMap<String, Serializable> execution = new HashMap<String, Serializable>();
        execution.put("date", Long.valueOf(((Date)exchange.getProperty("CamelCreatedTimestamp")).getTime()));
        execution.put("totalLinesNb", nbTotal);
        execution.put("successCount", Long.valueOf(successCount));
        execution.put("failureCount", Long.valueOf(failureCount));
        execution.put("errors", errors);
        importConfiguration = (ImportConfiguration)RouterUtils.addExecutionEntry((ImportExportConfiguration)importConfiguration, execution, (int)this.executionsHistorySize);
        if (failureCount > 0L && successCount > 0L) {
            importConfiguration.setStatus("WITH_ERRORS");
        } else if (failureCount > 0L && successCount == 0L) {
            importConfiguration.setStatus("ERRORS");
        } else if (failureCount == 0L && successCount > 0L) {
            importConfiguration.setStatus("SUCCESS");
        }
        this.importConfigurationService.save((Object)importConfiguration, false);
        LOGGER.info("Processing route {} completed. completion date: {}.", (Object)exchange.getFromRouteId(), (Object)new Date());
    }

    public void setImportConfigurationService(ImportExportConfigurationService<ImportConfiguration> importConfigurationService) {
        this.importConfigurationService = importConfigurationService;
    }

    public void setExecutionsHistorySize(int executionsHistorySize) {
        this.executionsHistorySize = executionsHistorySize;
    }

    public void setExecErrReportSize(int execErrReportSize) {
        this.execErrReportSize = execErrReportSize;
    }
}

