/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.endpoints;

import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.api.rules.Rule;
import org.apache.unomi.api.rules.RuleStatistics;
import org.apache.unomi.api.services.RulesService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
@Path(value="/rules")
@Component(service={RulesServiceEndPoint.class}, property={"osgi.jaxrs.resource=true"})
public class RulesServiceEndPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)RulesServiceEndPoint.class.getName());
    @Reference
    private RulesService rulesService;

    public RulesServiceEndPoint() {
        LOGGER.info("Initializing rule service endpoint...");
    }

    public void setRulesService(RulesService rulesService) {
        this.rulesService = rulesService;
    }

    @GET
    @Path(value="/")
    public Set<Metadata> getRuleMetadatas() {
        return this.rulesService.getRuleMetadatas();
    }

    @POST
    @Path(value="/")
    public void setRule(Rule rule) {
        this.rulesService.setRule(rule);
    }

    @GET
    @Path(value="/statistics")
    public Map<String, RuleStatistics> getAllRuleStatistics() {
        return this.rulesService.getAllRuleStatistics();
    }

    @DELETE
    @Path(value="/statistics")
    public void resetAllRuleStatistics() {
        this.rulesService.resetAllRuleStatistics();
    }

    @POST
    @Path(value="/query")
    public PartialList<Metadata> getRuleMetadatas(Query query) {
        return this.rulesService.getRuleMetadatas(query);
    }

    @POST
    @Path(value="/query/detailed")
    public PartialList<Rule> getRuleDetails(Query query) {
        return this.rulesService.getRuleDetails(query);
    }

    @GET
    @Path(value="/{ruleId}")
    public Rule getRule(@PathParam(value="ruleId") String ruleId) {
        return this.rulesService.getRule(ruleId);
    }

    @GET
    @Path(value="/{ruleId}/statistics")
    public RuleStatistics getRuleStatistics(@PathParam(value="ruleId") String ruleId) {
        return this.rulesService.getRuleStatistics(ruleId);
    }

    @DELETE
    @Path(value="/{ruleId}")
    public void removeRule(@PathParam(value="ruleId") String ruleId) {
        this.rulesService.removeRule(ruleId);
    }

    @Deprecated
    @GET
    @Path(value="/resetQueries")
    public void resetQueries() {
        for (Metadata metadata : this.rulesService.getRuleMetadatas()) {
            Rule r = this.rulesService.getRule(metadata.getId());
            this.rulesService.setRule(r);
        }
    }
}

