/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.migration.service;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.util.GroovyScriptEngine;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.karaf.shell.api.console.Session;
import org.apache.unomi.shell.migration.MigrationException;
import org.apache.unomi.shell.migration.MigrationService;
import org.apache.unomi.shell.migration.service.MigrationConfig;
import org.apache.unomi.shell.migration.service.MigrationContext;
import org.apache.unomi.shell.migration.service.MigrationScript;
import org.apache.unomi.shell.migration.utils.HttpUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(service={MigrationService.class}, immediate=true)
public class MigrationServiceImpl
implements MigrationService {
    public static final String MIGRATION_FS_ROOT_FOLDER = "migration";
    public static final Path MIGRATION_FS_SCRIPTS_FOLDER = Paths.get(System.getProperty("karaf.data"), "migration", "scripts");
    private BundleContext bundleContext;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    private MigrationConfig migrationConfig;

    @Activate
    public void activate(ComponentContext componentContext) {
        this.bundleContext = componentContext.getBundleContext();
    }

    @Override
    public void migrateUnomi(String originVersion, boolean skipConfirmation, Session session) throws Exception {
        System.out.println("Migrating Unomi...");
        this.waitForMigrationConfigLoad(60, 1);
        Set<MigrationScript> scripts = this.loadOSGIScripts();
        scripts.addAll(this.loadFileSystemScripts());
        Files.createDirectories(MIGRATION_FS_SCRIPTS_FOLDER, new FileAttribute[0]);
        MigrationContext context = new MigrationContext(session, this.migrationConfig);
        context.tryRecoverFromHistory();
        if (originVersion == null) {
            this.displayMigrations(scripts, context);
            context.printMessage("Select your migration starting point by specifying the current version (e.g. 1.2.0) or the last script that was already run (e.g. 1.2.1)");
            return;
        }
        Version fromVersion = new Version(originVersion);
        if ((scripts = this.filterScriptsFromVersion(scripts, fromVersion)).size() == 0) {
            context.printMessage("No migration scripts available found starting from version: " + originVersion);
            return;
        }
        context.printMessage("The following migration scripts starting from version: " + originVersion + " will be executed.");
        this.displayMigrations(scripts, context);
        if (!skipConfirmation && context.askUserWithAuthorizedAnswer("[WARNING] You are about to execute a migration, this a very sensitive operation, are you sure? (yes/no): ", Arrays.asList("yes", "no")).equalsIgnoreCase("no")) {
            context.printMessage("Migration process aborted");
            return;
        }
        BasicCredentialsProvider credentialsProvider = null;
        String login = context.getConfigString("esLogin");
        if (StringUtils.isNotEmpty((CharSequence)login)) {
            credentialsProvider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(login, context.getConfigString("esPassword"));
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        }
        try (CloseableHttpClient httpClient = HttpUtils.initHttpClient(context.getConfigBoolean("httpClient.trustAllCertificates"), (CredentialsProvider)credentialsProvider);){
            context.setHttpClient(httpClient);
            scripts = this.parseScripts(scripts, context);
            context.printMessage("Starting migration process from version: " + originVersion);
            for (MigrationScript migrateScript : scripts) {
                context.printMessage("Starting execution of: " + String.valueOf(migrateScript));
                try {
                    migrateScript.getCompiledScript().run();
                }
                catch (MigrationException e) {
                    context.printException("Error executing: " + String.valueOf(migrateScript));
                    throw e;
                }
                catch (Exception e) {
                    context.printException("Error executing: " + String.valueOf(migrateScript), e);
                    throw e;
                }
                context.printMessage("Finish execution of: " + String.valueOf(migrateScript));
            }
            context.performMigrationStep("migrationStatus", () -> {});
        }
    }

    private void waitForMigrationConfigLoad(int maxTry, int secondsToSleep) throws InterruptedException {
        while (!this.migrationConfig.getConfig().containsKey("felix.fileinstall.filename")) {
            if (--maxTry == 0) {
                throw new IllegalStateException("Waited too long for migration config to be available");
            }
            TimeUnit.SECONDS.sleep(secondsToSleep);
        }
    }

    private void displayMigrations(Set<MigrationScript> scripts, MigrationContext context) {
        Version previousVersion = new Version("0.0.0");
        for (MigrationScript migration : scripts) {
            if (migration.getVersion().getMajor() > previousVersion.getMajor() || migration.getVersion().getMinor() > previousVersion.getMinor()) {
                context.printMessage("From " + migration.getVersion().getMajor() + "." + migration.getVersion().getMinor() + ".0:");
            }
            context.printMessage("- " + String.valueOf(migration));
            previousVersion = migration.getVersion();
        }
    }

    private Set<MigrationScript> filterScriptsFromVersion(Set<MigrationScript> scripts, Version fromVersion) {
        return scripts.stream().filter(migrateScript -> fromVersion.compareTo(migrateScript.getVersion()) < 0).collect(Collectors.toCollection(TreeSet::new));
    }

    private Set<MigrationScript> parseScripts(Set<MigrationScript> scripts, MigrationContext context) {
        HashMap shellsPerBundle = new HashMap();
        return scripts.stream().peek(migrateScript -> {
            Bundle scriptBundle;
            Bundle bundle = scriptBundle = migrateScript.getBundle() != null ? migrateScript.getBundle() : this.bundleContext.getBundle();
            if (!shellsPerBundle.containsKey(scriptBundle.getSymbolicName())) {
                shellsPerBundle.put(scriptBundle.getSymbolicName(), this.buildShellForBundle(scriptBundle, context));
            }
            migrateScript.setCompiledScript(((GroovyShell)shellsPerBundle.get(scriptBundle.getSymbolicName())).parse(migrateScript.getScript()));
        }).collect(Collectors.toCollection(TreeSet::new));
    }

    private Set<MigrationScript> loadOSGIScripts() throws IOException {
        TreeSet<MigrationScript> migrationScripts = new TreeSet<MigrationScript>();
        for (Bundle bundle : this.bundleContext.getBundles()) {
            Enumeration scripts = bundle.findEntries("META-INF/cxs/migration", "*.groovy", true);
            if (scripts == null) continue;
            while (scripts.hasMoreElements()) {
                URL scriptURL = (URL)scripts.nextElement();
                migrationScripts.add(new MigrationScript(scriptURL, bundle));
            }
        }
        return migrationScripts;
    }

    private Set<MigrationScript> loadFileSystemScripts() throws IOException {
        List paths;
        if (!Files.isDirectory(MIGRATION_FS_SCRIPTS_FOLDER, new LinkOption[0])) {
            return Collections.emptySet();
        }
        try (Stream<Path> walk = Files.walk(MIGRATION_FS_SCRIPTS_FOLDER, new FileVisitOption[0]);){
            paths = walk.filter(path -> !Files.isDirectory(path, new LinkOption[0])).filter(path -> path.toString().toLowerCase().endsWith("groovy")).collect(Collectors.toList());
        }
        TreeSet<MigrationScript> migrationScripts = new TreeSet<MigrationScript>();
        for (Path path2 : paths) {
            migrationScripts.add(new MigrationScript(path2.toUri().toURL(), null));
        }
        return migrationScripts;
    }

    private GroovyShell buildShellForBundle(Bundle bundle, MigrationContext context) {
        GroovyClassLoader groovyLoader = new GroovyClassLoader(((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader());
        GroovyScriptEngine groovyScriptEngine = new GroovyScriptEngine((URL[])null, (ClassLoader)groovyLoader);
        GroovyShell groovyShell = new GroovyShell((ClassLoader)groovyScriptEngine.getGroovyClassLoader());
        groovyShell.setVariable("migrationContext", (Object)context);
        groovyShell.setVariable("bundleContext", (Object)bundle.getBundleContext());
        return groovyShell;
    }

    public void setMigrationConfig(MigrationConfig migrationConfig) {
        this.migrationConfig = migrationConfig;
    }
}

