/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.ops4j.pax.web.service.spi.model.events.WebApplicationEvent;
import org.ops4j.pax.web.service.spi.model.events.WebApplicationEventListener;
import org.ops4j.pax.web.service.spi.util.NamedThreadFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApplicationEventDispatcher
implements WebApplicationEventListener,
ServiceTrackerCustomizer<WebApplicationEventListener, WebApplicationEventListener>,
BundleListener {
    private static final Logger LOG = LoggerFactory.getLogger(WebApplicationEventDispatcher.class);
    private final BundleContext bundleContext;
    private final ExecutorService executor;
    private final ServiceTracker<WebApplicationEventListener, WebApplicationEventListener> webApplicationListenerTracker;
    private final Set<WebApplicationEventListener> listeners = new CopyOnWriteArraySet<WebApplicationEventListener>();

    public WebApplicationEventDispatcher(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.executor = Executors.newFixedThreadPool(1, (ThreadFactory)new NamedThreadFactory("wab-events"));
        this.webApplicationListenerTracker = new ServiceTracker(bundleContext, WebApplicationEventListener.class.getName(), (ServiceTrackerCustomizer)this);
        this.webApplicationListenerTracker.open();
        this.bundleContext.addBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebApplicationEventListener addingService(ServiceReference<WebApplicationEventListener> reference) {
        WebApplicationEventListener listener = (WebApplicationEventListener)this.bundleContext.getService(reference);
        if (listener != null) {
            LOG.debug("New WebApplicationEventListener added: {}", (Object)listener.getClass().getName());
            Set<WebApplicationEventListener> set = this.listeners;
            synchronized (set) {
                this.listeners.add(listener);
            }
        }
        return listener;
    }

    public void modifiedService(ServiceReference<WebApplicationEventListener> reference, WebApplicationEventListener service) {
    }

    public void removedService(ServiceReference<WebApplicationEventListener> reference, WebApplicationEventListener service) {
        this.listeners.remove(service);
        this.bundleContext.ungetService(reference);
        LOG.debug("WebApplicationEventListener is removed: {}", (Object)service.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void webEvent(WebApplicationEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending web event " + event + " for bundle " + event.getBundleName());
        }
        Set<WebApplicationEventListener> set = this.listeners;
        synchronized (set) {
            this.callListeners(event);
        }
    }

    void destroy() {
        this.bundleContext.removeBundleListener((BundleListener)this);
        this.webApplicationListenerTracker.close();
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    Set<WebApplicationEventListener> getListeners() {
        return this.listeners;
    }

    private void callListeners(WebApplicationEvent event) {
        for (WebApplicationEventListener listener : this.listeners) {
            try {
                this.callListener(listener, event);
            }
            catch (RejectedExecutionException ree) {
                LOG.warn("Executor shut down", (Throwable)ree);
                break;
            }
        }
    }

    private void callListener(WebApplicationEventListener listener, WebApplicationEvent event) {
        try {
            this.executor.invokeAny(Collections.singleton(() -> {
                listener.webEvent(event);
                return null;
            }), 60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            LOG.warn("Thread interrupted", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException te) {
            LOG.warn("Listener timed out, will be ignored", (Throwable)te);
            this.listeners.remove(listener);
        }
        catch (ExecutionException ee) {
            LOG.warn("Listener caused an exception, will be ignored", (Throwable)ee);
            this.listeners.remove(listener);
        }
    }
}

