/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RuleQuery
extends QueryBase
implements QueryVariant {
    private final Query organic;
    private final List<String> rulesetIds;
    @Nullable
    private final String rulesetId;
    private final JsonData matchCriteria;
    public static final JsonpDeserializer<RuleQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RuleQuery::setupRuleQueryDeserializer);

    private RuleQuery(Builder builder) {
        super(builder);
        this.organic = ApiTypeHelper.requireNonNull(builder.organic, this, "organic");
        this.rulesetIds = ApiTypeHelper.unmodifiable(builder.rulesetIds);
        this.rulesetId = builder.rulesetId;
        this.matchCriteria = ApiTypeHelper.requireNonNull(builder.matchCriteria, this, "matchCriteria");
    }

    public static RuleQuery of(Function<Builder, ObjectBuilder<RuleQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Rule;
    }

    public final Query organic() {
        return this.organic;
    }

    public final List<String> rulesetIds() {
        return this.rulesetIds;
    }

    @Nullable
    public final String rulesetId() {
        return this.rulesetId;
    }

    public final JsonData matchCriteria() {
        return this.matchCriteria;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("organic");
        this.organic.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.rulesetIds)) {
            generator.writeKey("ruleset_ids");
            generator.writeStartArray();
            for (String item0 : this.rulesetIds) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.rulesetId != null) {
            generator.writeKey("ruleset_id");
            generator.write(this.rulesetId);
        }
        generator.writeKey("match_criteria");
        this.matchCriteria.serialize(generator, mapper);
    }

    protected static void setupRuleQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::organic, Query._DESERIALIZER, "organic");
        op.add(Builder::rulesetIds, JsonpDeserializer.arrayDeserializer((JsonpDeserializer)JsonpDeserializer.stringDeserializer()), "ruleset_ids");
        op.add(Builder::rulesetId, JsonpDeserializer.stringDeserializer(), "ruleset_id");
        op.add(Builder::matchCriteria, JsonData._DESERIALIZER, "match_criteria");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RuleQuery> {
        private Query organic;
        @Nullable
        private List<String> rulesetIds;
        @Nullable
        private String rulesetId;
        private JsonData matchCriteria;

        public final Builder organic(Query value) {
            this.organic = value;
            return this;
        }

        public final Builder organic(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.organic(fn.apply(new Query.Builder()).build());
        }

        public final Builder organic(QueryVariant value) {
            this.organic = value._toQuery();
            return this;
        }

        public final Builder rulesetIds(List<String> list) {
            this.rulesetIds = Builder._listAddAll(this.rulesetIds, list);
            return this;
        }

        public final Builder rulesetIds(String value, String ... values) {
            this.rulesetIds = Builder._listAdd(this.rulesetIds, value, values);
            return this;
        }

        public final Builder rulesetId(@Nullable String value) {
            this.rulesetId = value;
            return this;
        }

        public final Builder matchCriteria(JsonData value) {
            this.matchCriteria = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RuleQuery build() {
            this._checkSingleUse();
            return new RuleQuery(this);
        }
    }
}

