/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.wicket.markup.head.AbstractJavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IReferenceHeaderItem;
import org.apache.wicket.markup.html.CrossOrigin;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.bundles.IResourceBundle;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class JavaScriptReferenceHeaderItem
extends AbstractJavaScriptReferenceHeaderItem
implements IReferenceHeaderItem {
    private static final long serialVersionUID = 1L;
    private final ResourceReference reference;
    private final PageParameters pageParameters;

    public JavaScriptReferenceHeaderItem(ResourceReference reference, PageParameters pageParameters, String id) {
        this.reference = (ResourceReference)Args.notNull((Object)reference, (String)"reference");
        this.pageParameters = pageParameters;
        this.setId(id);
    }

    @Override
    public ResourceReference getReference() {
        return this.reference;
    }

    public PageParameters getPageParameters() {
        return this.pageParameters;
    }

    @Override
    public List<HeaderItem> getDependencies() {
        return this.getReference().getDependencies();
    }

    @Override
    public Iterable<? extends HeaderItem> getProvidedResources() {
        if (this.getReference() instanceof IResourceBundle) {
            return ((IResourceBundle)((Object)this.getReference())).getProvidedResources();
        }
        return super.getProvidedResources();
    }

    @Override
    public void render(Response response) {
        this.internalRenderJavaScriptReference(response, this.getUrl());
    }

    @Override
    public Iterable<?> getRenderTokens() {
        String url = Strings.stripJSessionId((String)this.getUrl());
        if (Strings.isEmpty((String)this.getId())) {
            return Collections.singletonList("javascript-" + url);
        }
        return Arrays.asList("javascript-" + this.getId(), "javascript-" + url);
    }

    public String toString() {
        return "JavaScriptReferenceHeaderItem(" + String.valueOf(this.getReference()) + ", " + String.valueOf(this.getPageParameters()) + ")";
    }

    private String getUrl() {
        ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(this.getReference(), this.getPageParameters());
        return RequestCycle.get().urlFor(handler).toString();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.reference != null ? this.reference.hashCode() : 0);
        result = 31 * result + (this.pageParameters != null ? this.pageParameters.hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaScriptReferenceHeaderItem that = (JavaScriptReferenceHeaderItem)o;
        return Objects.equals(this.reference, that.reference) && Objects.equals(this.pageParameters, that.pageParameters);
    }

    @Override
    public String getIntegrity() {
        String tempIntegrity = super.getIntegrity();
        if (tempIntegrity == null) {
            tempIntegrity = this.reference.getIntegrity();
        }
        return tempIntegrity;
    }

    @Override
    public CrossOrigin getCrossOrigin() {
        CrossOrigin tempOrigin = super.getCrossOrigin();
        if (tempOrigin == null) {
            tempOrigin = this.reference.getCrossOrigin();
        }
        return tempOrigin;
    }
}

