/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.List;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;

public abstract class GroupedDropDownChoice<T>
extends DropDownChoice<T> {
    private static final long serialVersionUID = 1L;
    private transient T previousChoice;
    private transient boolean inOptionGroup;

    public GroupedDropDownChoice(String id) {
        super(id);
    }

    public GroupedDropDownChoice(String id, List<? extends T> choices) {
        super(id, choices);
    }

    public GroupedDropDownChoice(String id, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
    }

    public GroupedDropDownChoice(String id, IModel<T> model, List<? extends T> choices) {
        super(id, model, choices);
    }

    public GroupedDropDownChoice(String id, IModel<T> model, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model, choices, renderer);
    }

    public GroupedDropDownChoice(String id, IModel<? extends List<? extends T>> choices) {
        super(id, choices);
    }

    public GroupedDropDownChoice(String id, IModel<T> model, IModel<? extends List<? extends T>> choices) {
        super(id, model, choices);
    }

    public GroupedDropDownChoice(String id, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
    }

    public GroupedDropDownChoice(String id, IModel<T> model, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model, choices, renderer);
    }

    private boolean isLast(int index) {
        return index - 1 == this.getChoices().size();
    }

    protected abstract boolean isNewGroup(T var1, T var2);

    protected abstract boolean hasNoGroup(T var1);

    protected abstract IModel<String> getGroupLabel(T var1);

    @Override
    protected void appendOptionHtml(AppendingStringBuffer buffer, T choice, int index, String selected) {
        if (this.hasNoGroup(choice)) {
            if (this.inOptionGroup) {
                buffer.append("\n</optgroup>");
                this.inOptionGroup = false;
            }
            super.appendOptionHtml(buffer, choice, index, selected);
            this.previousChoice = choice;
            return;
        }
        if (this.isNewGroup(this.previousChoice, choice)) {
            if (this.inOptionGroup) {
                buffer.append("\n</optgroup>");
            }
            this.inOptionGroup = true;
            buffer.append("\n<optgroup label='");
            buffer.append(Strings.escapeMarkup(this.getGroupLabel(choice).getObject()));
            buffer.append("'>");
        }
        super.appendOptionHtml(buffer, choice, index, selected);
        if (this.isLast(index) && this.inOptionGroup) {
            buffer.append("\n</optgroup>");
            this.inOptionGroup = false;
        }
        this.previousChoice = choice;
    }
}

