/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.impl.compat;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.Future;
import org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.annotation.Contract;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.annotation.Experimental;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.annotation.Internal;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.annotation.ThreadingBehavior;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.concurrent.CancellableDependency;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.ClassicHttpRequest;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.ClassicHttpResponse;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.HttpHost;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.support.classic.ClassicToAsyncRequestProducer;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.support.classic.ClassicToAsyncResponseConsumer;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.HttpContext;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.io.CloseMode;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.util.Timeout;

@Experimental
@Internal
@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class ClassicToAsyncAdaptor
extends CloseableHttpClient {
    private final CloseableHttpAsyncClient client;
    private final Timeout operationTimeout;

    public ClassicToAsyncAdaptor(CloseableHttpAsyncClient client, Timeout operationTimeout) {
        this.client = client;
        this.operationTimeout = operationTimeout;
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, ClassicHttpRequest request, HttpContext context) throws IOException {
        ClassicToAsyncRequestProducer requestProducer = new ClassicToAsyncRequestProducer(request, this.operationTimeout);
        ClassicToAsyncResponseConsumer responseConsumer = new ClassicToAsyncResponseConsumer(this.operationTimeout);
        Future<Void> resultFuture = this.client.execute(target, requestProducer, responseConsumer, null, context, null);
        if (request instanceof CancellableDependency) {
            ((CancellableDependency)((Object)request)).setDependency(() -> resultFuture.cancel(true));
        }
        try {
            requestProducer.blockWaiting().execute();
            ClassicHttpResponse response = responseConsumer.blockWaiting();
            return CloseableHttpResponse.create(response, (closeable, closeMode) -> {
                try {
                    if (closeMode == CloseMode.GRACEFUL) {
                        closeable.close();
                    }
                }
                finally {
                    resultFuture.cancel(true);
                }
            });
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    @Override
    public void close(CloseMode closeMode) {
        this.client.close(closeMode);
    }
}

