/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime.rtti;

import java.util.Arrays;
import org.apache.calcite.runtime.rtti.RuntimeTypeInformation;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GenericSqlTypeRtti
extends RuntimeTypeInformation {
    final RuntimeTypeInformation[] typeArguments;

    public GenericSqlTypeRtti(RuntimeTypeInformation.RuntimeSqlTypeName typeName, RuntimeTypeInformation ... typeArguments) {
        super(typeName);
        assert (!typeName.isScalar()) : "Generic type cannot be a scalar type " + (Object)((Object)typeName);
        this.typeArguments = typeArguments;
    }

    @Override
    public String getTypeString() {
        switch (this.typeName) {
            case ARRAY: {
                return "ARRAY";
            }
            case MAP: {
                return "MAP";
            }
            case MULTISET: {
                return "MULTISET";
            }
        }
        throw new RuntimeException("Unexpected type " + (Object)((Object)this.typeName));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("new GenericSqlTypeRtti(").append(this.getTypeString());
        for (RuntimeTypeInformation arg : this.typeArguments) {
            builder.append(", ");
            builder.append(arg.toString());
        }
        builder.append(")");
        return builder.toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericSqlTypeRtti that = (GenericSqlTypeRtti)o;
        return this.typeName == that.typeName && Arrays.equals(this.typeArguments, that.typeArguments);
    }

    public int hashCode() {
        return Arrays.hashCode(this.typeArguments);
    }

    public RuntimeTypeInformation getTypeArgument(int index) {
        return this.typeArguments[index];
    }

    public int getArgumentCount() {
        return this.typeArguments.length;
    }
}

