# Copyright 2023 Google, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

require "faraday"

module Google
  # Module Auth provides classes that provide Google-specific authorization
  # used to access Google APIs.
  module Auth
    # Helpers provides utility methods for Google::Auth.
    module Helpers
      # Connection provides a Faraday connection for use with Google::Auth.
      module Connection
        module_function

        def default_connection
          @default_connection
        end

        def default_connection= conn
          @default_connection = conn
        end

        def connection
          @default_connection || Faraday.default_connection
        end
      end
    end
  end
end
