/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetCloudVmClusterUpdateHistoryEntryRequest
extends BmcRequest<Void> {
    private String cloudVmClusterId;
    private String updateHistoryEntryId;
    private String opcRequestId;

    public String getCloudVmClusterId() {
        return this.cloudVmClusterId;
    }

    public String getUpdateHistoryEntryId() {
        return this.updateHistoryEntryId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().cloudVmClusterId(this.cloudVmClusterId).updateHistoryEntryId(this.updateHistoryEntryId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",cloudVmClusterId=").append(String.valueOf(this.cloudVmClusterId));
        sb.append(",updateHistoryEntryId=").append(String.valueOf(this.updateHistoryEntryId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetCloudVmClusterUpdateHistoryEntryRequest)) {
            return false;
        }
        GetCloudVmClusterUpdateHistoryEntryRequest other = (GetCloudVmClusterUpdateHistoryEntryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.cloudVmClusterId, other.cloudVmClusterId) && Objects.equals(this.updateHistoryEntryId, other.updateHistoryEntryId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.cloudVmClusterId == null ? 43 : this.cloudVmClusterId.hashCode());
        result = result * 59 + (this.updateHistoryEntryId == null ? 43 : this.updateHistoryEntryId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCloudVmClusterUpdateHistoryEntryRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String cloudVmClusterId = null;
        private String updateHistoryEntryId = null;
        private String opcRequestId = null;

        public Builder cloudVmClusterId(String cloudVmClusterId) {
            this.cloudVmClusterId = cloudVmClusterId;
            return this;
        }

        public Builder updateHistoryEntryId(String updateHistoryEntryId) {
            this.updateHistoryEntryId = updateHistoryEntryId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCloudVmClusterUpdateHistoryEntryRequest o) {
            this.cloudVmClusterId(o.getCloudVmClusterId());
            this.updateHistoryEntryId(o.getUpdateHistoryEntryId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCloudVmClusterUpdateHistoryEntryRequest build() {
            GetCloudVmClusterUpdateHistoryEntryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetCloudVmClusterUpdateHistoryEntryRequest buildWithoutInvocationCallback() {
            GetCloudVmClusterUpdateHistoryEntryRequest request = new GetCloudVmClusterUpdateHistoryEntryRequest();
            request.cloudVmClusterId = this.cloudVmClusterId;
            request.updateHistoryEntryId = this.updateHistoryEntryId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

