/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.UpdateDbHomeDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateDbHomeRequest
extends BmcRequest<UpdateDbHomeDetails> {
    private String dbHomeId;
    private UpdateDbHomeDetails updateDbHomeDetails;
    private String ifMatch;

    public String getDbHomeId() {
        return this.dbHomeId;
    }

    public UpdateDbHomeDetails getUpdateDbHomeDetails() {
        return this.updateDbHomeDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateDbHomeDetails getBody$() {
        return this.updateDbHomeDetails;
    }

    public Builder toBuilder() {
        return new Builder().dbHomeId(this.dbHomeId).updateDbHomeDetails(this.updateDbHomeDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dbHomeId=").append(String.valueOf(this.dbHomeId));
        sb.append(",updateDbHomeDetails=").append(String.valueOf((Object)this.updateDbHomeDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDbHomeRequest)) {
            return false;
        }
        UpdateDbHomeRequest other = (UpdateDbHomeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dbHomeId, other.dbHomeId) && Objects.equals((Object)this.updateDbHomeDetails, (Object)other.updateDbHomeDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dbHomeId == null ? 43 : this.dbHomeId.hashCode());
        result = result * 59 + (this.updateDbHomeDetails == null ? 43 : this.updateDbHomeDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateDbHomeRequest, UpdateDbHomeDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dbHomeId = null;
        private UpdateDbHomeDetails updateDbHomeDetails = null;
        private String ifMatch = null;

        public Builder dbHomeId(String dbHomeId) {
            this.dbHomeId = dbHomeId;
            return this;
        }

        public Builder updateDbHomeDetails(UpdateDbHomeDetails updateDbHomeDetails) {
            this.updateDbHomeDetails = updateDbHomeDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateDbHomeRequest o) {
            this.dbHomeId(o.getDbHomeId());
            this.updateDbHomeDetails(o.getUpdateDbHomeDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateDbHomeRequest build() {
            UpdateDbHomeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateDbHomeDetails body) {
            this.updateDbHomeDetails(body);
            return this;
        }

        public UpdateDbHomeRequest buildWithoutInvocationCallback() {
            UpdateDbHomeRequest request = new UpdateDbHomeRequest();
            request.dbHomeId = this.dbHomeId;
            request.updateDbHomeDetails = this.updateDbHomeDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

