/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mylyn.util.commands;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizeQueriesJob;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizeTasksJob;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.netbeans.modules.mylyn.util.BugtrackingCommand;
import org.netbeans.modules.mylyn.util.NbTask;
import org.netbeans.modules.mylyn.util.internal.Accessor;
import org.netbeans.modules.team.commons.LogUtils;

public class SynchronizeQueryCommand
extends BugtrackingCommand {
    private String stringValue;
    private final TaskRepository taskRepository;
    private final RepositoryQuery query;
    private final IProgressMonitor monitor;
    private final List<CommandProgressListener> listeners = new CopyOnWriteArrayList<CommandProgressListener>();
    private final TaskList taskList;
    private final AbstractRepositoryConnector repositoryConnector;
    private final RepositoryModel repositoryModel;
    private final TaskDataManager taskDataManager;
    private IStatus status;

    SynchronizeQueryCommand(RepositoryModel repositoryModel, AbstractRepositoryConnector repositoryConnector, TaskRepository taskRepository, TaskList taskList, TaskDataManager taskDataManager, RepositoryQuery query, IProgressMonitor monitor) {
        this.repositoryModel = repositoryModel;
        this.repositoryConnector = repositoryConnector;
        this.taskRepository = taskRepository;
        this.taskList = taskList;
        this.taskDataManager = taskDataManager;
        this.query = query;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws CoreException, IOException, MalformedURLException {
        LogUtils.logBugtrackingUsage((String)this.repositoryConnector.getConnectorKind(), (String)"ISSUE_QUERY");
        final Accessor accessor = Accessor.getInstance();
        Logger log = Logger.getLogger(this.getClass().getName());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "executing SynchronizeQueryCommand for query {0}:{1}", new Object[]{this.taskRepository.getUrl(), this.query.getSummary()});
        }
        SynchronizeQueriesJob job = new SynchronizeQueriesJob(this.taskList, this.taskDataManager, (IRepositoryModel)this.repositoryModel, this.repositoryConnector, this.taskRepository, Collections.singleton(this.query));
        final Set tasksToSynchronize = Collections.synchronizedSet(new HashSet());
        final Set<ITask> pendingToRefreshTasks = Collections.synchronizedSet(new HashSet());
        final HashSet toSync = new HashSet();
        ITaskListChangeListener list = new ITaskListChangeListener(){
            final /* synthetic */ SynchronizeQueryCommand this$0;
            {
                this.this$0 = this$0;
            }

            public void containersChanged(Set<TaskContainerDelta> deltas) {
                for (TaskContainerDelta delta : deltas) {
                    if (this.this$0.query == delta.getElement() && delta.getKind() == TaskContainerDelta.Kind.CONTENT) {
                        if (this.this$0.query.isSynchronizing()) continue;
                        tasksToSynchronize.addAll(this.this$0.query.getChildren());
                        HashSet addedTasks = new HashSet(tasksToSynchronize);
                        addedTasks.removeAll(pendingToRefreshTasks);
                        tasksToSynchronize.removeAll(addedTasks);
                        pendingToRefreshTasks.removeAll(tasksToSynchronize);
                        pendingToRefreshTasks.addAll(addedTasks);
                        toSync.addAll(tasksToSynchronize);
                        toSync.addAll(pendingToRefreshTasks);
                        Collection<NbTask> nbTasks = accessor.toNbTasks(toSync);
                        CommandProgressListener[] commandProgressListenerArray = this.this$0.listeners.toArray(new CommandProgressListener[0]);
                        int n = commandProgressListenerArray.length;
                        for (int i = 0; i < n; ++i) {
                            CommandProgressListener cmdList = commandProgressListenerArray[i];
                            cmdList.tasksRefreshStarted(nbTasks);
                        }
                        continue;
                    }
                    if (!(delta.getElement() instanceof ITask)) continue;
                    ITask task = (ITask)delta.getElement();
                    if (delta.getKind() == TaskContainerDelta.Kind.CONTENT && task instanceof AbstractTask && !((AbstractTask)task).isSynchronizing()) {
                        pendingToRefreshTasks.remove(task);
                        tasksToSynchronize.remove(task);
                        if (!toSync.remove(task) || this.this$0.monitor.isCanceled()) continue;
                        for (CommandProgressListener cmdList : this.this$0.listeners.toArray(new CommandProgressListener[0])) {
                            cmdList.taskSynchronized(accessor.toNbTask(task));
                        }
                        continue;
                    }
                    if (delta.isTransient() || delta.getParent() != this.this$0.query) continue;
                    if (delta.getKind() == TaskContainerDelta.Kind.REMOVED) {
                        for (CommandProgressListener cmdList : this.this$0.listeners.toArray(new CommandProgressListener[0])) {
                            cmdList.taskRemoved(accessor.toNbTask(task));
                        }
                        continue;
                    }
                    if (delta.getKind() != TaskContainerDelta.Kind.ADDED) continue;
                    for (CommandProgressListener cmdList : this.this$0.listeners.toArray(new CommandProgressListener[0])) {
                        cmdList.taskAdded(accessor.toNbTask(task));
                    }
                }
            }
        };
        this.taskList.addChangeListener(list);
        try {
            this.query.setSynchronizing(true);
            pendingToRefreshTasks.addAll(this.query.getChildren());
            for (CommandProgressListener cmdList : this.listeners.toArray(new CommandProgressListener[0])) {
                cmdList.queryRefreshStarted(accessor.toNbTasks(pendingToRefreshTasks));
            }
            job.run(this.monitor);
            this.status = this.query.getStatus();
            if (this.status != null && this.status.getSeverity() == 4) {
                if (this.status.getException() instanceof CoreException) {
                    throw (CoreException)this.status.getException();
                }
                throw new CoreException(this.status);
            }
            if (this.monitor.isCanceled()) {
                return;
            }
            for (ITask task : new ArrayList(tasksToSynchronize)) {
                for (CommandProgressListener cmdList : this.listeners.toArray(new CommandProgressListener[0])) {
                    cmdList.taskSynchronized(accessor.toNbTask(task));
                }
            }
            if (!this.monitor.isCanceled() && !pendingToRefreshTasks.isEmpty()) {
                HashSet<ITask> tasks = new HashSet<ITask>(pendingToRefreshTasks);
                SynchronizeTasksJob syncTasksJob = new SynchronizeTasksJob(this.taskList, this.taskDataManager, (IRepositoryModel)this.repositoryModel, this.repositoryConnector, this.taskRepository, tasks);
                for (ITask t : tasks) {
                    if (!(t instanceof AbstractTask)) continue;
                    ((AbstractTask)t).setSynchronizing(true);
                }
                syncTasksJob.run(this.monitor);
            }
        }
        finally {
            this.taskList.removeChangeListener(list);
        }
    }

    @Override
    public void cancel() {
        this.monitor.setCanceled(true);
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuilder sb = new StringBuilder().append("Synchronizing tasks ").append(this.query).append(",repository=").append(this.taskRepository.getUrl()).append("]");
            this.stringValue = sb.toString();
        }
        return this.stringValue;
    }

    public void addCommandProgressListener(CommandProgressListener list) {
        this.listeners.add(list);
    }

    public void removeCommandProgressListener(CommandProgressListener list) {
        this.listeners.remove(list);
    }

    public IStatus getStatus() {
        return this.status;
    }

    public static interface CommandProgressListener
    extends EventListener {
        public void queryRefreshStarted(Collection<NbTask> var1);

        public void tasksRefreshStarted(Collection<NbTask> var1);

        public void taskAdded(NbTask var1);

        public void taskRemoved(NbTask var1);

        public void taskSynchronized(NbTask var1);
    }
}

