/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.node;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.docker.api.DockerAction;
import org.netbeans.modules.docker.api.DockerInstance;
import org.netbeans.modules.docker.api.DockerTag;
import org.netbeans.modules.docker.ui.node.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class RemoveTagAction
extends NodeAction {
    private static final Logger LOGGER = Logger.getLogger(RemoveTagAction.class.getName());
    private final RequestProcessor requestProcessor = new RequestProcessor(RemoveTagAction.class);

    protected void performAction(Node[] activatedNodes) {
        for (Node node : activatedNodes) {
            final DockerTag tag = (DockerTag)node.getLookup().lookup(DockerTag.class);
            if (tag == null) continue;
            final ProgressHandle handle = ProgressHandle.createHandle((String)Bundle.MSG_RemovingTag(tag.getShortId()));
            handle.start();
            Runnable task = new Runnable(){
                final /* synthetic */ RemoveTagAction this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        DockerInstance instance = tag.getImage().getInstance();
                        DockerAction facade = new DockerAction(instance);
                        facade.remove(tag);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.INFO, null, ex);
                        String msg = ex.getLocalizedMessage();
                        NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)msg, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                    }
                    finally {
                        handle.finish();
                    }
                }
            };
            this.requestProcessor.post(task);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        for (Node node : activatedNodes) {
            if (node.getLookup().lookup(DockerTag.class) != null) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return Bundle.LBL_RemoveTagAction();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

