/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.nodejs.editor.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.javascript2.model.api.JsFunction;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.spi.FunctionArgument;
import org.netbeans.modules.javascript2.model.spi.FunctionInterceptor;
import org.netbeans.modules.javascript2.model.spi.ModelElementFactory;
import org.netbeans.modules.javascript2.nodejs.editor.NodeJsUtils;
import org.netbeans.modules.javascript2.types.api.DeclarationScope;
import org.netbeans.modules.javascript2.types.api.TypeUsage;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.openide.filesystems.FileObject;

public class NodeJsRequireFunctionInterceptor
implements FunctionInterceptor {
    private static final Pattern METHOD_NAME = Pattern.compile("require");

    public Pattern getNamePattern() {
        return METHOD_NAME;
    }

    public Collection<TypeUsage> intercept(Snapshot snapshot, String name, JsObject globalObject, DeclarationScope scope, ModelElementFactory factory, Collection<FunctionArgument> args) {
        FunctionArgument theFirst;
        FileObject fo = globalObject.getFileObject();
        if (fo == null) {
            return Collections.emptyList();
        }
        if (args.size() == 1 && (theFirst = args.iterator().next()).getKind() == FunctionArgument.Kind.STRING) {
            String objectName;
            JsObject jsObject;
            Token token;
            TokenSequence ts;
            String module = (String)theFirst.getValue();
            Source source = snapshot.getSource();
            if (source == null) {
                return Collections.emptyList();
            }
            JsObject requireObject = globalObject.getProperty("require");
            if (requireObject != null) {
                if (!(requireObject instanceof JsFunction)) {
                    JsObject parent = requireObject.getParent();
                    requireObject = factory.newFunction(scope, requireObject.getParent(), requireObject.getName(), new ArrayList());
                    parent.addProperty(requireObject.getName(), requireObject);
                }
                if (requireObject instanceof JsFunction) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("nm$_").append(NodeJsUtils.getModuleName(module)).append('.');
                    ((JsFunction)requireObject).addReturnType(factory.newType(sb.toString() + "exports", -1, true));
                    sb.append("module").append('.').append("exports");
                    ((JsFunction)requireObject).addReturnType(factory.newType(sb.toString(), -1, true));
                }
            }
            if ((ts = LexUtilities.getJsTokenSequence((TokenHierarchy)snapshot.getTokenHierarchy(), (int)theFirst.getOffset())) == null) {
                return Collections.emptyList();
            }
            ts.move(theFirst.getOffset());
            if (ts.moveNext() && (token = LexUtilities.findPreviousIncluding((TokenSequence)ts, Arrays.asList(JsTokenId.IDENTIFIER, JsTokenId.OPERATOR_SEMICOLON))) != null && token.id() == JsTokenId.IDENTIFIER && "require".equals(token.text().toString()) && (token = LexUtilities.findPreviousIncluding((TokenSequence)ts, Arrays.asList(JsTokenId.OPERATOR_ASSIGNMENT, JsTokenId.OPERATOR_SEMICOLON))) != null && token.id() == JsTokenId.OPERATOR_ASSIGNMENT && (token = LexUtilities.findPreviousIncluding((TokenSequence)ts, Arrays.asList(JsTokenId.IDENTIFIER, JsTokenId.OPERATOR_SEMICOLON, JsTokenId.BRACKET_LEFT_BRACKET, JsTokenId.BRACKET_LEFT_CURLY, JsTokenId.BRACKET_LEFT_PAREN))) != null && token.id() == JsTokenId.IDENTIFIER && (jsObject = ((JsObject)scope).getProperty(objectName = token.text().toString())) != null) {
                int assignmentOffset = ts.offset() + token.length();
                ArrayList<TypeUsage> modelTypes = new ArrayList<TypeUsage>();
                StringBuilder sb = new StringBuilder();
                sb.append("nm$_").append(NodeJsUtils.getModuleName(module)).append('.');
                modelTypes.add(factory.newType(sb.toString() + "exports", assignmentOffset, true));
                sb.append("module").append('.').append("exports");
                modelTypes.add(factory.newType(sb.toString(), assignmentOffset, true));
                ts.move(theFirst.getOffset());
                int balance = 1;
                while (ts.moveNext() && balance > 0) {
                    token = ts.token();
                    if (token.id() == JsTokenId.BRACKET_LEFT_PAREN) {
                        ++balance;
                        continue;
                    }
                    if (token.id() != JsTokenId.BRACKET_RIGHT_PAREN) continue;
                    --balance;
                }
                ts.movePrevious();
                token = LexUtilities.findNextIncluding((TokenSequence)ts, Arrays.asList(JsTokenId.IDENTIFIER, JsTokenId.OPERATOR_SEMICOLON, JsTokenId.OPERATOR_DOT));
                if (token != null && token.id() != JsTokenId.OPERATOR_DOT) {
                    TypeUsage assignment;
                    Collection assignments = jsObject.getAssignments();
                    if (assignments.size() == 1 && (assignment = (TypeUsage)assignments.iterator().next()).getType().endsWith("require")) {
                        jsObject.clearAssignments();
                    }
                    jsObject.addAssignment((TypeUsage)modelTypes.get(0), assignmentOffset);
                    jsObject.addAssignment((TypeUsage)modelTypes.get(1), assignmentOffset);
                }
                return modelTypes;
            }
        }
        return Collections.emptyList();
    }
}

