/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public final class J2SEProjectConfigurations {
    J2SEProjectConfigurations() {
    }

    public static void createConfigurationFiles(Project prj, String configName, final EditableProperties sharedProps, final EditableProperties privateProps) throws IOException, IllegalArgumentException {
        if (prj == null || configName == null || "".equals(configName)) {
            throw new IllegalArgumentException();
        }
        final String configFileName = configName + ".properties";
        final FileObject prjDir = prj.getProjectDirectory();
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    prjDir.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){
                        final /* synthetic */ 1 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void run() throws IOException {
                            J2SEProjectConfigurations.generateConfig(prjDir, "nbproject/configs/" + configFileName, sharedProps);
                            J2SEProjectConfigurations.generateConfig(prjDir, "nbproject/private/configs/" + configFileName, privateProps);
                        }
                    });
                    return null;
                }
            });
        }
        catch (MutexException ex) {
            throw (IOException)ex.getException();
        }
    }

    public static void createConfigurationFiles(Project prj, String configName, Properties sharedProps, Properties privateProps) throws IOException, IllegalArgumentException {
        J2SEProjectConfigurations.createConfigurationFiles(prj, configName, J2SEProjectConfigurations.props2EditableProps(sharedProps), J2SEProjectConfigurations.props2EditableProps(privateProps));
    }

    private static void generateConfig(FileObject prjDir, String cfgFilePath, EditableProperties propsToWrite) throws IOException {
        if (propsToWrite == null) {
            return;
        }
        FileObject jwsConfigFO = FileUtil.createData((FileObject)prjDir, (String)cfgFilePath);
        Properties props = new Properties();
        InputStream is = jwsConfigFO.getInputStream();
        props.load(is);
        is.close();
        if (props.equals(propsToWrite)) {
            return;
        }
        OutputStream os = jwsConfigFO.getOutputStream();
        propsToWrite.store(os);
        os.close();
    }

    private static EditableProperties props2EditableProps(Properties props) {
        if (props == null) {
            return null;
        }
        EditableProperties edProps = new EditableProperties(true);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            edProps.put((String)entry.getKey(), (String)entry.getValue());
        }
        return edProps;
    }
}

