/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class Variable
extends VariableBase {
    private Expression name;
    private boolean isDollared;

    protected Variable(int start, int end, Expression variableName, boolean isDollared) {
        super(start, end);
        this.name = variableName;
        this.isDollared = isDollared;
    }

    protected Variable(int start, int end, Expression variableName) {
        this(start, end, variableName, false);
    }

    public Variable(int start, int end, String variableName) {
        this(start, end, Variable.createIdentifier(start, end, variableName), Variable.checkIsDollared(variableName));
    }

    private static Identifier createIdentifier(int start, int end, String idName) {
        if (Variable.checkIsDollared(idName)) {
            idName = idName.substring(1);
            ++start;
        }
        return new Identifier(start, end, idName);
    }

    private static boolean checkIsDollared(String variableName) {
        return variableName.indexOf(36) == 0;
    }

    public Expression getName() {
        return this.name;
    }

    public boolean isDollared() {
        return this.isDollared;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return (this.isDollared() ? "$" : "") + String.valueOf(this.getName());
    }
}

