/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.ui.wizards.CloneDestinationDirectoryPanel;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;

public class CloneDestinationDirectoryWizardPanel
implements WizardDescriptor.Panel,
DocumentListener {
    static final String CLONE_TARGET_DIRECTORY = "cloneDestinationStep.cloneDirectory";
    private CloneDestinationDirectoryPanel component;
    private boolean valid;
    private String errorMessage;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public Component getComponent() {
        if (this.component == null) {
            this.component = new CloneDestinationDirectoryPanel();
            this.component.directoryField.getDocument().addDocumentListener(this);
            this.component.nameField.getDocument().addDocumentListener(this);
            this.valid();
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(CloneDestinationDirectoryWizardPanel.class);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.textChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.textChanged(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.textChanged(e);
    }

    private void textChanged(final DocumentEvent e) {
        Runnable awt = new Runnable(){
            final /* synthetic */ CloneDestinationDirectoryWizardPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (e.getDocument() == ((CloneDestinationDirectoryWizardPanel)this.this$0).component.nameField.getDocument() || e.getDocument() == ((CloneDestinationDirectoryWizardPanel)this.this$0).component.directoryField.getDocument()) {
                    if (this.this$0.component.isInputValid()) {
                        this.this$0.valid(this.this$0.component.getMessage());
                    } else {
                        this.this$0.invalid(this.this$0.component.getMessage());
                    }
                }
            }
        };
        SwingUtilities.invokeLater(awt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    protected final void valid() {
        this.setValid(true, null);
    }

    protected final void valid(String extErrorMessage) {
        this.setValid(true, extErrorMessage);
    }

    protected final void invalid(String message) {
        this.setValid(false, message);
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    private void setValid(boolean valid, String errorMessage) {
        boolean fire = this.valid != valid;
        boolean bl = errorMessage != null && !errorMessage.equals(this.errorMessage);
        this.valid = valid;
        this.errorMessage = errorMessage;
        if (fire |= bl) {
            this.fireChangeEvent();
        }
    }

    public void readSettings(Object settings) {
        if (settings instanceof WizardDescriptor) {
            HgURL repository = (HgURL)((WizardDescriptor)settings).getProperty("repository");
            this.component.nameField.setText(new File(repository.getPath()).getName());
        }
    }

    public void storeSettings(Object settings) {
        if (settings instanceof WizardDescriptor) {
            String directory = this.component.getDirectory();
            String cloneName = this.component.getCloneName();
            ((WizardDescriptor)settings).putProperty("directory", (Object)directory);
            ((WizardDescriptor)settings).putProperty("cloneName", (Object)cloneName);
        }
    }
}

