/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geo.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.geo.search.aggregations.bucket.geogrid.BaseGeoGridBucket;
import org.opensearch.geo.search.aggregations.bucket.geogrid.GeoGridAggregator;
import org.opensearch.geo.search.aggregations.bucket.geogrid.GeoHashGrid;
import org.opensearch.geo.search.aggregations.bucket.geogrid.InternalGeoHashGridBucket;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.internal.SearchContext;

class GeoHashGridAggregator
extends GeoGridAggregator<GeoHashGrid> {
    GeoHashGridAggregator(String name, AggregatorFactories factories, ValuesSource.Numeric valuesSource, int requiredSize, int shardSize, SearchContext aggregationContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, valuesSource, requiredSize, shardSize, aggregationContext, parent, cardinality, metadata);
    }

    @Override
    protected GeoHashGrid buildAggregation(String name, int requiredSize, List<BaseGeoGridBucket> buckets, Map<String, Object> metadata) {
        return new GeoHashGrid(name, requiredSize, buckets, metadata);
    }

    @Override
    public GeoHashGrid buildEmptyAggregation() {
        return new GeoHashGrid(this.name, this.requiredSize, Collections.emptyList(), this.metadata());
    }

    @Override
    protected BaseGeoGridBucket newEmptyBucket() {
        return new InternalGeoHashGridBucket(0L, 0L, null);
    }
}

