/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.spec;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;

public class DHUParameterSpec
implements AlgorithmParameterSpec {
    private final PublicKey ephemeralPublicKey;
    private final PrivateKey ephemeralPrivateKey;
    private final PublicKey otherPartyEphemeralKey;
    private final AlgorithmParameterSpec kdfParameterSpec;

    public DHUParameterSpec(PublicKey publicKey, PrivateKey privateKey, PublicKey publicKey2, AlgorithmParameterSpec algorithmParameterSpec) {
        if (privateKey == null) {
            throw new IllegalArgumentException("ephemeral private key cannot be null");
        }
        if (publicKey2 == null) {
            throw new IllegalArgumentException("other party ephemeral key cannot be null");
        }
        this.ephemeralPublicKey = publicKey;
        this.ephemeralPrivateKey = privateKey;
        this.otherPartyEphemeralKey = publicKey2;
        this.kdfParameterSpec = algorithmParameterSpec;
    }

    public DHUParameterSpec(PublicKey publicKey, PrivateKey privateKey, PublicKey publicKey2, byte[] byArray) {
        this(publicKey, privateKey, publicKey2, byArray != null ? new UserKeyingMaterialSpec(byArray) : null);
    }

    public DHUParameterSpec(PublicKey publicKey, PrivateKey privateKey, PublicKey publicKey2) {
        this(publicKey, privateKey, publicKey2, (AlgorithmParameterSpec)null);
    }

    public DHUParameterSpec(KeyPair keyPair, PublicKey publicKey, byte[] byArray) {
        this(keyPair.getPublic(), keyPair.getPrivate(), publicKey, byArray);
    }

    public DHUParameterSpec(PrivateKey privateKey, PublicKey publicKey, byte[] byArray) {
        this(null, privateKey, publicKey, byArray);
    }

    public DHUParameterSpec(PrivateKey privateKey, PublicKey publicKey, AlgorithmParameterSpec algorithmParameterSpec) {
        this(null, privateKey, publicKey, algorithmParameterSpec);
    }

    public DHUParameterSpec(KeyPair keyPair, PublicKey publicKey) {
        this(keyPair.getPublic(), keyPair.getPrivate(), publicKey, (AlgorithmParameterSpec)null);
    }

    public DHUParameterSpec(PrivateKey privateKey, PublicKey publicKey) {
        this(null, privateKey, publicKey, (AlgorithmParameterSpec)null);
    }

    public PrivateKey getEphemeralPrivateKey() {
        return this.ephemeralPrivateKey;
    }

    public PublicKey getEphemeralPublicKey() {
        return this.ephemeralPublicKey;
    }

    public PublicKey getOtherPartyEphemeralKey() {
        return this.otherPartyEphemeralKey;
    }

    public byte[] getUserKeyingMaterial() {
        if (this.kdfParameterSpec instanceof UserKeyingMaterialSpec) {
            return ((UserKeyingMaterialSpec)this.kdfParameterSpec).getUserKeyingMaterial();
        }
        return null;
    }

    public AlgorithmParameterSpec getKdfParameterSpec() {
        return this.kdfParameterSpec;
    }
}

