/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.api.model.BalanceShardUniqueRequestBody;
import org.apache.solr.client.api.model.CollectionStatusResponse;
import org.apache.solr.client.api.model.CreateCollectionRequestBody;
import org.apache.solr.client.api.model.CreateCollectionRouterProperties;
import org.apache.solr.client.api.model.ReloadCollectionRequestBody;
import org.apache.solr.client.api.model.RenameCollectionRequestBody;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class CollectionsApi {

    public static class RenameCollection
    extends SolrRequest<RenameCollectionResponse> {
        private final RenameCollectionRequestBody requestBody;
        private final String collectionName;

        public RenameCollection(String collectionName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/collections/{collectionName}/rename".replace("{collectionName}", collectionName));
            this.collectionName = collectionName;
            this.requestBody = new RenameCollectionRequestBody();
        }

        public void setTo(String to) {
            this.requestBody.to = to;
        }

        public void setFollowAliases(Boolean followAliases) {
            this.requestBody.followAliases = followAliases;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
            return new JacksonContentWriter(this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected RenameCollectionResponse createResponse(SolrClient client) {
            return new RenameCollectionResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class RenameCollectionResponse
    extends JacksonParsingResponse<SubResponseAccumulatingJerseyResponse> {
        public RenameCollectionResponse() {
            super(SubResponseAccumulatingJerseyResponse.class);
        }
    }

    public static class ReloadCollection
    extends SolrRequest<ReloadCollectionResponse> {
        private final ReloadCollectionRequestBody requestBody;
        private final String collectionName;

        public ReloadCollection(String collectionName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/collections/{collectionName}/reload".replace("{collectionName}", collectionName));
            this.collectionName = collectionName;
            this.requestBody = new ReloadCollectionRequestBody();
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
            return new JacksonContentWriter(this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected ReloadCollectionResponse createResponse(SolrClient client) {
            return new ReloadCollectionResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class ReloadCollectionResponse
    extends JacksonParsingResponse<SubResponseAccumulatingJerseyResponse> {
        public ReloadCollectionResponse() {
            super(SubResponseAccumulatingJerseyResponse.class);
        }
    }

    public static class ListCollections
    extends SolrRequest<ListCollectionsResponse> {
        public ListCollections() {
            super(SolrRequest.METHOD.valueOf("GET"), "/collections");
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected ListCollectionsResponse createResponse(SolrClient client) {
            return new ListCollectionsResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class ListCollectionsResponse
    extends JacksonParsingResponse<org.apache.solr.client.api.model.ListCollectionsResponse> {
        public ListCollectionsResponse() {
            super(org.apache.solr.client.api.model.ListCollectionsResponse.class);
        }
    }

    public static class GetCollectionStatus
    extends SolrRequest<GetCollectionStatusResponse> {
        private final String collectionName;
        private Boolean coreInfo;
        private Boolean segments;
        private Boolean fieldInfo;
        private Boolean rawSize;
        private Boolean rawSizeSummary;
        private Boolean rawSizeDetails;
        private Float rawSizeSamplingPercent;
        private Boolean sizeInfo;

        public GetCollectionStatus(String collectionName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/collections/{collectionName}".replace("{collectionName}", collectionName));
            this.collectionName = collectionName;
        }

        public void setCoreInfo(Boolean coreInfo) {
            this.coreInfo = coreInfo;
        }

        public void setSegments(Boolean segments) {
            this.segments = segments;
        }

        public void setFieldInfo(Boolean fieldInfo) {
            this.fieldInfo = fieldInfo;
        }

        public void setRawSize(Boolean rawSize) {
            this.rawSize = rawSize;
        }

        public void setRawSizeSummary(Boolean rawSizeSummary) {
            this.rawSizeSummary = rawSizeSummary;
        }

        public void setRawSizeDetails(Boolean rawSizeDetails) {
            this.rawSizeDetails = rawSizeDetails;
        }

        public void setRawSizeSamplingPercent(Float rawSizeSamplingPercent) {
            this.rawSizeSamplingPercent = rawSizeSamplingPercent;
        }

        public void setSizeInfo(Boolean sizeInfo) {
            this.sizeInfo = sizeInfo;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.coreInfo != null) {
                params.add("coreInfo", this.coreInfo.toString());
            }
            if (this.segments != null) {
                params.add("segments", this.segments.toString());
            }
            if (this.fieldInfo != null) {
                params.add("fieldInfo", this.fieldInfo.toString());
            }
            if (this.rawSize != null) {
                params.add("rawSize", this.rawSize.toString());
            }
            if (this.rawSizeSummary != null) {
                params.add("rawSizeSummary", this.rawSizeSummary.toString());
            }
            if (this.rawSizeDetails != null) {
                params.add("rawSizeDetails", this.rawSizeDetails.toString());
            }
            if (this.rawSizeSamplingPercent != null) {
                params.add("rawSizeSamplingPercent", this.rawSizeSamplingPercent.toString());
            }
            if (this.sizeInfo != null) {
                params.add("sizeInfo", this.sizeInfo.toString());
            }
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            queryParams.add("coreInfo");
            queryParams.add("segments");
            queryParams.add("fieldInfo");
            queryParams.add("rawSize");
            queryParams.add("rawSizeSummary");
            queryParams.add("rawSizeDetails");
            queryParams.add("rawSizeSamplingPercent");
            queryParams.add("sizeInfo");
            return queryParams;
        }

        @Override
        protected GetCollectionStatusResponse createResponse(SolrClient client) {
            return new GetCollectionStatusResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetCollectionStatusResponse
    extends JacksonParsingResponse<CollectionStatusResponse> {
        public GetCollectionStatusResponse() {
            super(CollectionStatusResponse.class);
        }
    }

    public static class DeleteCollection
    extends SolrRequest<DeleteCollectionResponse> {
        private final String collectionName;
        private Boolean followAliases;
        private String async;

        public DeleteCollection(String collectionName) {
            super(SolrRequest.METHOD.valueOf("DELETE"), "/collections/{collectionName}".replace("{collectionName}", collectionName));
            this.collectionName = collectionName;
        }

        public void setFollowAliases(Boolean followAliases) {
            this.followAliases = followAliases;
        }

        public void setAsync(String async) {
            this.async = async;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.followAliases != null) {
                params.add("followAliases", this.followAliases.toString());
            }
            if (this.async != null) {
                params.add("async", this.async);
            }
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            queryParams.add("followAliases");
            queryParams.add("async");
            return queryParams;
        }

        @Override
        protected DeleteCollectionResponse createResponse(SolrClient client) {
            return new DeleteCollectionResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class DeleteCollectionResponse
    extends JacksonParsingResponse<SubResponseAccumulatingJerseyResponse> {
        public DeleteCollectionResponse() {
            super(SubResponseAccumulatingJerseyResponse.class);
        }
    }

    public static class CreateCollection
    extends SolrRequest<CreateCollectionResponse> {
        private final CreateCollectionRequestBody requestBody = new CreateCollectionRequestBody();

        public CreateCollection() {
            super(SolrRequest.METHOD.valueOf("POST"), "/collections");
        }

        public void setName(String name) {
            this.requestBody.name = name;
        }

        public void setReplicationFactor(Integer replicationFactor) {
            this.requestBody.replicationFactor = replicationFactor;
        }

        public void setConfig(String config) {
            this.requestBody.config = config;
        }

        public void setNumShards(Integer numShards) {
            this.requestBody.numShards = numShards;
        }

        public void setShardNames(List<String> shardNames) {
            this.requestBody.shardNames = shardNames;
        }

        public void setPullReplicas(Integer pullReplicas) {
            this.requestBody.pullReplicas = pullReplicas;
        }

        public void setTlogReplicas(Integer tlogReplicas) {
            this.requestBody.tlogReplicas = tlogReplicas;
        }

        public void setNrtReplicas(Integer nrtReplicas) {
            this.requestBody.nrtReplicas = nrtReplicas;
        }

        public void setWaitForFinalState(Boolean waitForFinalState) {
            this.requestBody.waitForFinalState = waitForFinalState;
        }

        public void setPerReplicaState(Boolean perReplicaState) {
            this.requestBody.perReplicaState = perReplicaState;
        }

        public void setAlias(String alias) {
            this.requestBody.alias = alias;
        }

        public void setProperties(Map<String, String> properties) {
            this.requestBody.properties = properties;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        public void setRouter(CreateCollectionRouterProperties router) {
            this.requestBody.router = router;
        }

        public void setNodeSet(List<String> nodeSet) {
            this.requestBody.nodeSet = nodeSet;
        }

        public void setCreateReplicas(Boolean createReplicas) {
            this.requestBody.createReplicas = createReplicas;
        }

        public void setShuffleNodes(Boolean shuffleNodes) {
            this.requestBody.shuffleNodes = shuffleNodes;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
            return new JacksonContentWriter(this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected CreateCollectionResponse createResponse(SolrClient client) {
            return new CreateCollectionResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class CreateCollectionResponse
    extends JacksonParsingResponse<SubResponseAccumulatingJerseyResponse> {
        public CreateCollectionResponse() {
            super(SubResponseAccumulatingJerseyResponse.class);
        }
    }

    public static class BalanceShardUnique
    extends SolrRequest<BalanceShardUniqueResponse> {
        private final BalanceShardUniqueRequestBody requestBody;
        private final String collectionName;

        public BalanceShardUnique(String collectionName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/collections/{collectionName}/balance-shard-unique".replace("{collectionName}", collectionName));
            this.collectionName = collectionName;
            this.requestBody = new BalanceShardUniqueRequestBody();
        }

        public void setProperty(String property) {
            this.requestBody.property = property;
        }

        public void setOnlyActiveNodes(Boolean onlyActiveNodes) {
            this.requestBody.onlyActiveNodes = onlyActiveNodes;
        }

        public void setShardUnique(Boolean shardUnique) {
            this.requestBody.shardUnique = shardUnique;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
            return new JacksonContentWriter(this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected BalanceShardUniqueResponse createResponse(SolrClient client) {
            return new BalanceShardUniqueResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class BalanceShardUniqueResponse
    extends JacksonParsingResponse<SubResponseAccumulatingJerseyResponse> {
        public BalanceShardUniqueResponse() {
            super(SubResponseAccumulatingJerseyResponse.class);
        }
    }
}

