﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codeartifact/CodeArtifact_EXPORTS.h>
#include <aws/codeartifact/model/PackageSummary.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CodeArtifact {
namespace Model {
class DeletePackageResult {
 public:
  AWS_CODEARTIFACT_API DeletePackageResult() = default;
  AWS_CODEARTIFACT_API DeletePackageResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CODEARTIFACT_API DeletePackageResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{

  inline const PackageSummary& GetDeletedPackage() const { return m_deletedPackage; }
  template <typename DeletedPackageT = PackageSummary>
  void SetDeletedPackage(DeletedPackageT&& value) {
    m_deletedPackageHasBeenSet = true;
    m_deletedPackage = std::forward<DeletedPackageT>(value);
  }
  template <typename DeletedPackageT = PackageSummary>
  DeletePackageResult& WithDeletedPackage(DeletedPackageT&& value) {
    SetDeletedPackage(std::forward<DeletedPackageT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DeletePackageResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  PackageSummary m_deletedPackage;

  Aws::String m_requestId;
  bool m_deletedPackageHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodeArtifact
}  // namespace Aws
