﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codedeploy/CodeDeploy_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CodeDeploy {
namespace Model {
/**
 * <p>Represents the output of a <code>ListDeployments</code>
 * operation.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentsOutput">AWS
 * API Reference</a></p>
 */
class ListDeploymentsResult {
 public:
  AWS_CODEDEPLOY_API ListDeploymentsResult() = default;
  AWS_CODEDEPLOY_API ListDeploymentsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CODEDEPLOY_API ListDeploymentsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of deployment IDs.</p>
   */
  inline const Aws::Vector<Aws::String>& GetDeployments() const { return m_deployments; }
  template <typename DeploymentsT = Aws::Vector<Aws::String>>
  void SetDeployments(DeploymentsT&& value) {
    m_deploymentsHasBeenSet = true;
    m_deployments = std::forward<DeploymentsT>(value);
  }
  template <typename DeploymentsT = Aws::Vector<Aws::String>>
  ListDeploymentsResult& WithDeployments(DeploymentsT&& value) {
    SetDeployments(std::forward<DeploymentsT>(value));
    return *this;
  }
  template <typename DeploymentsT = Aws::String>
  ListDeploymentsResult& AddDeployments(DeploymentsT&& value) {
    m_deploymentsHasBeenSet = true;
    m_deployments.emplace_back(std::forward<DeploymentsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If a large amount of information is returned, an identifier is also returned.
   * It can be used in a subsequent list deployments call to return the next set of
   * deployments in the list.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListDeploymentsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListDeploymentsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_deployments;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_deploymentsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodeDeploy
}  // namespace Aws
