﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connect/Connect_EXPORTS.h>
#include <aws/connect/model/QuickConnectConfig.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Connect {
namespace Model {

/**
 * <p>Contains information about a quick connect.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/QuickConnect">AWS
 * API Reference</a></p>
 */
class QuickConnect {
 public:
  AWS_CONNECT_API QuickConnect() = default;
  AWS_CONNECT_API QuickConnect(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECT_API QuickConnect& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the quick connect.</p>
   */
  inline const Aws::String& GetQuickConnectARN() const { return m_quickConnectARN; }
  inline bool QuickConnectARNHasBeenSet() const { return m_quickConnectARNHasBeenSet; }
  template <typename QuickConnectARNT = Aws::String>
  void SetQuickConnectARN(QuickConnectARNT&& value) {
    m_quickConnectARNHasBeenSet = true;
    m_quickConnectARN = std::forward<QuickConnectARNT>(value);
  }
  template <typename QuickConnectARNT = Aws::String>
  QuickConnect& WithQuickConnectARN(QuickConnectARNT&& value) {
    SetQuickConnectARN(std::forward<QuickConnectARNT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier for the quick connect.</p>
   */
  inline const Aws::String& GetQuickConnectId() const { return m_quickConnectId; }
  inline bool QuickConnectIdHasBeenSet() const { return m_quickConnectIdHasBeenSet; }
  template <typename QuickConnectIdT = Aws::String>
  void SetQuickConnectId(QuickConnectIdT&& value) {
    m_quickConnectIdHasBeenSet = true;
    m_quickConnectId = std::forward<QuickConnectIdT>(value);
  }
  template <typename QuickConnectIdT = Aws::String>
  QuickConnect& WithQuickConnectId(QuickConnectIdT&& value) {
    SetQuickConnectId(std::forward<QuickConnectIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the quick connect.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  QuickConnect& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  QuickConnect& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Contains information about the quick connect.</p>
   */
  inline const QuickConnectConfig& GetQuickConnectConfig() const { return m_quickConnectConfig; }
  inline bool QuickConnectConfigHasBeenSet() const { return m_quickConnectConfigHasBeenSet; }
  template <typename QuickConnectConfigT = QuickConnectConfig>
  void SetQuickConnectConfig(QuickConnectConfigT&& value) {
    m_quickConnectConfigHasBeenSet = true;
    m_quickConnectConfig = std::forward<QuickConnectConfigT>(value);
  }
  template <typename QuickConnectConfigT = QuickConnectConfig>
  QuickConnect& WithQuickConnectConfig(QuickConnectConfigT&& value) {
    SetQuickConnectConfig(std::forward<QuickConnectConfigT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The tags used to organize, track, or control access for this resource. For
   * example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  QuickConnect& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  QuickConnect& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp when this resource was last modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedTime() const { return m_lastModifiedTime; }
  inline bool LastModifiedTimeHasBeenSet() const { return m_lastModifiedTimeHasBeenSet; }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  void SetLastModifiedTime(LastModifiedTimeT&& value) {
    m_lastModifiedTimeHasBeenSet = true;
    m_lastModifiedTime = std::forward<LastModifiedTimeT>(value);
  }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  QuickConnect& WithLastModifiedTime(LastModifiedTimeT&& value) {
    SetLastModifiedTime(std::forward<LastModifiedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Web Services Region where this resource was last modified.</p>
   */
  inline const Aws::String& GetLastModifiedRegion() const { return m_lastModifiedRegion; }
  inline bool LastModifiedRegionHasBeenSet() const { return m_lastModifiedRegionHasBeenSet; }
  template <typename LastModifiedRegionT = Aws::String>
  void SetLastModifiedRegion(LastModifiedRegionT&& value) {
    m_lastModifiedRegionHasBeenSet = true;
    m_lastModifiedRegion = std::forward<LastModifiedRegionT>(value);
  }
  template <typename LastModifiedRegionT = Aws::String>
  QuickConnect& WithLastModifiedRegion(LastModifiedRegionT&& value) {
    SetLastModifiedRegion(std::forward<LastModifiedRegionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_quickConnectARN;

  Aws::String m_quickConnectId;

  Aws::String m_name;

  Aws::String m_description;

  QuickConnectConfig m_quickConnectConfig;

  Aws::Map<Aws::String, Aws::String> m_tags;

  Aws::Utils::DateTime m_lastModifiedTime{};

  Aws::String m_lastModifiedRegion;
  bool m_quickConnectARNHasBeenSet = false;
  bool m_quickConnectIdHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_quickConnectConfigHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_lastModifiedTimeHasBeenSet = false;
  bool m_lastModifiedRegionHasBeenSet = false;
};

}  // namespace Model
}  // namespace Connect
}  // namespace Aws
