/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.freeplane.api.Dash;
import org.freeplane.core.resources.components.ComboProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.features.DashRenderedContent;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.edge.EdgeModel;
import org.freeplane.features.edge.mindmapmode.MEdgeController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

public class EdgeDashControlGroup
implements ControlGroup {
    private static final String REVERT_EDGE = "revert-edge";
    private static final String EDGE_DASH = "edgedash";
    private RevertingProperty mSetEdgeDash;
    private ComboProperty mEdgeDash;
    private EdgeDashChangeListener propertyChangeListener;

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.propertyChangeListener.setStyle(node);
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetEdgeDash = new RevertingProperty(REVERT_EDGE);
        this.mEdgeDash = ComboProperty.of((String)EDGE_DASH, Dash.class, DashRenderedContent::of);
        this.propertyChangeListener = new EdgeDashChangeListener(this.mSetEdgeDash, (IPropertyControl)this.mEdgeDash);
        this.mSetEdgeDash.addPropertyChangeListener(this.propertyChangeListener);
        this.mEdgeDash.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mEdgeDash.appendToForm(formBuilder);
        this.mSetEdgeDash.appendToForm(formBuilder);
    }

    private class EdgeDashChangeListener
    extends ControlGroupChangeListener {
        public EdgeDashChangeListener(RevertingProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MEdgeController styleController = (MEdgeController)Controller.getCurrentModeController().getExtension(EdgeController.class);
            styleController.setDash(node, enabled ? Dash.valueOf((String)EdgeDashControlGroup.this.mEdgeDash.getValue()) : null);
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            EdgeController edgeController = EdgeController.getController();
            EdgeModel edgeModel = EdgeModel.getModel((NodeModel)node);
            Dash dash = edgeModel != null ? edgeModel.getDash() : null;
            Dash viewDash = edgeController.getDash(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            EdgeDashControlGroup.this.mSetEdgeDash.setValue(dash != null);
            EdgeDashControlGroup.this.mEdgeDash.setValue(viewDash.name());
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, EdgeDashControlGroup.this.mSetEdgeDash);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)EdgeDashControlGroup.this.mEdgeDash);
        }
    }
}

